/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.process;

import android.content.Context;
import java.util.List;
import java.util.Map;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.imgproc.Imgproc;
import uk.ac.horizon.artcodes.detect.DetectorSetting;
import uk.ac.horizon.artcodes.detect.ImageBuffers;
import uk.ac.horizon.artcodes.detect.handler.MarkerDetectionHandler;
import uk.ac.horizon.artcodes.model.Experience;
import uk.ac.horizon.artcodes.process.ImageProcessor;
import uk.ac.horizon.artcodes.process.ImageProcessorFactory;

public class HlsEditImageProcessor
implements ImageProcessor {
    protected final int hueShift;
    protected final int lightnessAddition;
    protected final int saturationAddition;
    protected final Mat lut;

    public HlsEditImageProcessor(int hueShift, int lightnessAddition, int saturationAddition) {
        this.hueShift = hueShift / 2 % 181;
        this.lightnessAddition = Math.min(Math.max((int)((double)lightnessAddition * 2.55), -255), 255);
        this.saturationAddition = Math.min(Math.max((int)((double)saturationAddition * 2.55), -255), 255);
        float lightnessMultiplyer = ((float)this.lightnessAddition + 255.0f) / 255.0f;
        float saturationMultiplyer = ((float)this.lightnessAddition + 255.0f) / 255.0f;
        this.lut = new Mat(1, 256, CvType.CV_8UC3);
        int lutSize = this.lut.cols() * this.lut.rows() * this.lut.channels();
        byte[] lutBuffer = new byte[lutSize];
        int lutIndex = -1;
        for (int i = 0; i < 256; ++i) {
            lutBuffer[++lutIndex] = (byte)((i + this.hueShift) % 181);
            lutBuffer[++lutIndex] = (byte)Math.min(Math.max((int)((float)i * lightnessMultiplyer), 0), 255);
            lutBuffer[++lutIndex] = (byte)Math.min(Math.max((int)((float)i * saturationMultiplyer), 0), 255);
        }
        this.lut.put(0, 0, lutBuffer);
    }

    @Override
    public void process(ImageBuffers buffers) {
        if (this.hueShift != 0 || this.lightnessAddition != 0 || this.saturationAddition != 0) {
            Mat threeChannelBuffer = buffers.getImageInBgr();
            Imgproc.cvtColor((Mat)threeChannelBuffer, (Mat)threeChannelBuffer, (int)52);
            Core.LUT((Mat)threeChannelBuffer, (Mat)this.lut, (Mat)threeChannelBuffer);
            Imgproc.cvtColor((Mat)threeChannelBuffer, (Mat)threeChannelBuffer, (int)60);
            buffers.setImage(threeChannelBuffer);
        }
    }

    @Override
    public void getSettings(List<DetectorSetting> settings) {
    }

    public void release() {
        this.lut.release();
    }

    public static class HlsEditImageProcessorFactory
    implements ImageProcessorFactory {
        private static final String[] HUE_KEYS = new String[]{"hue", "hueShift", "h"};
        private static final String[] LIGHTNESS_KEYS = new String[]{"lightness", "l"};
        private static final String[] SATURATION_KEYS = new String[]{"saturation", "s"};

        @Override
        public String getName() {
            return "hlsEdit";
        }

        @Override
        public ImageProcessor create(Context context, Experience experience, MarkerDetectionHandler handler, Map<String, String> args) {
            int hueShift = 0;
            int lightnessAddition = 0;
            int saturationAddition = 0;
            if (args != null) {
                for (String key : HUE_KEYS) {
                    if (!args.containsKey(key)) continue;
                    hueShift = Integer.parseInt(args.get(key));
                }
                for (String key : LIGHTNESS_KEYS) {
                    if (!args.containsKey(key)) continue;
                    lightnessAddition = Integer.parseInt(args.get(key));
                }
                for (String key : SATURATION_KEYS) {
                    if (!args.containsKey(key)) continue;
                    saturationAddition = Integer.parseInt(args.get(key));
                }
            }
            return new HlsEditImageProcessor(hueShift, lightnessAddition, saturationAddition);
        }
    }
}

