/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.detect.marker;

import android.content.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import uk.ac.horizon.artcodes.detect.handler.MarkerDetectionHandler;
import uk.ac.horizon.artcodes.detect.marker.Marker;
import uk.ac.horizon.artcodes.detect.marker.MarkerDetector;
import uk.ac.horizon.artcodes.detect.marker.MarkerRegion;
import uk.ac.horizon.artcodes.detect.marker.MarkerWithEmbeddedChecksum;
import uk.ac.horizon.artcodes.model.Experience;
import uk.ac.horizon.artcodes.process.ImageProcessor;
import uk.ac.horizon.artcodes.process.ImageProcessorFactory;

public class MarkerEmbeddedChecksumDetector
extends MarkerDetector {
    private boolean embeddedChecksumRequired;
    private boolean relaxedEmbeddedChecksumIgnoreNonHollowDots;
    private boolean relaxedEmbeddedChecksumIgnoreMultipleHollowSegments;

    public MarkerEmbeddedChecksumDetector(Experience experience, MarkerDetectionHandler handler, boolean embeddedChecksumRequired, boolean relaxed) {
        super(experience, handler);
        this.embeddedChecksumRequired = embeddedChecksumRequired;
        this.relaxedEmbeddedChecksumIgnoreNonHollowDots = this.relaxedEmbeddedChecksumIgnoreMultipleHollowSegments = relaxed;
    }

    @Override
    protected Marker createMarkerForNode(int nodeIndex, List<MatOfPoint> contours, Mat hierarchy) {
        ArrayList<MarkerRegion> regions = null;
        MarkerRegion checksumRegion = null;
        int currentNodeIndex = (int)hierarchy.get(0, nodeIndex)[2];
        while (currentNodeIndex >= 0) {
            MarkerRegion region = this.createRegionForNode(currentNodeIndex, contours, hierarchy);
            if (region != null) {
                if (!this.ignoreEmptyRegions || region.value != 0) {
                    if (regions == null) {
                        regions = new ArrayList<MarkerRegion>();
                    } else if (regions.size() >= this.maxRegions) {
                        return null;
                    }
                    regions.add(region);
                }
            } else if (checksumRegion == null) {
                checksumRegion = this.getChecksumRegionAtNode(currentNodeIndex, hierarchy);
                if (checksumRegion == null) {
                    return null;
                }
            } else {
                return null;
            }
            currentNodeIndex = (int)hierarchy.get(0, currentNodeIndex)[0];
        }
        if (regions != null) {
            MarkerWithEmbeddedChecksum marker = new MarkerWithEmbeddedChecksum(nodeIndex, regions, checksumRegion);
            this.sortCode(marker);
            if (this.isValidRegionList(marker)) {
                return marker;
            }
        }
        return null;
    }

    protected MarkerRegion getChecksumRegionAtNode(int regionIndex, Mat hierarchy) {
        double[] nodes = hierarchy.get(0, regionIndex);
        int currentDotIndex = (int)nodes[2];
        if (currentDotIndex < 0) {
            return null;
        }
        int dotCount = 0;
        while (currentDotIndex >= 0) {
            if (this.isValidHollowDot(currentDotIndex, hierarchy)) {
                ++dotCount;
            } else if (!this.relaxedEmbeddedChecksumIgnoreNonHollowDots || !this.isValidDot(currentDotIndex, hierarchy)) {
                return null;
            }
            nodes = hierarchy.get(0, currentDotIndex);
            currentDotIndex = (int)nodes[0];
        }
        return new MarkerRegion(regionIndex, dotCount);
    }

    private boolean isValidHollowDot(int nodeIndex, Mat hierarchy) {
        double[] nodes = hierarchy.get(0, nodeIndex);
        return nodes[2] >= 0.0 && (hierarchy.get(0, (int)nodes[2])[0] < 0.0 || this.relaxedEmbeddedChecksumIgnoreMultipleHollowSegments) && this.isValidDot((int)nodes[2], hierarchy);
    }

    @Override
    protected boolean hasValidChecksum(Marker marker) {
        if (marker instanceof MarkerWithEmbeddedChecksum) {
            MarkerWithEmbeddedChecksum markerEc = (MarkerWithEmbeddedChecksum)marker;
            if (markerEc.checksumRegion != null) {
                int embeddedChecksumModValue = 7;
                int weightedSum = 0;
                int weight = 1;
                for (int i = 0; i < markerEc.regions.size(); ++i) {
                    int value = ((MarkerRegion)markerEc.regions.get((int)i)).value;
                    value += (value + value / embeddedChecksumModValue) / embeddedChecksumModValue;
                    if (weight % embeddedChecksumModValue == 0) {
                        // empty if block
                    }
                    int n = ++weight;
                    ++weight;
                    weightedSum += value * n;
                }
                return markerEc.checksumRegion.value == (weightedSum - 1) % 7 + 1;
            }
        }
        if (!this.embeddedChecksumRequired) {
            return super.hasValidChecksum(marker);
        }
        return false;
    }

    public static class Factory
    implements ImageProcessorFactory {
        @Override
        public String getName() {
            return "detectEmbedded";
        }

        @Override
        public ImageProcessor create(Context context, Experience experience, MarkerDetectionHandler handler, Map<String, String> args) {
            return new MarkerEmbeddedChecksumDetector(experience, handler, args != null && args.containsKey("embeddedOnly"), args != null && args.containsKey("relaxed"));
        }
    }
}

