/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.detect.marker;

import android.content.Context;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.imgproc.Imgproc;
import uk.ac.horizon.artcodes.detect.handler.MarkerDetectionHandler;
import uk.ac.horizon.artcodes.detect.marker.Marker;
import uk.ac.horizon.artcodes.detect.marker.MarkerDetector;
import uk.ac.horizon.artcodes.detect.marker.MarkerRegion;
import uk.ac.horizon.artcodes.model.Experience;
import uk.ac.horizon.artcodes.process.ImageProcessor;
import uk.ac.horizon.artcodes.process.ImageProcessorFactory;

public class MarkerAreaOrderDetector
extends MarkerDetector {
    public MarkerAreaOrderDetector(Experience experience, MarkerDetectionHandler handler) {
        super(experience, handler);
    }

    @Override
    protected MarkerRegion createRegionForNode(int regionIndex, List<MatOfPoint> contours, Mat hierarchy) {
        MarkerRegion region = super.createRegionForNode(regionIndex, contours, hierarchy);
        if (region != null) {
            region.data = Imgproc.contourArea((Mat)((Mat)contours.get(region.index)));
        }
        return region;
    }

    @Override
    protected void sortCode(Marker marker) {
        Collections.sort(marker.regions, new Comparator<MarkerRegion>(){

            @Override
            public int compare(MarkerRegion region1, MarkerRegion region2) {
                return Double.compare((Double)region1.data, (Double)region2.data);
            }
        });
    }

    public static class Factory
    implements ImageProcessorFactory {
        @Override
        public String getName() {
            return "detectOrdered";
        }

        @Override
        public ImageProcessor create(Context context, Experience experience, MarkerDetectionHandler handler, Map<String, String> args) {
            return new MarkerAreaOrderDetector(experience, handler);
        }
    }
}

