/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.animator;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.ViewAnimationUtils;

public class VisibilityAnimator {
    private final View view;
    private final View center;
    private Animator animator;

    public VisibilityAnimator(View view) {
        this.view = view;
        this.center = view;
    }

    public VisibilityAnimator(View view, View center) {
        this.view = view;
        this.center = center;
    }

    public void setViewVisible(boolean visible) {
        if (visible) {
            this.view.setVisibility(0);
        } else {
            this.view.setVisibility(8);
        }
    }

    public void hideView() {
        if (Build.VERSION.SDK_INT >= 21) {
            int cx = (this.center.getLeft() + this.center.getRight()) / 2 - this.view.getLeft();
            int cy = (this.center.getTop() + this.center.getBottom()) / 2 - this.view.getTop();
            Log.i((String)"circleanim", (String)("Circle center " + cx + ", " + cy + " width " + this.view.getWidth()));
            this.animator = ViewAnimationUtils.createCircularReveal((View)this.view, (int)cx, (int)cy, (float)this.view.getWidth(), (float)0.0f);
            this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    if (VisibilityAnimator.this.view != VisibilityAnimator.this.center) {
                        VisibilityAnimator.this.center.setVisibility(0);
                    }
                    VisibilityAnimator.this.view.setVisibility(4);
                }
            });
            this.animator.start();
        } else if (Build.VERSION.SDK_INT >= 11) {
            this.animator = ObjectAnimator.ofFloat((Object)this.view, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
            this.animator.setDuration(500L);
            this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    if (VisibilityAnimator.this.view != VisibilityAnimator.this.center) {
                        VisibilityAnimator.this.center.setVisibility(0);
                    }
                    VisibilityAnimator.this.view.setVisibility(4);
                }
            });
            this.animator.start();
        } else {
            if (this.view != this.center) {
                this.center.setVisibility(0);
            }
            this.view.setVisibility(4);
        }
    }

    public void hideView(Animator.AnimatorListener listener) {
        if (Build.VERSION.SDK_INT >= 21) {
            int cx = (this.center.getLeft() + this.center.getRight()) / 2 - this.view.getLeft();
            int cy = (this.center.getTop() + this.center.getBottom()) / 2 - this.view.getTop();
            Log.i((String)"circleanim", (String)("Circle center " + cx + ", " + cy + " width " + this.view.getWidth()));
            this.animator = ViewAnimationUtils.createCircularReveal((View)this.view, (int)cx, (int)cy, (float)0.0f, (float)this.view.getWidth());
            this.animator.addListener(listener);
            this.animator.start();
        } else if (Build.VERSION.SDK_INT >= 11) {
            this.animator = ObjectAnimator.ofFloat((Object)this.view, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
            this.animator.setDuration(500L);
            this.animator.addListener(listener);
            this.animator.start();
        } else {
            listener.onAnimationEnd(null);
        }
    }

    public void showView() {
        if (Build.VERSION.SDK_INT >= 21) {
            int cx = (this.center.getLeft() + this.center.getRight()) / 2 - this.view.getLeft();
            int cy = (this.center.getTop() + this.center.getBottom()) / 2 - this.view.getTop();
            this.animator = ViewAnimationUtils.createCircularReveal((View)this.view, (int)cx, (int)cy, (float)0.0f, (float)this.view.getWidth());
            this.animator.start();
        } else if (Build.VERSION.SDK_INT >= 11) {
            this.animator = ObjectAnimator.ofFloat((Object)this.view, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
            this.animator.setDuration(250L);
            this.animator.start();
        }
        if (this.view != this.center) {
            this.center.setVisibility(4);
        }
        this.view.setVisibility(0);
    }
}

