/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.camera;

import android.graphics.ImageFormat;
import android.hardware.Camera;

public class CameraInfo {
    private final int rotation;
    private final int imageWidth;
    private final int imageHeight;
    private final int imageDepth;
    private final boolean frontFacing;

    public CameraInfo(Camera.CameraInfo cameraInfo, Camera.Parameters parameters, int deviceRotation) {
        this.frontFacing = cameraInfo.facing == 1;
        this.imageWidth = parameters.getPreviewSize().width;
        this.imageHeight = parameters.getPreviewSize().height;
        this.imageDepth = ImageFormat.getBitsPerPixel((int)parameters.getPreviewFormat());
        this.rotation = this.getRotation(cameraInfo, deviceRotation);
    }

    private int getRotation(Camera.CameraInfo info, int deviceRotation) {
        int rotation;
        if (info.facing == 1) {
            rotation = (info.orientation + deviceRotation) % 360;
            rotation = (360 - rotation) % 360;
        } else {
            rotation = (info.orientation - deviceRotation + 360) % 360;
        }
        return rotation;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageDepth() {
        return this.imageDepth;
    }

    public int getRotation() {
        return this.rotation;
    }

    public boolean isFrontFacing() {
        return this.frontFacing;
    }
}

