/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.process;

import android.content.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfFloat;
import org.opencv.core.MatOfInt;
import org.opencv.imgproc.Imgproc;
import uk.ac.horizon.artcodes.detect.DetectorSetting;
import uk.ac.horizon.artcodes.detect.ImageBuffers;
import uk.ac.horizon.artcodes.detect.handler.MarkerDetectionHandler;
import uk.ac.horizon.artcodes.model.Experience;
import uk.ac.horizon.artcodes.process.ImageProcessor;
import uk.ac.horizon.artcodes.process.ImageProcessorFactory;

public class WhiteBalanceImageProcessor
implements ImageProcessor {
    protected MatOfInt[] channels = null;
    protected Mat[] histograms = null;
    protected Mat emptyMatMask = null;
    protected MatOfInt size = null;
    protected MatOfFloat range = null;
    protected Mat lut = null;
    private byte[] lutBufferArray;

    private void setup() {
        this.channels = new MatOfInt[]{new MatOfInt(new int[]{0}), new MatOfInt(new int[]{1}), new MatOfInt(new int[]{2}), new MatOfInt(new int[]{3})};
        this.histograms = new Mat[]{new Mat(), new Mat(), new Mat(), new Mat()};
        this.emptyMatMask = new Mat();
        this.size = new MatOfInt(new int[]{256});
        this.range = new MatOfFloat(new float[]{0.0f, 256.0f});
    }

    @Override
    public void process(ImageBuffers buffers) {
        Mat image = buffers.getImageInBgr();
        if (this.histograms == null) {
            this.setup();
        }
        ArrayList<Mat> listOfMat = new ArrayList<Mat>();
        listOfMat.add(image);
        for (int channel = 0; channel < image.channels(); ++channel) {
            Imgproc.calcHist(listOfMat, (MatOfInt)this.channels[channel], (Mat)this.emptyMatMask, (Mat)this.histograms[channel], (MatOfInt)this.size, (MatOfFloat)this.range);
        }
        float[] a = new float[image.channels()];
        float[] b = new float[image.channels()];
        int desiredHistogramBufferSize = this.histograms[0].rows() * this.histograms[0].cols() * this.histograms[0].channels();
        float[] pixelHistogramBuffer = new float[desiredHistogramBufferSize];
        for (int channel = 0; channel < image.channels(); ++channel) {
            this.histograms[channel].get(0, 0, pixelHistogramBuffer);
            WhiteBalanceImageProcessor.getHistogramRemap(pixelHistogramBuffer, desiredHistogramBufferSize, image.total(), a, channel, b, channel);
        }
        if (this.lut == null) {
            this.lut = new Mat(1, 256, CvType.CV_8UC3);
        }
        int lutSize = this.lut.cols() * this.lut.rows() * this.lut.channels();
        int lutIndex = -1;
        if (this.lutBufferArray == null || this.lutBufferArray.length != lutSize) {
            this.lutBufferArray = new byte[lutSize];
        }
        for (int i = 0; i < 256; ++i) {
            for (int channel = 0; channel < image.channels(); ++channel) {
                this.lutBufferArray[++lutIndex] = (byte)Math.min(Math.max(a[channel] * ((float)i - b[channel]), 0.0f), 255.0f);
            }
        }
        this.lut.put(0, 0, this.lutBufferArray);
        Core.LUT((Mat)image, (Mat)this.lut, (Mat)image);
        buffers.setImage(image);
    }

    private static void getHistogramRemap(float[] histogram, int size, long total, float[] resultA, int resultAIndex, float[] resultB, int resultBIndex) {
        if (total == -1L) {
            total = 0L;
            for (int i = 0; i < size; ++i) {
                total = (long)((float)total + histogram[i]);
            }
        }
        float p5 = (float)total * 0.05f;
        float p95 = (float)total * 0.95f;
        resultA[resultAIndex] = -1.0f;
        resultB[resultBIndex] = -1.0f;
        int count = 0;
        for (int i = 0; i < size; ++i) {
            count = (int)((float)count + histogram[i]);
            if (resultB[resultBIndex] == -1.0f && (float)count >= p5) {
                resultB[resultBIndex] = i;
                continue;
            }
            if (!((float)count >= p95)) continue;
            resultA[resultAIndex] = 255.0f / ((float)i - resultB[resultBIndex]);
            break;
        }
    }

    @Override
    public void getSettings(List<DetectorSetting> settings) {
    }

    public void release() {
        this.lut.release();
        for (MatOfInt matOfInt : this.channels) {
            matOfInt.release();
        }
        this.emptyMatMask.release();
        for (MatOfInt matOfInt : this.histograms) {
            matOfInt.release();
        }
        this.size.release();
        this.range.release();
    }

    public static class WhiteBalanceImageProcessorFactory
    implements ImageProcessorFactory {
        @Override
        public String getName() {
            return "whiteBalance";
        }

        @Override
        public ImageProcessor create(Context context, Experience experience, MarkerDetectionHandler handler, Map<String, String> args) {
            return new WhiteBalanceImageProcessor();
        }
    }
}

