/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.detect.marker;

import android.content.Context;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.imgproc.Imgproc;
import uk.ac.horizon.artcodes.detect.handler.MarkerDetectionHandler;
import uk.ac.horizon.artcodes.detect.marker.Marker;
import uk.ac.horizon.artcodes.detect.marker.MarkerEmbeddedChecksumDetector;
import uk.ac.horizon.artcodes.detect.marker.MarkerRegion;
import uk.ac.horizon.artcodes.detect.marker.MarkerWithEmbeddedChecksum;
import uk.ac.horizon.artcodes.model.Experience;
import uk.ac.horizon.artcodes.process.ImageProcessor;
import uk.ac.horizon.artcodes.process.ImageProcessorFactory;

public class MarkerEmbeddedChecksumAreaOrderDetector
extends MarkerEmbeddedChecksumDetector {
    public MarkerEmbeddedChecksumAreaOrderDetector(Experience experience, MarkerDetectionHandler handler, boolean embeddedChecksumRequired, boolean relaxed) {
        super(experience, handler, embeddedChecksumRequired, relaxed);
    }

    @Override
    protected Marker createMarkerForNode(int nodeIndex, List<MatOfPoint> contours, Mat hierarchy) {
        ArrayList<MarkerRegion> regions = null;
        MarkerRegion checksumRegion = null;
        int currentNodeIndex = (int)hierarchy.get(0, nodeIndex)[2];
        while (currentNodeIndex >= 0) {
            MarkerRegion region = this.createRegionForNode(currentNodeIndex, contours, hierarchy);
            if (region != null) {
                if (!this.ignoreEmptyRegions || region.value != 0) {
                    if (regions == null) {
                        regions = new ArrayList<MarkerRegion>();
                    } else if (regions.size() >= this.maxRegions) {
                        return null;
                    }
                    regions.add(region);
                }
            } else if (checksumRegion == null) {
                checksumRegion = this.getChecksumRegionAtNode(currentNodeIndex, hierarchy);
                if (checksumRegion == null) {
                    return null;
                }
            } else {
                return null;
            }
            currentNodeIndex = (int)hierarchy.get(0, currentNodeIndex)[0];
        }
        if (regions != null && checksumRegion != null) {
            MarkerWithEmbeddedChecksum marker = new MarkerWithEmbeddedChecksum(nodeIndex, regions, checksumRegion);
            this.sortByValue(marker);
            if (this.isValidRegionList(marker)) {
                this.addAreaToRegions(marker, contours);
                this.sortByArea(marker);
                return marker;
            }
        }
        return null;
    }

    @Override
    protected void sortCode(Marker marker) {
        this.sortByArea(marker);
    }

    private void addAreaToRegions(Marker marker, List<MatOfPoint> contours) {
        for (MarkerRegion region : marker.regions) {
            region.data = new Double(Imgproc.contourArea((Mat)((Mat)contours.get(region.index))));
        }
    }

    private void sortByArea(Marker marker) {
        Collections.sort(marker.regions, new Comparator<MarkerRegion>(){

            @Override
            public int compare(MarkerRegion region1, MarkerRegion region2) {
                return (Double)region1.data < (Double)region2.data ? -1 : (region1.data.equals(region2.data) ? 0 : 1);
            }
        });
    }

    private void sortByValue(Marker marker) {
        Collections.sort(marker.regions, new Comparator<MarkerRegion>(){

            @Override
            public int compare(MarkerRegion region1, MarkerRegion region2) {
                return region1.value < region2.value ? -1 : (region1.value == region2.value ? 0 : 1);
            }
        });
    }

    public static class Factory
    implements ImageProcessorFactory {
        @Override
        public String getName() {
            return "detectEmbeddedOrdered";
        }

        @Override
        public ImageProcessor create(Context context, Experience experience, MarkerDetectionHandler handler, Map<String, String> args) {
            return new MarkerEmbeddedChecksumAreaOrderDetector(experience, handler, args != null && args.containsKey("embeddedOnly"), args != null && args.containsKey("relaxed"));
        }
    }
}

