/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.detect;

import android.graphics.Bitmap;
import android.util.Log;
import org.opencv.android.Utils;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;

public class ImageBuffers {
    private byte[] buffer;
    private Mat cameraImage;
    private Rect ROI;
    private Mat currentBuffer;
    private Mat yuvBuffer;
    private Mat greyBuffer;
    private Mat bgrBuffer;
    private Mat overlay;
    private Bitmap overlayBitmap;
    private boolean overlayReady = false;
    private boolean detected = false;
    private boolean flip = false;
    private int rotations = 0;

    public void setImage(Mat image) {
        if (image == this.greyBuffer) {
            this.currentBuffer = this.greyBuffer;
        } else if (image == this.bgrBuffer) {
            this.currentBuffer = this.bgrBuffer;
        } else if (image == this.yuvBuffer) {
            this.currentBuffer = this.yuvBuffer;
        } else {
            Log.w((String)this.getClass().getSimpleName(), (String)"setImage(Mat) called with buffer not provided by ImageBuffers.");
        }
    }

    public Mat getImageInAnyFormat() {
        if (this.currentBuffer == this.yuvBuffer || this.currentBuffer == this.greyBuffer) {
            return this.greyBuffer;
        }
        if (this.currentBuffer == this.bgrBuffer) {
            return this.bgrBuffer;
        }
        Log.w((String)this.getClass().getSimpleName(), (String)"In getImageInAnyFormat() 'currentBuffer' was not equal to any known buffer.");
        return null;
    }

    public Mat getImageInGrey() {
        if (this.currentBuffer == this.yuvBuffer) {
            double[] rectArray = new double[]{0.0, 0.0, this.yuvBuffer.cols(), this.yuvBuffer.rows() / 3 * 2};
            this.greyBuffer = this.yuvBuffer.submat(new Rect(rectArray));
        } else if (this.currentBuffer == this.bgrBuffer) {
            Imgproc.cvtColor((Mat)this.getBgrBuffer(), (Mat)this.getGreyBuffer(), (int)6);
        } else {
            this.getGreyBuffer();
        }
        this.currentBuffer = this.greyBuffer;
        return this.greyBuffer;
    }

    public Mat getGreyBuffer() {
        if (this.greyBuffer == null) {
            if (this.yuvBuffer != null) {
                double[] rectArray = new double[]{0.0, 0.0, this.yuvBuffer.cols(), this.yuvBuffer.rows() / 3 * 2};
                this.greyBuffer = this.yuvBuffer.submat(new Rect(rectArray));
            } else {
                Log.w((String)this.getClass().getSimpleName(), (String)"Creating grey buffer in getGreyBuffer()");
                this.greyBuffer = new Mat(this.ROI.height, this.ROI.width, CvType.CV_8UC1);
            }
        }
        return this.greyBuffer;
    }

    public Mat getImageInBgr() {
        if (this.currentBuffer == this.yuvBuffer) {
            Imgproc.cvtColor((Mat)this.yuvBuffer, (Mat)this.getBgrBuffer(), (int)93);
        } else if (this.currentBuffer == this.greyBuffer) {
            Imgproc.cvtColor((Mat)this.greyBuffer, (Mat)this.getBgrBuffer(), (int)8);
        }
        this.currentBuffer = this.bgrBuffer;
        return this.bgrBuffer;
    }

    public Mat getBgrBuffer() {
        if (this.bgrBuffer == null) {
            this.bgrBuffer = new Mat(this.ROI.height, this.ROI.width, CvType.CV_8UC3);
        }
        return this.bgrBuffer;
    }

    public Mat getImageInYuv() {
        if (this.currentBuffer == this.greyBuffer) {
            Imgproc.cvtColor((Mat)this.greyBuffer, (Mat)this.getBgrBuffer(), (int)8);
            Imgproc.cvtColor((Mat)this.bgrBuffer, (Mat)this.yuvBuffer, (int)82);
        } else if (this.currentBuffer == this.bgrBuffer) {
            Imgproc.cvtColor((Mat)this.bgrBuffer, (Mat)this.yuvBuffer, (int)82);
        }
        this.currentBuffer = this.yuvBuffer;
        return this.yuvBuffer;
    }

    public void setImage(byte[] data) {
        this.overlayReady = false;
        this.cameraImage.put(0, 0, data);
        this.currentBuffer = this.yuvBuffer;
    }

    public void setImage(Bitmap bitmap) {
        this.overlayReady = false;
        Mat rgbaImage = new Mat(bitmap.getHeight(), bitmap.getWidth(), CvType.CV_8UC4);
        Utils.bitmapToMat((Bitmap)bitmap, (Mat)rgbaImage);
        Mat bgrImage = this.getBgrBuffer();
        Imgproc.cvtColor((Mat)rgbaImage, (Mat)bgrImage, (int)3);
        this.setImage(bgrImage);
    }

    public byte[] createBuffer(int imageWidth, int imageHeight, int imageDepth) {
        Log.i((String)"ImageBuffer", (String)("createBuffer imageWidth: " + imageWidth + " imageHeight: " + imageHeight + " imageDepth: " + imageDepth));
        this.buffer = new byte[imageWidth * imageHeight * imageDepth / 8];
        this.cameraImage = new Mat(imageHeight + imageHeight / 2, imageWidth, CvType.CV_8UC1);
        Log.i((String)"ImageBuffer", (String)("cameraImage: " + this.cameraImage.cols() + "x" + this.cameraImage.rows() + "x" + this.cameraImage.channels()));
        return this.buffer;
    }

    public void setROI(Rect rect) {
        this.ROI = rect;
        if (rect == null) {
            double[] roiArray = new double[]{0.0, 0.0, this.cameraImage.cols(), this.cameraImage.rows() / 3 * 2};
            this.ROI = new Rect(roiArray);
            this.currentBuffer = this.yuvBuffer = this.cameraImage;
        } else if (rect.height == this.cameraImage.rows() / 3 * 2) {
            Log.i((String)this.getClass().getSimpleName(), (String)"rect.height == camera image height (simple case)");
            double[] rectArray = new double[]{rect.x, rect.y, rect.width, rect.height + rect.height / 2};
            this.yuvBuffer = this.cameraImage.submat(new Rect(rectArray));
        } else {
            Log.i((String)this.getClass().getSimpleName(), (String)"rect.height != camera image height (complicated case)");
            throw new UnsupportedOperationException();
        }
    }

    public boolean hasDetected() {
        return this.detected;
    }

    public void setDetected(boolean detected) {
        this.detected = detected;
    }

    public Mat getOverlay() {
        return this.getOverlay(true);
    }

    public Bitmap createOverlayBitmap() {
        if (this.overlayReady) {
            if (this.overlayBitmap == null) {
                this.overlayBitmap = Bitmap.createBitmap((int)this.overlay.cols(), (int)this.overlay.rows(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            Utils.matToBitmap((Mat)this.overlay, (Bitmap)this.overlayBitmap);
            return this.overlayBitmap;
        }
        if (this.overlayBitmap != null) {
            this.overlayBitmap = null;
        }
        return null;
    }

    public void setRotation(int rotation) {
        this.rotations = rotation / 90;
    }

    public void setFrontFacing(boolean frontFacing) {
        this.flip = frontFacing;
    }

    public Mat getOverlay(boolean clear) {
        if (this.overlayReady) {
            return this.overlay;
        }
        if (this.currentBuffer == this.yuvBuffer) {
            this.setImage(this.getImageInGrey());
        }
        this.rotate(this.currentBuffer);
        if (this.overlay == null) {
            this.overlay = new Mat(this.currentBuffer.rows(), this.currentBuffer.cols(), CvType.CV_8UC4);
        }
        if (clear) {
            this.overlay.setTo(new Scalar(0.0, 0.0, 0.0, 0.0));
        }
        this.overlayReady = true;
        return this.overlay;
    }

    private void rotate(Mat image) {
        int flip_horizontal_or_vertical;
        int n = flip_horizontal_or_vertical = this.rotations > 0 ? 1 : 0;
        if (this.flip) {
            flip_horizontal_or_vertical = -1;
        }
        for (int i = 0; i != this.rotations; ++i) {
            Core.transpose((Mat)image, (Mat)image);
            Core.flip((Mat)image, (Mat)image, (int)flip_horizontal_or_vertical);
        }
    }
}

