/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.detect;

import android.graphics.Bitmap;
import android.util.Log;
import android.widget.ImageView;
import java.util.ArrayList;
import java.util.List;
import org.opencv.android.OpenCVLoader;
import org.opencv.core.Rect;
import uk.ac.horizon.artcodes.camera.CameraInfo;
import uk.ac.horizon.artcodes.detect.DetectorCallback;
import uk.ac.horizon.artcodes.detect.DetectorSetting;
import uk.ac.horizon.artcodes.detect.ImageBuffers;
import uk.ac.horizon.artcodes.process.ImageProcessor;

public class Detector {
    protected final List<ImageProcessor> pipeline = new ArrayList<ImageProcessor>();
    protected final List<DetectorSetting> settings = new ArrayList<DetectorSetting>();
    protected final ImageBuffers buffers = new ImageBuffers();
    private ImageView overlay;
    protected DetectorCallback callback;

    public void setCallback(DetectorCallback callback) {
        this.callback = callback;
    }

    public void setOverlay(ImageView overlay) {
        this.overlay = overlay;
    }

    public void setData(byte[] data) {
        this.buffers.setImage(data);
        try {
            Bitmap overlayBitmap;
            for (ImageProcessor imageProcessor : this.pipeline) {
                imageProcessor.process(this.buffers);
            }
            if (this.overlay != null && (overlayBitmap = this.buffers.createOverlayBitmap()) != null) {
                this.overlay.post(new Runnable(){

                    @Override
                    public void run() {
                        Detector.this.overlay.setImageBitmap(overlayBitmap);
                    }
                });
            }
        }
        catch (Exception e) {
            Log.e((String)"Detector", (String)e.getMessage(), (Throwable)e);
        }
    }

    private void createSettings() {
        this.settings.clear();
        for (ImageProcessor imageProcessor : this.pipeline) {
            imageProcessor.getSettings(this.settings);
        }
    }

    public List<DetectorSetting> getSettings() {
        return this.settings;
    }

    public byte[] createBuffer(CameraInfo info, int surfaceWidth, int surfaceHeight) {
        byte[] buffer = this.buffers.createBuffer(info.getImageWidth(), info.getImageHeight(), info.getImageDepth());
        this.buffers.setROI(this.createROI(info.getImageWidth(), info.getImageHeight(), surfaceWidth, surfaceHeight));
        this.buffers.setRotation(info.getRotation());
        this.buffers.setFrontFacing(info.isFrontFacing());
        this.createSettings();
        return buffer;
    }

    protected Rect createROI(int imageWidth, int imageHeight, int surfaceWidth, int surfaceHeight) {
        if (this.callback != null) {
            this.callback.detectionStart(100);
        }
        return new Rect(0, 0, imageWidth, imageHeight);
    }

    static {
        if (!OpenCVLoader.initDebug()) {
            Log.e((String)"OpenCV", (String)"Error Initializing OpenCV");
        }
    }
}

