/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.process;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import uk.ac.horizon.artcodes.detect.DetectorSetting;
import uk.ac.horizon.artcodes.detect.ImageBuffers;
import uk.ac.horizon.artcodes.detect.marker.MarkerDetectionHandler;
import uk.ac.horizon.artcodes.model.Experience;
import uk.ac.horizon.artcodes.process.ImageProcessor;
import uk.ac.horizon.artcodes.process.ImageProcessorFactory;

public class RGBFilter
implements ImageProcessor {
    private final Channel channel;

    public RGBFilter(Channel channel) {
        this.channel = channel;
    }

    @Override
    public void process(ImageBuffers buffers) {
        Imgproc.cvtColor((Mat)buffers.getImage(), (Mat)buffers.getTemp(), (int)116);
        Size sizeA = buffers.getTemp().size();
        int i = 0;
        while ((double)i < sizeA.height) {
            int j = 0;
            while ((double)j < sizeA.width) {
                double value;
                double[] data = buffers.getTemp().get(i, j);
                data[0] = value = this.getValue(data);
                data[1] = value;
                data[2] = value;
                buffers.getTemp().put(i, j, data);
                ++j;
            }
            ++i;
        }
        Imgproc.cvtColor((Mat)buffers.getTemp(), (Mat)buffers.getImage(), (int)6);
    }

    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public void getSettings(List<DetectorSetting> settings) {
    }

    private double getValue(double[] data) {
        switch (this.channel) {
            case red: {
                return data[2];
            }
            case blue: {
                return data[0];
            }
            case green: {
                return data[1];
            }
        }
        return 0.0;
    }

    public static enum Channel {
        red,
        green,
        blue;

    }

    public static class GreenFactory
    implements ImageProcessorFactory {
        @Override
        public String getName() {
            return "filter:green";
        }

        @Override
        public ImageProcessor create(Experience experience, MarkerDetectionHandler handler) {
            return new RGBFilter(Channel.green);
        }
    }

    public static class BlueFactory
    implements ImageProcessorFactory {
        @Override
        public String getName() {
            return "filter:blue";
        }

        @Override
        public ImageProcessor create(Experience experience, MarkerDetectionHandler handler) {
            return new RGBFilter(Channel.blue);
        }
    }

    public static class RedFactory
    implements ImageProcessorFactory {
        @Override
        public String getName() {
            return "filter:red";
        }

        @Override
        public ImageProcessor create(Experience experience, MarkerDetectionHandler handler) {
            return new RGBFilter(Channel.red);
        }
    }
}

