/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.detect.marker;

import android.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;
import uk.ac.horizon.artcodes.detect.DetectorSetting;
import uk.ac.horizon.artcodes.detect.ImageBuffers;
import uk.ac.horizon.artcodes.detect.marker.Marker;
import uk.ac.horizon.artcodes.detect.marker.MarkerDetectionHandler;
import uk.ac.horizon.artcodes.detect.marker.MarkerRegion;
import uk.ac.horizon.artcodes.model.Action;
import uk.ac.horizon.artcodes.model.Experience;
import uk.ac.horizon.artcodes.process.ImageProcessor;
import uk.ac.horizon.artcodes.process.ImageProcessorFactory;
import uk.ac.horizon.artcodes.scanner.R;

public class MarkerDetector
implements ImageProcessor {
    static final int NEXT_NODE = 0;
    static final int FIRST_NODE = 2;
    private static final Scalar detectedColour = new Scalar(255.0, 255.0, 0.0, 255.0);
    private static final Scalar regionColour = new Scalar(255.0, 128.0, 0.0, 255.0);
    private static final Scalar outlineColour = new Scalar(0.0, 0.0, 0.0, 255.0);
    protected final int checksum;
    protected final Collection<String> validCodes = new HashSet<String>();
    protected final int minRegions;
    protected final int maxRegions;
    protected final int maxRegionValue;
    protected final int maxEmptyRegions;
    protected final boolean ignoreEmptyRegions;
    private final MarkerDetectionHandler handler;
    private CodeDisplay codeDisplay = CodeDisplay.hidden;
    private OutlineDisplay outlineDisplay = OutlineDisplay.none;

    public MarkerDetector(Experience experience, MarkerDetectionHandler handler) {
        int maxValue = 3;
        int minRegionCount = 20;
        int maxRegionCount = 3;
        int checksum = 0;
        int maxEmptyRegions = 0;
        for (Action action : experience.getActions()) {
            for (String code : action.getCodes()) {
                int total = 0;
                String[] values = code.split(":");
                minRegionCount = Math.min(minRegionCount, values.length);
                maxRegionCount = Math.max(maxRegionCount, values.length);
                int emptyRegions = 0;
                for (String value : values) {
                    try {
                        int codeValue = Integer.parseInt(value);
                        maxValue = Math.max(maxValue, codeValue);
                        total += codeValue;
                        if (codeValue != 0) continue;
                        ++emptyRegions;
                    }
                    catch (Exception e) {
                        Log.w((String)"", (String)e.getMessage(), (Throwable)e);
                    }
                }
                maxEmptyRegions = Math.max(maxEmptyRegions, emptyRegions);
                if (total > 0) {
                    checksum = MarkerDetector.gcd(checksum, total);
                }
                this.validCodes.add(code);
            }
        }
        this.handler = handler;
        if (minRegionCount == 20 && maxRegionCount == 3) {
            minRegionCount = 3;
            maxRegionCount = 20;
            maxValue = 20;
        }
        this.maxRegionValue = maxValue;
        this.minRegions = minRegionCount;
        this.maxRegions = maxRegionCount;
        this.checksum = checksum;
        this.maxEmptyRegions = maxEmptyRegions;
        this.ignoreEmptyRegions = maxEmptyRegions == 0;
        Log.i((String)"detect", (String)("Regions " + minRegionCount + "-" + maxRegionCount + ", <" + maxValue + ", checksum " + checksum));
    }

    private static int gcd(int a, int b) {
        if (b == 0) {
            return a;
        }
        return MarkerDetector.gcd(b, a % b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ImageBuffers buffers) {
        ArrayList<MatOfPoint> contours = new ArrayList<MatOfPoint>();
        Mat hierarchy = new Mat();
        if (this.outlineDisplay != OutlineDisplay.none || this.codeDisplay == CodeDisplay.visible) {
            buffers.getOverlay();
        }
        try {
            ArrayList<Marker> foundMarkers = new ArrayList<Marker>();
            Imgproc.findContours((Mat)buffers.getImage(), contours, (Mat)hierarchy, (int)3, (int)1);
            for (int i = 0; i < contours.size(); ++i) {
                Mat overlay;
                Marker marker = this.createMarkerForNode(i, contours, hierarchy);
                if (marker == null) continue;
                String markerCode = this.getCodeKey(marker);
                if (!this.validCodes.isEmpty() && !this.validCodes.contains(markerCode)) continue;
                foundMarkers.add(marker);
                if (this.outlineDisplay != OutlineDisplay.none) {
                    overlay = buffers.getOverlay();
                    if (this.outlineDisplay == OutlineDisplay.regions) {
                        double[] nodes = hierarchy.get(0, i);
                        int currentRegionIndex = (int)nodes[2];
                        while (currentRegionIndex >= 0) {
                            Imgproc.drawContours((Mat)overlay, contours, (int)currentRegionIndex, (Scalar)outlineColour, (int)4);
                            Imgproc.drawContours((Mat)overlay, contours, (int)currentRegionIndex, (Scalar)regionColour, (int)2);
                            nodes = hierarchy.get(0, currentRegionIndex);
                            currentRegionIndex = (int)nodes[0];
                        }
                    }
                    Imgproc.drawContours((Mat)overlay, contours, (int)i, (Scalar)outlineColour, (int)7);
                    Imgproc.drawContours((Mat)overlay, contours, (int)i, (Scalar)detectedColour, (int)5);
                }
                if (this.codeDisplay != CodeDisplay.visible) continue;
                overlay = buffers.getOverlay();
                Rect bounds = Imgproc.boundingRect((MatOfPoint)contours.get(i));
                Imgproc.putText((Mat)overlay, (String)markerCode, (Point)bounds.tl(), (int)0, (double)1.0, (Scalar)outlineColour, (int)5);
                Imgproc.putText((Mat)overlay, (String)markerCode, (Point)bounds.tl(), (int)0, (double)1.0, (Scalar)detectedColour, (int)3);
            }
            buffers.setDetected(!foundMarkers.isEmpty());
            this.handler.onMarkersDetected(foundMarkers, contours, hierarchy);
        }
        finally {
            contours.clear();
            hierarchy.release();
        }
    }

    public String getCodeKey(Marker marker) {
        this.sortCode(marker);
        StringBuilder builder = new StringBuilder(marker.regions.size() * 2);
        for (MarkerRegion region : marker.regions) {
            builder.append(region.value);
            builder.append(':');
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    @Override
    public void getSettings(List<DetectorSetting> settings) {
        settings.add(new DetectorSetting(){

            @Override
            public void nextValue() {
                MarkerDetector.this.outlineDisplay = MarkerDetector.this.outlineDisplay.next();
            }

            @Override
            public int getIcon() {
                switch (MarkerDetector.this.outlineDisplay) {
                    case none: {
                        return R.drawable.ic_border_clear_24dp;
                    }
                    case marker: {
                        return R.drawable.ic_border_outer_24dp;
                    }
                    case regions: {
                        return R.drawable.ic_border_all_24dp;
                    }
                }
                return 0;
            }

            @Override
            public int getText() {
                switch (MarkerDetector.this.outlineDisplay) {
                    case none: {
                        return R.string.draw_marker_off;
                    }
                    case marker: {
                        return R.string.draw_marker_outline;
                    }
                    case regions: {
                        return R.string.draw_marker_regions;
                    }
                }
                return 0;
            }
        });
        settings.add(new DetectorSetting(){

            @Override
            public void nextValue() {
                MarkerDetector.this.codeDisplay = MarkerDetector.this.codeDisplay.next();
            }

            @Override
            public int getIcon() {
                switch (MarkerDetector.this.codeDisplay) {
                    case hidden: {
                        return R.drawable.ic_filter_none_black_24dp;
                    }
                    case visible: {
                        return R.drawable.ic_filter_1_black_24dp;
                    }
                }
                return 0;
            }

            @Override
            public int getText() {
                switch (MarkerDetector.this.codeDisplay) {
                    case hidden: {
                        return R.string.draw_code_off;
                    }
                    case visible: {
                        return R.string.draw_code;
                    }
                }
                return 0;
            }
        });
    }

    protected boolean isValidDot(int nodeIndex, Mat hierarchy) {
        double[] nodes = hierarchy.get(0, nodeIndex);
        return nodes[2] < 0.0;
    }

    protected Marker createMarkerForNode(int nodeIndex, List<MatOfPoint> contours, Mat hierarchy) {
        ArrayList<MarkerRegion> regions = null;
        int currentNodeIndex = (int)hierarchy.get(0, nodeIndex)[2];
        while (currentNodeIndex >= 0) {
            MarkerRegion region = this.createRegionForNode(currentNodeIndex, contours, hierarchy);
            if (region != null) {
                if (!this.ignoreEmptyRegions || region.value != 0) {
                    if (regions == null) {
                        regions = new ArrayList<MarkerRegion>();
                    } else if (regions.size() >= this.maxRegions) {
                        return null;
                    }
                    regions.add(region);
                }
            } else {
                return null;
            }
            currentNodeIndex = (int)hierarchy.get(0, currentNodeIndex)[0];
        }
        if (regions != null) {
            Marker marker = new Marker(nodeIndex, regions);
            this.sortCode(marker);
            if (this.isValidRegionList(marker)) {
                return marker;
            }
        }
        return null;
    }

    protected MarkerRegion createRegionForNode(int regionIndex, List<MatOfPoint> contours, Mat hierarchy) {
        double[] nodes = hierarchy.get(0, regionIndex);
        int currentNodeIndex = (int)nodes[2];
        if (currentNodeIndex < 0 && !this.ignoreEmptyRegions && this.maxEmptyRegions <= 0) {
            return null;
        }
        int dotCount = 0;
        while (currentNodeIndex >= 0) {
            if (this.isValidDot(currentNodeIndex, hierarchy)) {
                nodes = hierarchy.get(0, currentNodeIndex);
                currentNodeIndex = (int)nodes[0];
                if (++dotCount <= this.maxRegionValue) continue;
                return null;
            }
            return null;
        }
        return new MarkerRegion(regionIndex, dotCount);
    }

    protected void sortCode(Marker marker) {
        Collections.sort(marker.regions, new Comparator<MarkerRegion>(){

            @Override
            public int compare(MarkerRegion region1, MarkerRegion region2) {
                return region1.value < region2.value ? -1 : (region1.value == region2.value ? 0 : 1);
            }
        });
    }

    protected boolean isValidRegionList(Marker marker) {
        if (marker.regions == null) {
            return false;
        }
        if (marker.regions.size() < this.minRegions) {
            return false;
        }
        if (marker.regions.size() > this.maxRegions) {
            return false;
        }
        int numberOfEmptyRegions = 0;
        for (MarkerRegion region : marker.regions) {
            if (region.value > this.maxRegionValue) {
                return false;
            }
            if (region.value != 0 || ++numberOfEmptyRegions <= this.maxEmptyRegions) continue;
            return false;
        }
        return this.hasValidChecksum(marker);
    }

    protected boolean hasValidChecksum(Marker marker) {
        if (this.checksum <= 1) {
            return true;
        }
        int numberOfLeaves = 0;
        for (MarkerRegion region : marker.regions) {
            numberOfLeaves += region.value;
        }
        return numberOfLeaves % this.checksum == 0;
    }

    private static enum OutlineDisplay {
        none,
        marker,
        regions;

        private static final OutlineDisplay[] vals;

        public OutlineDisplay next() {
            return vals[(this.ordinal() + 1) % vals.length];
        }

        static {
            vals = OutlineDisplay.values();
        }
    }

    private static enum CodeDisplay {
        hidden,
        visible;

        private static final CodeDisplay[] vals;

        public CodeDisplay next() {
            return vals[(this.ordinal() + 1) % vals.length];
        }

        static {
            vals = CodeDisplay.values();
        }
    }

    public static class Factory
    implements ImageProcessorFactory {
        @Override
        public String getName() {
            return "detect";
        }

        @Override
        public ImageProcessor create(Experience experience, MarkerDetectionHandler handler) {
            return new MarkerDetector(experience, handler);
        }
    }
}

