/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.camera;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.Camera;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.WindowManager;
import java.io.IOException;
import java.util.List;
import uk.ac.horizon.artcodes.camera.CameraInfo;
import uk.ac.horizon.artcodes.detect.Detector;
import uk.ac.horizon.artcodes.detect.DetectorSetting;
import uk.ac.horizon.artcodes.scanner.R;

public class CameraView
extends SurfaceView {
    private static final String THREAD_NAME = "Frame Processor";
    private CameraInfo info;
    private Camera camera;
    private int facing = 0;
    private Detector detector;
    private HandlerThread cameraThread;
    private SurfaceHolder surface;
    private int surfaceWidth;
    private int surfaceHeight;

    public CameraView(Context context) {
        super(context);
        this.init();
    }

    public CameraView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public CameraView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @TargetApi(value=21)
    public CameraView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    public void focus(Camera.AutoFocusCallback callback) {
        if (this.camera != null) {
            this.camera.autoFocus(callback);
        }
    }

    public void setDetector(Detector processor) {
        this.detector = processor;
        if (this.detector != null) {
            if (this.camera == null) {
                this.createCamera();
            }
            if (this.camera != null) {
                this.camera.addCallbackBuffer(this.detector.createBuffer(this.info, this.surfaceWidth, this.surfaceHeight));
                this.camera.setPreviewCallbackWithBuffer(new Camera.PreviewCallback(){

                    public void onPreviewFrame(byte[] data, Camera camera) {
                        CameraView.this.detector.setData(data);
                        camera.addCallbackBuffer(data);
                    }
                });
            }
            if (Camera.getNumberOfCameras() > 1) {
                this.detector.getSettings().add(new DetectorSetting(){

                    @Override
                    public void nextValue() {
                        CameraView.this.stopCamera();
                        CameraView.this.facing = 1 - CameraView.this.facing;
                        CameraView.this.startCamera();
                    }

                    @Override
                    public int getIcon() {
                        switch (CameraView.this.facing) {
                            case 0: {
                                return R.drawable.ic_camera_rear_24dp;
                            }
                            case 1: {
                                return R.drawable.ic_camera_front_24dp;
                            }
                        }
                        return 0;
                    }

                    @Override
                    public int getText() {
                        switch (CameraView.this.facing) {
                            case 0: {
                                return R.string.camera_rear;
                            }
                            case 1: {
                                return R.string.camera_front;
                            }
                        }
                        return 0;
                    }
                });
            }
        }
    }

    private void init() {
        this.getHolder().addCallback(new SurfaceHolder.Callback(){

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                if (holder.getSurface() == null) {
                    Log.i((String)"scanner", (String)"No surface?");
                    return;
                }
                CameraView.this.surface = holder;
                CameraView.this.stopCamera();
                CameraView.this.surfaceWidth = width;
                CameraView.this.surfaceHeight = height;
                CameraView.this.startCamera();
            }

            public void surfaceCreated(SurfaceHolder holder) {
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                CameraView.this.stopCamera();
            }
        });
    }

    private void createCamera() {
        if (ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.CAMERA") == 0) {
            int cameraId;
            for (cameraId = 0; cameraId < Camera.getNumberOfCameras(); ++cameraId) {
                try {
                    Camera.CameraInfo info = new Camera.CameraInfo();
                    Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
                    if (info.facing != this.facing) continue;
                    this.openCamera(cameraId);
                    return;
                }
                catch (RuntimeException e) {
                    Log.e((String)"Scanner", (String)("Failed to open scanner " + cameraId + ": " + e.getLocalizedMessage()), (Throwable)e);
                }
            }
            for (cameraId = 0; cameraId < Camera.getNumberOfCameras(); ++cameraId) {
                try {
                    this.openCamera(cameraId);
                    return;
                }
                catch (RuntimeException e) {
                    Log.e((String)"Scanner", (String)("Failed to open scanner " + cameraId + ": " + e.getLocalizedMessage()), (Throwable)e);
                    continue;
                }
            }
        }
    }

    private void openCamera(int cameraId) {
        this.camera = Camera.open((int)cameraId);
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)cameraInfo);
        Camera.Parameters parameters = this.camera.getParameters();
        List focusModes = parameters.getSupportedFocusModes();
        if (focusModes != null && focusModes.contains("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        } else if (focusModes != null && focusModes.contains("auto")) {
            Log.w((String)"Scanner", (String)"Camera requires manual focussing");
            parameters.setFocusMode("auto");
        }
        float ratioOfSurface = (float)this.surfaceHeight / (float)this.surfaceWidth;
        if (ratioOfSurface < 1.0f) {
            ratioOfSurface = 1.0f / ratioOfSurface;
        }
        Log.i((String)"Scanner", (String)("Surface size: " + this.surfaceWidth + "x" + this.surfaceHeight + " (Ratio: " + ratioOfSurface + ")"));
        Log.i((String)"Scanner", (String)("Format = " + parameters.getPictureFormat()));
        List supportedPreviewSizes = parameters.getSupportedPreviewSizes();
        Camera.Size bestFitSoFar = null;
        float ratioDifferenceOfBestFitSoFar = 0.0f;
        for (Camera.Size supportedSize : supportedPreviewSizes) {
            float ratio = (float)supportedSize.width / (float)supportedSize.height;
            float ratioDifference = Math.abs(ratio - ratioOfSurface);
            if (bestFitSoFar != null && !(ratioDifference < ratioDifferenceOfBestFitSoFar)) continue;
            bestFitSoFar = supportedSize;
            ratioDifferenceOfBestFitSoFar = ratioDifference;
        }
        if (bestFitSoFar != null) {
            Log.i((String)"Scanner", (String)("Selected Preview Size: " + bestFitSoFar.width + "x" + bestFitSoFar.height + " (" + (float)bestFitSoFar.width / (float)bestFitSoFar.height + ")"));
            parameters.setPreviewSize(bestFitSoFar.width, bestFitSoFar.height);
            this.camera.setParameters(parameters);
            this.info = new CameraInfo(cameraInfo, parameters, this.getDeviceRotation());
            this.camera.setDisplayOrientation(this.info.getRotation());
            this.setDetector(this.detector);
            try {
                this.camera.setPreviewDisplay(this.surface);
            }
            catch (IOException e) {
                Log.w((String)"Scanner", (String)e.getMessage(), (Throwable)e);
            }
            this.camera.startPreview();
        }
    }

    private int getDeviceRotation() {
        WindowManager manager = (WindowManager)this.getContext().getSystemService("window");
        int rotation = manager.getDefaultDisplay().getRotation();
        switch (rotation) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    private void startCamera() {
        if (this.cameraThread == null) {
            this.cameraThread = new HandlerThread(THREAD_NAME);
            this.cameraThread.start();
            Handler cameraHandler = new Handler(this.cameraThread.getLooper());
            cameraHandler.post(new Runnable(){

                @Override
                public void run() {
                    CameraView.this.createCamera();
                }
            });
        } else {
            this.camera.startPreview();
        }
    }

    private void stopCamera() {
        if (this.camera != null) {
            this.camera.stopPreview();
            this.camera.setPreviewCallback(null);
            this.camera.release();
            if (this.cameraThread != null) {
                this.cameraThread.quit();
                this.cameraThread = null;
            }
            this.camera = null;
        }
    }
}

