/*
 * Decompiled with CFR 0.152.
 */
package gate.jape.constraint;

import gate.AnnotationSet;
import gate.jape.JapeException;
import gate.jape.constraint.AbstractConstraintPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class AbstractRegExpPredicate
extends AbstractConstraintPredicate {
    private static final long serialVersionUID = 8218973149540251171L;

    @Override
    public String toString() {
        String val = ((Pattern)this.getValue()).pattern();
        return this.getAccessor() + this.getOperator() + "\"" + val + "\"";
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            value = "";
        }
        try {
            super.setValue(Pattern.compile(value.toString()));
        }
        catch (PatternSyntaxException pse) {
            throw new IllegalArgumentException("Cannot compile pattern '" + value + "'");
        }
    }

    @Override
    public boolean doMatch(Object annotValue, AnnotationSet context) throws JapeException {
        if (annotValue == null) {
            annotValue = "";
        }
        if (annotValue instanceof String) {
            String annotValueString = (String)annotValue;
            Pattern constraintPattern = (Pattern)this.getValue();
            return this.matcherResult(constraintPattern.matcher(annotValueString));
        }
        throw new JapeException("Cannot do pattern matching on attribute '" + this.getAccessor() + "'.  Are you sure the value is a string?");
    }

    protected abstract boolean matcherResult(Matcher var1);
}

