/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import java.io.Serializable;

public class KleeneOperator
implements Serializable {
    private static final long serialVersionUID = 5590283708947918804L;
    private Type type;
    private Integer min;
    private Integer max;
    private String displayString;

    public KleeneOperator(Type type) {
        this.type = type;
        if (type == Type.SINGLE) {
            this.min = 1;
            this.max = 1;
        } else if (type == Type.OPTIONAL) {
            this.min = 0;
            this.max = 1;
        } else if (type == Type.STAR) {
            this.min = 0;
        } else if (type == Type.PLUS) {
            this.min = 1;
        } else if (type == Type.RANGE) {
            this.min = 1;
            this.max = 1;
        }
    }

    public KleeneOperator(Integer val) {
        this(val, val);
    }

    public KleeneOperator(Integer min, Integer max) {
        this.type = Type.RANGE;
        if (min != null && max != null && min > max) {
            throw new IllegalArgumentException("min cannot be greater than max: " + min + ", " + max);
        }
        this.min = min;
        this.max = max;
    }

    public String toString() {
        if (this.type != Type.RANGE) {
            return this.type.getSymbol();
        }
        if (this.displayString != null) {
            return this.displayString;
        }
        StringBuilder sb = new StringBuilder("[");
        sb.append(this.getMin());
        if (!this.min.equals(this.max)) {
            sb.append(",");
            if (this.max != null) {
                sb.append(this.max);
            }
        }
        sb.append("]");
        this.displayString = sb.toString();
        return this.displayString;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Integer getMin() {
        return this.min;
    }

    public Integer getMax() {
        return this.max;
    }

    public static enum Type {
        SINGLE(""),
        OPTIONAL("?"),
        STAR("*"),
        PLUS("+"),
        RANGE("[x,y]");

        private String symbol;

        private Type() {
        }

        private Type(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public static Type getFromJapeConstant(int op) {
            switch (op) {
                case 0: {
                    return SINGLE;
                }
                case 2: {
                    return PLUS;
                }
                case 1: {
                    return PLUS;
                }
                case 3: {
                    return OPTIONAL;
                }
            }
            throw new IllegalArgumentException("Unknown op code: " + op);
        }

        public static Type getFromSymbol(String symbol) {
            for (Type t : Type.values()) {
                if (!t.getSymbol().equals(symbol)) continue;
                return t;
            }
            return null;
        }
    }
}

