/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.jape.ConstraintGroup;
import gate.jape.JapeConstants;
import gate.jape.KleeneOperator;
import gate.jape.PatternElement;
import gate.util.Strings;
import java.io.Serializable;
import java.util.Iterator;

public class ComplexPatternElement
extends PatternElement
implements JapeConstants,
Serializable {
    private static final long serialVersionUID = -1660335210282070151L;
    private KleeneOperator kleeneOp = null;
    private String bindingName = null;
    private ConstraintGroup constraintGroup;

    public String getBindingName() {
        return this.bindingName;
    }

    protected Iterator<ComplexPatternElement> getCPEs() {
        return this.constraintGroup.getCPEs();
    }

    public ComplexPatternElement(ConstraintGroup constraintGroup, KleeneOperator.Type kleeneType, String bindingName) {
        this(constraintGroup, new KleeneOperator(kleeneType), bindingName);
    }

    public ComplexPatternElement(ConstraintGroup constraintGroup, KleeneOperator kleeneOp, String bindingName) {
        if (kleeneOp == null) {
            kleeneOp = new KleeneOperator(KleeneOperator.Type.SINGLE);
        }
        this.constraintGroup = constraintGroup;
        this.kleeneOp = kleeneOp;
        this.bindingName = bindingName;
    }

    public ComplexPatternElement(ConstraintGroup constraintGroup, int minOccurance, int maxOccurance, String bindingName) {
        this.constraintGroup = constraintGroup;
        this.kleeneOp = new KleeneOperator(minOccurance, maxOccurance);
        this.bindingName = bindingName;
    }

    @Override
    public Object clone() {
        ComplexPatternElement newPE = (ComplexPatternElement)super.clone();
        newPE.constraintGroup = (ConstraintGroup)this.constraintGroup.clone();
        return newPE;
    }

    @Override
    public void finish() {
        this.constraintGroup.finish();
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String pad) {
        String newline = Strings.getNl();
        StringBuffer buf = new StringBuffer(pad + "CPE: bindingName(" + this.bindingName + "); kleeneOp(");
        if (this.kleeneOp != null) {
            buf.append(this.kleeneOp);
        }
        buf.append("); constraintGroup(" + newline + this.constraintGroup.toString(Strings.addPadding((String)pad, (int)4)) + newline + pad + ") CPE." + newline);
        return buf.toString();
    }

    public KleeneOperator getKleeneOp() {
        return this.kleeneOp;
    }

    public ConstraintGroup getConstraintGroup() {
        return this.constraintGroup;
    }
}

