/*
 * Decompiled with CFR 0.152.
 */
package gate.fsm;

import gate.fsm.RuleTime;
import gate.fsm.Transition;
import gate.jape.BasicPatternElement;
import gate.jape.JapeConstants;
import gate.jape.RightHandSide;
import gate.util.SimpleArraySet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class State
implements JapeConstants {
    private static final long serialVersionUID = 1733852753275942428L;
    public static final int UNKNOWN_INDEX = 1;
    public static final int VISITED_INDEX = -2;
    public static final int UNVISITED_INDEX = 2;
    public static final int INITIAL_INDEX = 0;
    public static final String INITIAL_RULE = "_____Initial_State_for_all_rules";
    public static final String UNKNOWN_RULE = "___UNKNOWN_RULES_TYPE_1";
    public static final String UNVISITED_RULE = "___UNKNOWN_RULES_TYPE_2";
    private int indexInRuleList = 2;
    private SimpleArraySet<Transition> transitions = new SimpleArraySet();
    protected boolean isFinal = false;
    protected RightHandSide action = null;
    protected int myIndex = index.getAndIncrement();
    protected static final AtomicInteger index = new AtomicInteger(0);
    protected int fileIndex = 0;
    protected int priority = -1;

    public int getIndexInRuleList() {
        return this.indexInRuleList;
    }

    void setIndexInRuleList(int indexInRuleList) {
        this.indexInRuleList = indexInRuleList;
    }

    public int getRuleForState(Map<String, Integer> ruleNameToIndexMap, List<RuleTime> ruleTimes) {
        if (this.getIndexInRuleList() != 2) {
            return this.getIndexInRuleList();
        }
        if (this.isFinal()) {
            int returnVal;
            String ruleNameOfThisState = this.getAction().getRuleName();
            if (ruleNameToIndexMap.containsKey(ruleNameOfThisState)) {
                returnVal = ruleNameToIndexMap.get(ruleNameOfThisState);
            } else {
                ruleTimes.add(new RuleTime(0L, ruleNameOfThisState));
                ruleNameToIndexMap.put(ruleNameOfThisState, ruleTimes.size() - 1);
                returnVal = ruleTimes.size() - 1;
            }
            this.setIndexInRuleList(returnVal);
            return returnVal;
        }
        this.setIndexInRuleList(-2);
        int returnVal = 1;
        for (Transition t : this.getTransitions()) {
            int tempReturn = t.getTarget().getRuleForState(ruleNameToIndexMap, ruleTimes);
            if (tempReturn == 1 || tempReturn == -2) continue;
            returnVal = tempReturn;
        }
        if (returnVal == 1) {
            this.setIndexInRuleList(returnVal);
        } else {
            this.propogateRuleForward(returnVal);
        }
        return returnVal;
    }

    private void propogateRuleForward(int ruleForThisState) {
        this.setIndexInRuleList(ruleForThisState);
        for (Transition t : this.getTransitions()) {
            if (t.getTarget().getIndexInRuleList() != 1) continue;
            t.getTarget().propogateRuleForward(ruleForThisState);
        }
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public SimpleArraySet<Transition> getTransitions() {
        return this.transitions;
    }

    protected void setAction(RightHandSide rhs) {
        this.action = rhs;
        this.isFinal = this.action != null;
    }

    protected void setFileIndex(int i) {
        this.fileIndex = i;
    }

    protected void setPriority(int i) {
        this.priority = i;
    }

    public RightHandSide getAction() {
        return this.action;
    }

    protected int getFileIndex() {
        return this.fileIndex;
    }

    protected int getPriority() {
        return this.priority;
    }

    public void addTransition(Transition transition) {
        this.transitions.add((Object)transition);
    }

    public int getIndex() {
        return this.myIndex;
    }

    public String getEdgesGML() {
        StringBuffer res = new StringBuffer(1024);
        for (Transition currentTrans : this.transitions) {
            res.append("edge [ source ");
            res.append(this.myIndex);
            res.append(" target ");
            res.append(currentTrans.getTarget().getIndex());
            res.append(" label \"");
            res.append(currentTrans.shortDesc());
            res.append(":");
            BasicPatternElement bpe = currentTrans.getConstraints();
            if (bpe == null) {
                res.append("null");
            } else {
                res.append(bpe.shortDesc());
            }
            res.append(" :");
            res.append(currentTrans.getBindings());
            res.append("\" ]\n");
        }
        return res.toString();
    }

    public String toString() {
        StringBuffer res = new StringBuffer(1024);
        if (this.isFinal()) {
            res.append("\nFinal!");
        }
        res.append("\nTransitions:\n");
        Iterator transIter = this.transitions.iterator();
        while (transIter.hasNext()) {
            res.append(((Transition)transIter.next()).toString());
        }
        return res.toString();
    }
}

