/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.tokeniser;

import gate.creole.tokeniser.SimpleTokeniser;
import gate.creole.tokeniser.UnicodeType;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

class FSMState
implements Serializable {
    private static final long serialVersionUID = -8044319707799787043L;
    Set<FSMState>[] transitionFunction = new Set[SimpleTokeniser.maxTypeId + 1];
    String rhs;
    int myIndex = index.getAndIncrement();
    static final AtomicInteger index = new AtomicInteger(0);

    public FSMState(SimpleTokeniser owner) {
        owner.fsmStates.add(this);
    }

    Set<FSMState> nextSet(UnicodeType type) {
        if (null == type) {
            return this.transitionFunction[SimpleTokeniser.maxTypeId];
        }
        return this.transitionFunction[type.type];
    }

    Set<FSMState> nextSet(int type) {
        return this.transitionFunction[type];
    }

    void put(UnicodeType type, FSMState state) {
        if (null == type) {
            this.put(SimpleTokeniser.maxTypeId, state);
        } else {
            this.put(type.type, state);
        }
    }

    void put(int index, FSMState state) {
        if (null == this.transitionFunction[index]) {
            this.transitionFunction[index] = new HashSet<FSMState>();
        }
        this.transitionFunction[index].add(state);
    }

    void setRhs(String rhs) {
        this.rhs = rhs;
    }

    String getRhs() {
        return this.rhs;
    }

    boolean isFinal() {
        return null != this.rhs;
    }

    int getIndex() {
        return this.myIndex;
    }

    String getEdgesGML() {
        StringBuffer res = new StringBuffer(1024);
        for (int i = 0; i <= SimpleTokeniser.maxTypeId; ++i) {
            Set<FSMState> nextSet = this.transitionFunction[i];
            if (null == nextSet) continue;
            for (FSMState nextState : nextSet) {
                res.append("edge [ source ");
                res.append(this.myIndex);
                res.append(" target ");
                res.append(nextState.getIndex());
                res.append(" label \"");
                if (i == SimpleTokeniser.maxTypeId) {
                    res.append("[]");
                } else {
                    res.append(SimpleTokeniser.typeMnemonics.get(i));
                }
                res.append("\" ]\n");
            }
        }
        return res.toString();
    }
}

