/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.coref;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.FeatureMap;
import gate.Resource;
import gate.creole.ANNIEConstants;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ResourceInstantiationException;
import gate.util.GateRuntimeException;
import gate.util.SimpleFeatureMapImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractCoreferencer
extends AbstractLanguageAnalyser
implements ANNIEConstants {
    private static final long serialVersionUID = 7077378848676784207L;
    public static final String COREF_DOCUMENT_PARAMETER_NAME = "document";
    public static final String COREF_ANN_SET_PARAMETER_NAME = "annotationSetName";
    public static final String COREF_TYPE_FEATURE_NAME = "ENTITY_MENTION_TYPE";
    public static final String COREF_ANTECEDENT_FEATURE_NAME = "antecedent_offset";
    private static final boolean DEBUG = false;
    public String coreferenceType;

    public AbstractCoreferencer(String type) {
        this.coreferenceType = type;
    }

    public Resource init() throws ResourceInstantiationException {
        Resource result = super.init();
        return result;
    }

    public void reInit() throws ResourceInstantiationException {
        this.init();
    }

    public void setDocument(Document newDocument) {
        super.setDocument(newDocument);
    }

    public abstract void setAnnotationSetName(String var1);

    public abstract String getAnnotationSetName();

    protected void generateCorefChains(Map<Annotation, Annotation> ana2ant) throws GateRuntimeException {
        String asName = this.getAnnotationSetName();
        AnnotationSet outputSet = null;
        outputSet = null == asName || asName.equals("") ? this.getDocument().getAnnotations() : this.getDocument().getAnnotations(asName);
        for (Map.Entry<Annotation, Annotation> currLink : ana2ant.entrySet()) {
            Annotation anaphor = currLink.getKey();
            Annotation antecedent = currLink.getValue();
            if (null == antecedent) continue;
            ArrayList<Integer> matches = (ArrayList<Integer>)antecedent.getFeatures().get((Object)"matches");
            if (null == matches) {
                List<ArrayList<Integer>> matchesList;
                Map matchesMap;
                matches = new ArrayList<Integer>();
                matches.add(antecedent.getId());
                antecedent.getFeatures().put((Object)"matches", matches);
                if (this.document.getFeatures().containsKey((Object)"MatchesAnnots")) {
                    matchesMap = (Map)this.document.getFeatures().get((Object)"MatchesAnnots");
                    matchesList = (List)matchesMap.get(this.getAnnotationSetName());
                    if (matchesList == null) {
                        matchesList = new ArrayList();
                        matchesMap.put(this.getAnnotationSetName(), matchesList);
                    }
                    matchesList.add(matches);
                } else {
                    matchesMap = new HashMap();
                    matchesList = new ArrayList();
                    matchesMap.put(this.getAnnotationSetName(), matchesList);
                    matchesList.add(matches);
                }
            }
            SimpleFeatureMapImpl features = new SimpleFeatureMapImpl();
            features.put((Object)COREF_TYPE_FEATURE_NAME, (Object)this.coreferenceType);
            features.put((Object)"matches", matches);
            features.put((Object)COREF_ANTECEDENT_FEATURE_NAME, (Object)antecedent.getStartNode().getOffset());
            Integer annID = outputSet.add(anaphor.getStartNode(), anaphor.getEndNode(), antecedent.getType(), (FeatureMap)features);
            matches.add(annID);
        }
    }
}

