/*
 * Decompiled with CFR 0.152.
 */
package gate.util.compilers;

import gate.Gate;
import gate.util.Err;
import gate.util.GateClassLoader;
import gate.util.GateException;
import gate.util.Javac;
import gate.util.Strings;
import gate.util.compilers.eclipse.jdt.core.compiler.CategorizedProblem;
import gate.util.compilers.eclipse.jdt.core.compiler.IProblem;
import gate.util.compilers.eclipse.jdt.internal.compiler.ClassFile;
import gate.util.compilers.eclipse.jdt.internal.compiler.CompilationResult;
import gate.util.compilers.eclipse.jdt.internal.compiler.Compiler;
import gate.util.compilers.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import gate.util.compilers.eclipse.jdt.internal.compiler.ICompilerRequestor;
import gate.util.compilers.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import gate.util.compilers.eclipse.jdt.internal.compiler.IProblemFactory;
import gate.util.compilers.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import gate.util.compilers.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import gate.util.compilers.eclipse.jdt.internal.compiler.env.IBinaryType;
import gate.util.compilers.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import gate.util.compilers.eclipse.jdt.internal.compiler.env.INameEnvironment;
import gate.util.compilers.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import gate.util.compilers.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import gate.util.compilers.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Eclipse
extends Javac {
    public static final boolean DEBUG = false;
    private static final Logger log = LoggerFactory.getLogger(Eclipse.class);

    public void compile(Map<String, String> sources, final GateClassLoader classLoader) throws GateException {
        final HashMap<String, String> sourcesFiltered = new HashMap<String, String>(sources);
        Iterator srcIter = sourcesFiltered.entrySet().iterator();
        while (srcIter.hasNext()) {
            String className = (String)srcIter.next().getKey();
            if (classLoader.findExistingClass(className) == null) continue;
            log.warn("Cannot compile class \"" + className + "\" as a version already exists in the target class loader.");
            srcIter.remove();
        }
        if (sourcesFiltered.isEmpty()) {
            return;
        }
        final HashMap problems = new HashMap();
        INameEnvironment env = new INameEnvironment(){

            public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
                StringBuilder result = new StringBuilder();
                String sep = "";
                for (int i = 0; i < compoundTypeName.length; ++i) {
                    result.append(sep);
                    result.append(compoundTypeName[i]);
                    sep = ".";
                }
                return this.findType(result.toString());
            }

            public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
                StringBuilder result = new StringBuilder();
                String sep = "";
                for (int i = 0; i < packageName.length; ++i) {
                    result.append(sep);
                    result.append(packageName[i]);
                    sep = ".";
                }
                result.append(sep);
                result.append(typeName);
                return this.findType(result.toString());
            }

            private NameEnvironmentAnswer findType(String className) {
                try {
                    if (sourcesFiltered.containsKey(className)) {
                        class CompilationUnit
                        implements ICompilationUnit {
                            String className;
                            final /* synthetic */ Map val$sourcesFiltered;

                            CompilationUnit(String className) {
                                this.val$sourcesFiltered = map;
                                this.className = className;
                            }

                            public char[] getFileName() {
                                return this.className.toCharArray();
                            }

                            public char[] getContents() {
                                return ((String)this.val$sourcesFiltered.get(this.className)).toCharArray();
                            }

                            public char[] getMainTypeName() {
                                int dot = this.className.lastIndexOf(46);
                                if (dot > 0) {
                                    return this.className.substring(dot + 1).toCharArray();
                                }
                                return this.className.toCharArray();
                            }

                            public char[][] getPackageName() {
                                StringTokenizer izer = new StringTokenizer(this.className, ".");
                                char[][] result = new char[izer.countTokens() - 1][];
                                for (int i = 0; i < result.length; ++i) {
                                    String tok = izer.nextToken();
                                    result[i] = tok.toCharArray();
                                }
                                return result;
                            }

                            public boolean ignoreOptionalProblems() {
                                return false;
                            }
                        }
                        CompilationUnit compilationUnit = new CompilationUnit(Eclipse.this, className, sourcesFiltered);
                        return new NameEnvironmentAnswer((ICompilationUnit)compilationUnit, null);
                    }
                    String resourceName = className.replace('.', '/') + ".class";
                    InputStream is = Gate.getClassLoader().getResourceAsStream(resourceName);
                    if (is != null) {
                        int count;
                        byte[] buf = new byte[8192];
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(buf.length);
                        while ((count = is.read(buf, 0, buf.length)) > 0) {
                            baos.write(buf, 0, count);
                        }
                        baos.flush();
                        byte[] classBytes = baos.toByteArray();
                        char[] fileName = className.toCharArray();
                        ClassFileReader classFileReader = new ClassFileReader(classBytes, fileName, true);
                        return new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                    }
                }
                catch (IOException exc) {
                    System.err.println("Compilation error");
                    exc.printStackTrace();
                }
                catch (ClassFormatException exc) {
                    System.err.println("Compilation error");
                    exc.printStackTrace();
                }
                return null;
            }

            private boolean isPackage(String result) {
                if (sourcesFiltered.containsKey(result)) {
                    return false;
                }
                Class theClass = null;
                try {
                    theClass = classLoader.loadClass(result);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return theClass == null;
            }

            public boolean isPackage(char[][] parentPackageName, char[] packageName) {
                StringBuilder result = new StringBuilder();
                String sep = "";
                if (parentPackageName != null) {
                    for (int i = 0; i < parentPackageName.length; ++i) {
                        result.append(sep);
                        result.append(parentPackageName[i]);
                        sep = ".";
                    }
                }
                if (Character.isUpperCase(packageName[0]) && !this.isPackage(result.toString())) {
                    return false;
                }
                result.append(sep);
                result.append(packageName);
                return this.isPackage(result.toString());
            }

            public void cleanup() {
            }
        };
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("gate.util.compilers.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        settings.put("gate.util.compilers.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        settings.put("gate.util.compilers.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        settings.put("gate.util.compilers.eclipse.jdt.core.compiler.problem.unusedImport", "ignore");
        settings.put("gate.util.compilers.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        settings.put("gate.util.compilers.eclipse.jdt.core.compiler.problem.unusedLocal", "ignore");
        settings.put("gate.util.compilers.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "ignore");
        settings.put("gate.util.compilers.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        settings.put("gate.util.compilers.eclipse.jdt.core.compiler.problem.unusedLabel", "ignore");
        settings.put("gate.util.compilers.eclipse.jdt.core.compiler.source", "1.8");
        settings.put("gate.util.compilers.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        ICompilerRequestor requestor = new ICompilerRequestor(){

            public void acceptResult(CompilationResult result) {
                int i;
                boolean errors = false;
                if (result.hasProblems()) {
                    CategorizedProblem[] problems2 = result.getProblems();
                    for (i = 0; i < problems2.length; ++i) {
                        CategorizedProblem problem = problems2[i];
                        if (problem.isError()) {
                            errors = true;
                        }
                        this.addProblem((IProblem)problem);
                    }
                }
                if (!errors) {
                    ClassFile[] classFiles = result.getClassFiles();
                    for (i = 0; i < classFiles.length; ++i) {
                        ClassFile classFile = classFiles[i];
                        char[][] compoundName = classFile.getCompoundName();
                        StringBuilder className = new StringBuilder();
                        String sep = "";
                        for (int j = 0; j < compoundName.length; ++j) {
                            className.append(sep);
                            className.append(compoundName[j]);
                            sep = ".";
                        }
                        byte[] bytes = classFile.getBytes();
                        classLoader.defineGateClass(className.toString(), bytes, 0, bytes.length);
                    }
                }
            }

            private void addProblem(IProblem problem) {
                String name = new String(problem.getOriginatingFileName());
                ArrayList<IProblem> problemsForName = (ArrayList<IProblem>)problems.get(name);
                if (problemsForName == null) {
                    problemsForName = new ArrayList<IProblem>();
                    problems.put(name, problemsForName);
                }
                problemsForName.add(problem);
            }
        };
        ICompilationUnit[] compilationUnits = new ICompilationUnit[sourcesFiltered.size()];
        int i = 0;
        Iterator sourcesIt = sourcesFiltered.keySet().iterator();
        while (sourcesIt.hasNext()) {
            compilationUnits[i++] = new CompilationUnit((String)sourcesIt.next());
        }
        Compiler compiler = new Compiler(env, policy, new CompilerOptions(settings), requestor, (IProblemFactory)problemFactory);
        compiler.compile(compilationUnits);
        if (!problems.isEmpty()) {
            boolean errors = false;
            for (Map.Entry prob : problems.entrySet()) {
                String name = (String)prob.getKey();
                List probsForName = (List)prob.getValue();
                for (IProblem problem : probsForName) {
                    if (problem.isError()) {
                        Err.pr((String)"Error: ");
                        errors = true;
                    } else if (problem.isWarning()) {
                        Err.pr((String)"Warning: ");
                    }
                    Err.prln((String)(problem.getMessage() + " at line " + problem.getSourceLineNumber() + " in " + name));
                }
                Err.prln((String)"\nThe offending input was:\n");
                Err.prln((String)Strings.addLineNumbers((String)((String)sourcesFiltered.get(name))));
            }
            if (errors) {
                throw new GateException("There were errors; see error log for details!");
            }
        }
    }
}

