/*
 * Decompiled with CFR 0.152.
 */
package gate.fsm;

import gate.Annotation;
import gate.fsm.State;
import gate.jape.BasicPatternElement;
import gate.jape.Constraint;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class Transition
implements Serializable,
Comparable<Transition> {
    private static final long serialVersionUID = 5970884178025357306L;
    private BasicPatternElement constraints;
    private State target;
    private List<String> bindings;
    private int myIndex = index.getAndIncrement();
    private static final AtomicInteger index = new AtomicInteger(0);

    public Transition() {
    }

    public Transition(BasicPatternElement constraints, State state) {
        this(constraints, state, new LinkedList<String>());
    }

    public Transition(BasicPatternElement constraints, State state, List<String> bindings) {
        this();
        this.constraints = constraints;
        this.target = state;
        this.bindings = bindings;
    }

    public Transition spawn(State s) {
        return new Transition(this.constraints, s, this.bindings);
    }

    public State getTarget() {
        return this.target;
    }

    public BasicPatternElement getConstraints() {
        return this.constraints;
    }

    public boolean hasConstraints() {
        return this.constraints != null;
    }

    public boolean satisfiedBy(Annotation[] coIncidentAnnos) {
        Constraint[] allConstraints = this.getConstraints().getConstraints();
        block0: for (int i = 0; i < allConstraints.length; ++i) {
            Constraint c = allConstraints[i];
            boolean negated = c.isNegated();
            for (int j = 0; j < coIncidentAnnos.length; ++j) {
                if (!c.matches(coIncidentAnnos[j], null)) continue;
                if (!negated) continue block0;
                return false;
            }
            if (negated) continue;
            return false;
        }
        return true;
    }

    public boolean isMultiType() {
        return this.constraints != null && this.constraints.isMultiType();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeTarget) {
        StringBuffer toReturn = new StringBuffer();
        if (includeTarget) {
            toReturn.append("If: ");
        }
        toReturn.append(this.constraints);
        if (includeTarget) {
            toReturn.append(" then ->: " + this.target.getIndex());
        }
        return toReturn.toString();
    }

    public String shortDesc() {
        String res = "" + this.myIndex;
        return res;
    }

    public List<String> getBindings() {
        return this.bindings;
    }

    @Override
    public int compareTo(Transition t) throws ClassCastException {
        return this.myIndex - t.myIndex;
    }
}

