/*
 * Decompiled with CFR 0.152.
 */
package gate.fsm;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Node;
import gate.fsm.FSM;
import gate.fsm.State;
import gate.jape.RightHandSide;
import gate.util.Err;
import gate.util.InvalidOffsetException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class FSMInstance
implements Comparable<FSMInstance>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -2081096002552818621L;
    private FSM supportGraph;
    private State FSMPosition;
    private Node AGPosition;
    private Node startNode;
    private Map<String, AnnotationSet> bindings;
    private long length = 0L;
    private int fileIndex;
    private Document document;
    private int priority;
    private static LinkedList<FSMInstance> myInstances = new LinkedList();

    public FSMInstance(FSM supportGraph, State FSMPosition, Node startNode, Node AGPosition, HashMap<String, AnnotationSet> bindings, Document document) {
        this.supportGraph = supportGraph;
        this.FSMPosition = FSMPosition;
        this.startNode = startNode;
        this.AGPosition = AGPosition;
        this.bindings = bindings;
        this.document = document;
        this.length = AGPosition.getOffset() - startNode.getOffset();
        this.fileIndex = FSMPosition.getFileIndex();
        this.priority = FSMPosition.getPriority();
    }

    public FSM getSupportGraph() {
        return this.supportGraph;
    }

    public State getFSMPosition() {
        return this.FSMPosition;
    }

    public void setFSMPosition(State newFSMPos) {
        this.FSMPosition = newFSMPos;
        this.fileIndex = this.FSMPosition.getFileIndex();
        this.priority = this.FSMPosition.getPriority();
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public Node getStartAGPosition() {
        return this.startNode;
    }

    public Node getAGPosition() {
        return this.AGPosition;
    }

    public void setAGPosition(Node node) {
        this.AGPosition = node;
        this.length = this.AGPosition.getOffset() - this.startNode.getOffset();
    }

    public Map<String, AnnotationSet> getBindings() {
        return this.bindings;
    }

    public long getLength() {
        return this.length;
    }

    public int hashCode() {
        return (int)this.length ^ this.priority ^ this.fileIndex ^ this.bindings.hashCode() ^ this.FSMPosition.getAction().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof FSMInstance) {
            FSMInstance otherFSM = (FSMInstance)other;
            boolean result = this.length == otherFSM.length && this.priority == otherFSM.priority && this.fileIndex == otherFSM.fileIndex && this.bindings.equals(otherFSM.bindings) && this.FSMPosition.getAction().equals(otherFSM.FSMPosition.getAction());
            return result;
        }
        return false;
    }

    public Object clone() {
        try {
            FSMInstance clone = (FSMInstance)super.clone();
            clone.bindings = new HashMap<String, AnnotationSet>(this.bindings);
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace(Err.getPrintWriter());
            return null;
        }
    }

    @Override
    public int compareTo(FSMInstance other) {
        if (other == this) {
            return 0;
        }
        if (this.length < other.getLength()) {
            return -1;
        }
        if (this.length > other.getLength()) {
            return 1;
        }
        if (this.priority < other.priority) {
            return -1;
        }
        if (this.priority > other.priority) {
            return 1;
        }
        return other.fileIndex - this.fileIndex;
    }

    public String toString() {
        String res = "";
        RightHandSide rhs = this.getFSMPosition().getAction();
        if (rhs != null) {
            res = res + rhs.getPhaseName() + "." + rhs.getRuleName() + ": \"";
            try {
                res = res + this.document.getContent().getContent(this.getStartAGPosition().getOffset(), this.getAGPosition().getOffset()).toString() + "\"";
            }
            catch (InvalidOffsetException ioe) {
                ioe.printStackTrace(Err.getPrintWriter());
            }
            res = res + "\n{";
            for (Map.Entry<String, AnnotationSet> entry : this.bindings.entrySet()) {
                String label = entry.getKey();
                Collection annots = (Collection)entry.getValue();
                res = res + "\n" + label + ": ";
                for (Annotation ann : annots) {
                    res = res + ann.getType() + "(\"";
                    try {
                        res = res + this.document.getContent().getContent(ann.getStartNode().getOffset(), ann.getEndNode().getOffset()).toString();
                    }
                    catch (InvalidOffsetException ioe) {
                        ioe.printStackTrace(Err.getPrintWriter());
                    }
                    res = res + "\") ";
                }
            }
            res = res + "\n}";
        } else {
            res = res + "FSM position :" + this.FSMPosition.getIndex() + "\nFirst matched ANN at:" + this.startNode.getId() + "\nLast matched ANN at :" + this.AGPosition.getId() + "\nPriority :" + this.priority + "\nFile index :" + this.fileIndex + "\nBindings     :" + this.bindings;
        }
        return res;
    }

    public static FSMInstance getNewInstance(FSM supportGraph, State FSMPosition, Node startNode, Node AGPosition, HashMap<String, AnnotationSet> bindings, Document doc) {
        FSMInstance res;
        if (myInstances.isEmpty()) {
            res = new FSMInstance(supportGraph, FSMPosition, startNode, AGPosition, bindings, doc);
        } else {
            res = myInstances.removeFirst();
            res.supportGraph = supportGraph;
            res.FSMPosition = FSMPosition;
            res.startNode = startNode;
            res.AGPosition = AGPosition;
            res.bindings = bindings;
        }
        return res;
    }

    public static void returnInstance(FSMInstance ins) {
        myInstances.addFirst(ins);
    }

    public static void clearInstances() {
        myInstances = new LinkedList();
    }
}

