/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.orthomatcher;

import gate.Annotation;
import gate.creole.orthomatcher.OrthoMatcher;
import gate.creole.orthomatcher.OrthoMatcherHelper;
import gate.creole.orthomatcher.OrthoMatcherRule;

public class MatchRule16
implements OrthoMatcherRule {
    OrthoMatcher orthmatcher;

    public MatchRule16(OrthoMatcher orthomatcher) {
        this.orthmatcher = orthomatcher;
    }

    @Override
    public boolean value(String s1, String s2) {
        boolean result = true;
        for (int i = 0; i < this.orthmatcher.tokensShortAnnot.size(); ++i) {
            Annotation token1 = this.orthmatcher.tokensShortAnnot.get(i);
            if (token1.getFeatures().get((Object)"kind").equals("punctuation")) continue;
            String ts1 = (String)token1.getFeatures().get((Object)"string");
            boolean foundMatch = false;
            for (int j = 0; j < this.orthmatcher.tokensLongAnnot.size(); ++j) {
                Annotation token2 = this.orthmatcher.tokensLongAnnot.get(j);
                if (token2.getFeatures().get((Object)"kind").equals("punctuation")) continue;
                String ts2 = (String)token2.getFeatures().get((Object)"string");
                if (i == 0 && j == 0) {
                    foundMatch = this.orthmatcher.getOrthography().fuzzyMatch(ts1, ts2);
                    continue;
                }
                if (this.orthmatcher.caseSensitive) {
                    if (!ts2.equals(ts1)) continue;
                    foundMatch = true;
                    break;
                }
                if (!ts2.equalsIgnoreCase(ts1)) continue;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            result = false;
        }
        if (OrthoMatcher.log.isDebugEnabled()) {
            OrthoMatcher.log.debug("rule 16 matched " + s1 + " to " + s2);
        }
        if (result) {
            OrthoMatcherHelper.usedRule(16);
        }
        return result;
    }

    @Override
    public String getId() {
        return "MatchRule16";
    }
}

