/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.gazetteer;

import gate.creole.AbstractLanguageResource;
import gate.creole.ResourceInstantiationException;
import gate.creole.gazetteer.GazetteerList;
import gate.creole.gazetteer.LinearNode;
import gate.util.BomStrippingInputStreamReader;
import gate.util.Files;
import gate.util.GateRuntimeException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class LinearDefinition
extends AbstractLanguageResource
implements List<LinearNode> {
    private static final long serialVersionUID = 4050479036709221175L;
    private static final String ENCODING = "UTF-8";
    private List<LinearNode> nodes = new ArrayList<LinearNode>();
    private URL url;
    private List<String> lists = new ArrayList<String>();
    private String encoding = "UTF-8";
    private Map<String, LinearNode> nodesByList = new HashMap<String, LinearNode>();
    private Map<LinearNode, GazetteerList> gazListsByNode = new HashMap<LinearNode, GazetteerList>();
    private boolean isModified = false;
    private String separator;

    public void setEncoding(String encod) {
        this.encoding = encod;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Map<LinearNode, GazetteerList> loadLists() throws ResourceInstantiationException {
        return this.loadLists(false);
    }

    public Map<LinearNode, GazetteerList> loadLists(boolean isOrdered) throws ResourceInstantiationException {
        try {
            this.gazListsByNode = new HashMap<LinearNode, GazetteerList>();
            for (LinearNode node : this.nodes) {
                GazetteerList list = new GazetteerList();
                list.setSeparator(this.separator);
                URL lurl = new URL(this.url, node.getList());
                list.setURL(lurl);
                list.setEncoding(this.encoding);
                list.load(isOrdered);
                this.gazListsByNode.put(node, list);
            }
        }
        catch (Exception ex) {
            throw new ResourceInstantiationException(ex);
        }
        return this.gazListsByNode;
    }

    public GazetteerList loadSingleList(String listName) throws ResourceInstantiationException {
        return this.loadSingleList(listName, false);
    }

    public GazetteerList loadSingleList(String listName, boolean isOrdered) throws ResourceInstantiationException {
        GazetteerList list = new GazetteerList();
        list.setSeparator(this.separator);
        try {
            try {
                URL lurl = new URL(this.url, listName);
                list.setURL(lurl);
                list.load(isOrdered);
            }
            catch (Exception x) {
                File f;
                if (!"file".equals(this.url.getProtocol())) {
                    throw new ResourceInstantiationException(x);
                }
                String path = this.url.getPath();
                int slash = path.lastIndexOf("/");
                if (-1 != slash) {
                    path = path.substring(0, slash + 1);
                }
                if (!(f = new File(path + listName)).exists()) {
                    f.createNewFile();
                }
                URL lurl = new URL(this.url, listName);
                list.setURL(lurl);
                list.load(isOrdered);
            }
        }
        catch (MalformedURLException murle) {
            throw new ResourceInstantiationException((Exception)murle);
        }
        catch (IOException ioex) {
            throw new ResourceInstantiationException((Exception)ioex);
        }
        return list;
    }

    public Map<LinearNode, GazetteerList> getListsByNode() {
        return this.gazListsByNode;
    }

    public Map<String, LinearNode> getNodesByListNames() {
        return this.nodesByList;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setModified(boolean modified) {
        this.isModified = modified;
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL aUrl) {
        this.url = aUrl;
    }

    public void load() throws ResourceInstantiationException {
        if (null == this.url) {
            throw new ResourceInstantiationException("URL not set (null).");
        }
        try {
            if ("file".equals(this.url.getProtocol())) {
                File definitionFile = Files.fileFromURL((URL)this.url);
                definitionFile.createNewFile();
            }
            try (BomStrippingInputStreamReader defReader = new BomStrippingInputStreamReader(this.url.openStream(), ENCODING);){
                String line;
                while (null != (line = defReader.readLine())) {
                    LinearNode node = new LinearNode(line);
                    this.add(node);
                }
            }
            this.isModified = false;
        }
        catch (Exception x) {
            throw new ResourceInstantiationException(x);
        }
    }

    public void store() throws ResourceInstantiationException {
        if (null == this.url) {
            throw new ResourceInstantiationException("URL not set.(null)");
        }
        try {
            File fileo = Files.fileFromURL((URL)this.url);
            fileo.delete();
            BufferedWriter defWriter = new BufferedWriter(new FileWriter(fileo));
            Iterator<LinearNode> inodes = this.nodes.iterator();
            while (inodes.hasNext()) {
                defWriter.write(inodes.next().toString());
                defWriter.newLine();
            }
            defWriter.close();
            this.isModified = false;
        }
        catch (Exception x) {
            throw new ResourceInstantiationException(x);
        }
    }

    public List<String> getLists() {
        return new ArrayList<String>(this.lists);
    }

    public List<LinearNode> getNodes() {
        return new ArrayList<LinearNode>(this.nodes);
    }

    public Set<String> getMajors() {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < this.nodes.size(); ++i) {
            String maj = this.nodes.get(i).getMajorType();
            if (null == maj) continue;
            result.add(maj);
        }
        return result;
    }

    public Set<String> getMinors() {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < this.nodes.size(); ++i) {
            String min = this.nodes.get(i).getMinorType();
            if (null == min) continue;
            result.add(min);
        }
        result.add("");
        return result;
    }

    public Set<String> getLanguages() {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < this.nodes.size(); ++i) {
            String lang = this.nodes.get(i).getLanguage();
            if (null == lang) continue;
            result.add(lang);
        }
        result.add("");
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends LinearNode> c) {
        int size = this.nodes.size();
        for (LinearNode linearNode : c) {
            this.add(index, linearNode);
        }
        boolean result = size != this.nodes.size();
        this.isModified |= result;
        return result;
    }

    @Override
    public LinearNode get(int index) {
        return this.nodes.get(index);
    }

    @Override
    public LinearNode set(int index, LinearNode element) {
        throw new UnsupportedOperationException("this method has not been implemented");
    }

    @Override
    public void add(int index, LinearNode ln) {
        String list = ln.getList();
        if (!this.nodesByList.containsKey(list)) {
            try {
                GazetteerList gl = this.loadSingleList(list);
                this.gazListsByNode.put(ln, gl);
                this.nodes.add(index, ln);
                this.nodesByList.put(list, ln);
                this.lists.add(list);
                this.isModified = true;
            }
            catch (ResourceInstantiationException x) {
                throw new GateRuntimeException("Error loading list: " + list + ": " + x.getMessage(), (Throwable)x);
            }
        }
    }

    @Override
    public LinearNode remove(int index) {
        LinearNode result = null;
        int size = this.nodes.size();
        result = this.nodes.remove(index);
        if (null != result) {
            String list = result.getList();
            this.lists.remove(list);
            this.nodesByList.remove(list);
            this.gazListsByNode.remove(result);
            this.isModified |= size != this.nodes.size();
        }
        return result;
    }

    @Override
    public int indexOf(Object o) {
        return this.nodes.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.nodes.lastIndexOf(o);
    }

    @Override
    public ListIterator<LinearNode> listIterator() {
        throw new UnsupportedOperationException("this method is not implemented");
    }

    @Override
    public ListIterator<LinearNode> listIterator(int index) {
        throw new UnsupportedOperationException("this method is not implemented");
    }

    @Override
    public List<LinearNode> subList(int fromIndex, int toIndex) {
        return this.nodes.subList(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.nodes.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.nodes.contains(o);
    }

    @Override
    public Iterator<LinearNode> iterator() {
        return new SafeIterator();
    }

    @Override
    public Object[] toArray() {
        return this.nodes.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.nodes.toArray(a);
    }

    @Override
    public boolean add(LinearNode o) {
        boolean result = false;
        String list = o.getList();
        if (!this.nodesByList.containsKey(list)) {
            try {
                GazetteerList gl = this.loadSingleList(list);
                this.gazListsByNode.put(o, gl);
                result = this.nodes.add(o);
                this.nodesByList.put(list, o);
                this.lists.add(list);
                this.isModified = true;
            }
            catch (ResourceInstantiationException x) {
                throw new GateRuntimeException("Error loading list: " + list + ": " + x.getMessage(), (Throwable)x);
            }
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = false;
        int size = this.nodes.size();
        if (o instanceof LinearNode) {
            result = this.nodes.remove(o);
            String list = ((LinearNode)o).getList();
            this.lists.remove(list);
            this.nodesByList.remove(list);
            this.gazListsByNode.remove(o);
            this.isModified |= size != this.nodes.size();
        }
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.nodes.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends LinearNode> c) {
        boolean result = false;
        for (LinearNode linearNode : c) {
            result |= this.add(linearNode);
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object o : c) {
            result |= this.remove(o);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        int aprioriSize = this.nodes.size();
        ArrayList<LinearNode> scrap = new ArrayList<LinearNode>();
        for (LinearNode node : this.nodes) {
            if (!c.contains(node)) continue;
            scrap.add(node);
        }
        this.removeAll(scrap);
        this.isModified |= aprioriSize != this.nodes.size();
        return aprioriSize != this.nodes.size();
    }

    @Override
    public void clear() {
        this.nodes.clear();
        this.lists.clear();
        this.nodesByList.clear();
        this.gazListsByNode.clear();
        this.isModified = true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lists == null ? 0 : this.lists.hashCode());
        result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
        result = 31 * result + (this.nodesByList == null ? 0 : this.nodesByList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinearDefinition other = (LinearDefinition)obj;
        if (this.lists == null ? other.lists != null : !this.lists.equals(other.lists)) {
            return false;
        }
        if (this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes)) {
            return false;
        }
        return !(this.nodesByList == null ? other.nodesByList != null : !this.nodesByList.equals(other.nodesByList));
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    private class SafeIterator
    implements Iterator<LinearNode> {
        private Iterator<LinearNode> iter;
        private boolean removeCalled;
        private LinearNode last;

        private SafeIterator() {
            this.iter = LinearDefinition.this.nodes.iterator();
            this.removeCalled = false;
            this.last = null;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public LinearNode next() {
            this.removeCalled = false;
            this.last = this.iter.next();
            return this.last;
        }

        @Override
        public void remove() {
            if (!this.removeCalled && null != this.last) {
                LinearDefinition.this.remove(this.last);
            }
            this.removeCalled = true;
        }
    }
}

