/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.gate.gazetteer;

import gate.AnnotationSet;
import gate.Factory;
import gate.FeatureMap;
import gate.Resource;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.gazetteer.AbstractGazetteer;
import gate.creole.gazetteer.GazetteerException;
import gate.creole.gazetteer.GazetteerList;
import gate.creole.gazetteer.GazetteerNode;
import gate.creole.gazetteer.LinearDefinition;
import gate.creole.gazetteer.LinearNode;
import gate.creole.gazetteer.Lookup;
import gate.creole.gazetteer.MappingNode;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.HiddenCreoleParameter;
import gate.creole.metadata.Sharable;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@CreoleResource(name="Hash Gazetteer", icon="gazetteer", comment="A list lookup component implemented by OntoText Lab. The licence information is also available in licence.ontotext.html in the lib folder of GATE", helpURL="http://www.ontotext.com/downloads/index.html#gazetteer")
public class HashGazetteer
extends AbstractGazetteer {
    private static final long serialVersionUID = -4603155688378104052L;
    private ArrayList<Lookup> categoryList;
    private Map<LinearNode, GazetteerList> listsByNode;
    private Map<String, List<Lookup>>[] mapsList;
    private AnnotationSet annotationSet = null;

    public Resource init() throws ResourceInstantiationException {
        if (this.mapsList == null) {
            if (this.listsURL == null) {
                throw new ResourceInstantiationException("No URL provided for gazetteer creation!");
            }
            try {
                this.mapsList = new HashMap[1000];
                this.definition = new LinearDefinition();
                try {
                    this.definition.setURL(this.listsURL.toURL());
                }
                catch (IOException e) {
                    throw new ResourceInstantiationException((Exception)e);
                }
                this.definition.load();
                int i = this.definition.size();
                this.listsByNode = this.definition.loadLists();
                this.categoryList = new ArrayList(i + 1);
                Iterator<LinearNode> iterator = this.definition.iterator();
                int j = 0;
                while (iterator.hasNext()) {
                    LinearNode linearnode = iterator.next();
                    this.fireStatusChanged("Reading " + linearnode.toString());
                    this.fireProgressChanged(++j * 100 / i);
                    this.readList(linearnode);
                }
                this.fireProcessFinished();
            }
            catch (GazetteerException exception) {
                throw new ResourceInstantiationException((Exception)((Object)exception));
            }
        }
        return this;
    }

    @Override
    public void reInit() throws ResourceInstantiationException {
        this.mapsList = null;
        this.categoryList = null;
        this.init();
    }

    public void execute() throws ExecutionException {
        if (this.document == null) {
            throw new ExecutionException("Document is null!");
        }
        this.annotationSet = this.document.getAnnotations(this.annotationSetName);
        String s = this.document.getContent().toString() + " ";
        if (!this.caseSensitive.booleanValue()) {
            s = s.toUpperCase();
        }
        int documentLength = s.length();
        int j = 0;
        int k = 0;
        StringBuffer stringbuffer = new StringBuffer();
        boolean prevIsSymbol = false;
        boolean prevIsDigit = false;
        boolean prevIsLetter = false;
        boolean flag11 = false;
        String s3 = "";
        int i1 = 0;
        int j1 = 0;
        for (int position = 0; position < documentLength; ++position) {
            boolean flag13;
            char c = s.charAt(position);
            boolean currIsWhitespace = Character.isWhitespace(c);
            if (currIsWhitespace && stringbuffer.length() == 0) {
                ++j;
                flag11 = false;
                prevIsSymbol = false;
                prevIsDigit = false;
                prevIsLetter = false;
                continue;
            }
            if (currIsWhitespace && prevIsSymbol && stringbuffer.length() == 1) {
                j += 2;
                flag11 = false;
                prevIsSymbol = false;
                prevIsDigit = false;
                prevIsLetter = false;
                stringbuffer.delete(0, stringbuffer.length());
                continue;
            }
            boolean currIsLetter = Character.isLetter(c);
            boolean currIsDigit = Character.isDigit(c);
            boolean currIsSymbol = !currIsWhitespace && !currIsLetter && !currIsDigit;
            boolean currIsLowerCase = Character.isLowerCase(c);
            if (k <= j && (currIsWhitespace || currIsSymbol || flag11 && !currIsLowerCase || !prevIsLetter && currIsLetter)) {
                k = position;
            }
            boolean bl = flag13 = prevIsLetter && (currIsDigit || currIsSymbol || currIsWhitespace) || prevIsLetter && currIsLetter && flag11 && !currIsLowerCase || prevIsDigit && (currIsLetter || currIsSymbol || currIsWhitespace) || prevIsSymbol;
            if (position == documentLength - 1) {
                flag13 = true;
            }
            if (flag13) {
                int wordLength;
                String word;
                int k1;
                boolean flag16;
                boolean bl2 = flag16 = !currIsSymbol && !currIsDigit;
                if (position == documentLength - 1) {
                    flag16 = true;
                }
                flag16 &= (k1 = (word = this.normalizeWhitespace(stringbuffer.toString())).length()) - j1 > 1;
                j1 = k1;
                if (!(i1 == j && word.equals(s3) || (wordLength = word.length()) <= 0)) {
                    boolean flag14 = this.annotate(word, j, position, wordLength);
                    if (flag14) {
                        s3 = word;
                        i1 = j;
                    }
                    if (!flag14 && flag16 || documentLength - 1 == position) {
                        if (k <= j) {
                            k = position;
                        }
                        j = k;
                        position = k - 1;
                        stringbuffer.delete(0, stringbuffer.length());
                        continue;
                    }
                }
            }
            stringbuffer.append(c);
            prevIsDigit = currIsDigit;
            prevIsLetter = currIsLetter;
            prevIsSymbol = currIsSymbol;
        }
        this.fireProcessFinished();
        this.fireStatusChanged("Hash Gazetteer processing finished!");
    }

    @Override
    public boolean add(String word, Lookup lookup1) {
        String s2;
        if (!this.caseSensitive.booleanValue()) {
            word = word.toUpperCase();
        }
        if (!(s2 = this.removeTrailingSymbols(word)).equals(word)) {
            this.add(s2, lookup1);
        }
        String s3 = word + " ";
        ArrayList<Lookup> arraylist = null;
        int j = s3.length();
        boolean prevIsLetter = false;
        boolean prevIsDigit = false;
        boolean prevIsLowercase = false;
        String s4 = "";
        Map<Object, Object> hashmap = null;
        for (int k = 0; k < j; ++k) {
            boolean flag18;
            char c = s3.charAt(k);
            boolean currIsWhitespace = Character.isWhitespace(c);
            boolean currIsDigit = Character.isDigit(c);
            boolean currIsLetter = Character.isLetter(c);
            boolean currIsSymbol = !currIsWhitespace && !currIsDigit && !currIsLetter;
            boolean currIsLowercase = Character.isLowerCase(c);
            boolean bl = flag18 = prevIsLetter && (currIsDigit || currIsSymbol || currIsWhitespace) || prevIsLetter && currIsLetter && prevIsLowercase && !currIsLowercase || prevIsDigit && (currIsLetter || currIsSymbol || currIsWhitespace);
            if (k + 1 == j) {
                flag18 = true;
            }
            if (flag18) {
                s4 = this.normalizeWhitespace(s3.substring(0, k));
                int i = s4.length();
                if (this.mapsList[i] == null) {
                    hashmap = new HashMap();
                    this.mapsList[i] = hashmap;
                } else {
                    hashmap = this.mapsList[i];
                }
                if (!hashmap.containsKey(s4)) {
                    hashmap.put(s4, null);
                }
            }
            prevIsDigit = currIsDigit;
            prevIsLetter = currIsLetter;
            prevIsLowercase = currIsLowercase;
        }
        arraylist = (ArrayList<Lookup>)hashmap.get(s4);
        if (null == arraylist) {
            arraylist = new ArrayList<Lookup>(1);
            arraylist.add(lookup1);
        } else if (!arraylist.contains(lookup1)) {
            arraylist.add(lookup1);
        }
        hashmap.put(s4, arraylist);
        return true;
    }

    @Override
    public Set<Lookup> lookup(String s) {
        Set<Lookup> set = null;
        String s1 = this.normalizeWhitespace(s);
        int i = s1.length();
        if (this.mapsList.length < i) {
            return set;
        }
        Map<String, List<Lookup>> hashmap = this.mapsList[i];
        if (hashmap == null) {
            return set;
        }
        HashSet<Lookup> hashset = new HashSet<Lookup>((Collection)hashmap.get(s1));
        return hashset;
    }

    private boolean annotate(String word, int i, int documentPosition, int wordLength) {
        if (wordLength >= this.mapsList.length) {
            return false;
        }
        Map<String, List<Lookup>> hashmap = this.mapsList[wordLength];
        if (hashmap == null) {
            return false;
        }
        if (!hashmap.containsKey(word)) {
            return false;
        }
        List<Lookup> arraylist = hashmap.get(word);
        if (null != arraylist) {
            for (Lookup lookup1 : arraylist) {
                FeatureMap featuremap = Factory.newFeatureMap();
                featuremap.put((Object)"majorType", (Object)lookup1.majorType);
                if (null != lookup1.oClass && null != lookup1.ontology) {
                    featuremap.put((Object)"class", (Object)lookup1.oClass);
                    featuremap.put((Object)"ontology", (Object)lookup1.ontology);
                }
                if (null != lookup1.minorType) {
                    featuremap.put((Object)"minorType", (Object)lookup1.minorType);
                    if (null != lookup1.languages) {
                        featuremap.put((Object)"language", (Object)lookup1.languages);
                    }
                }
                try {
                    this.annotationSet.add(Long.valueOf(i), Long.valueOf(documentPosition), "Lookup", featuremap);
                }
                catch (InvalidOffsetException invalidoffsetexception) {
                    throw new GateRuntimeException(invalidoffsetexception.toString());
                }
            }
        }
        return true;
    }

    @Override
    public boolean remove(String s) {
        String s1 = this.a(s);
        int i = s1.length();
        if (i > this.mapsList.length) {
            return false;
        }
        Map<String, List<Lookup>> hashmap = this.mapsList[i];
        if (hashmap == null) {
            return false;
        }
        if (hashmap.containsKey(s1)) {
            hashmap.remove(s1);
            return true;
        }
        return false;
    }

    private String removeTrailingSymbols(String s) {
        for (int i = s.length() - 1; i >= 0; --i) {
            char c = s.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || Character.isWhitespace(c)) {
                return s;
            }
            s = s.substring(0, i);
        }
        return s;
    }

    private String normalizeWhitespace(String s) {
        StringBuffer stringbuffer = new StringBuffer();
        s = s.trim();
        char[] ac = s.toCharArray();
        int i = s.length();
        boolean prevWasWhitespace = false;
        for (int j = 0; j < i; ++j) {
            char c = ac[j];
            boolean currIsWhitespace = Character.isWhitespace(c);
            if (currIsWhitespace && !prevWasWhitespace) {
                stringbuffer.append(' ');
            } else if (!currIsWhitespace) {
                stringbuffer.append(c);
            }
            prevWasWhitespace = currIsWhitespace;
        }
        return stringbuffer.toString();
    }

    private String a(String s) {
        StringBuffer stringbuffer = new StringBuffer();
        boolean allLettersUppercase = true;
        s = s.trim();
        char[] ac = s.toCharArray();
        int i = s.length();
        if (i <= 1) {
            return s;
        }
        char firstCharacter = ac[0];
        stringbuffer.append(firstCharacter);
        boolean flag2 = true;
        boolean prevIsLetter = Character.isLetter(firstCharacter);
        boolean prevNotLetterOrDigit = !Character.isLetterOrDigit(firstCharacter);
        boolean flag10 = true;
        int c2 = 112;
        for (int j = 1; j < i; ++j) {
            int currentCharacter = ac[j];
            boolean currNotLetterOrDigit = !Character.isLetterOrDigit((char)currentCharacter);
            boolean currIsWhitespace = Character.isWhitespace((char)currentCharacter);
            boolean currIsLetter = Character.isLetter((char)currentCharacter);
            boolean currIsDigit = Character.isDigit((char)currentCharacter);
            if (flag2) {
                if (prevNotLetterOrDigit && currIsWhitespace) continue;
                boolean bl = flag2 = prevIsLetter && currNotLetterOrDigit || prevNotLetterOrDigit && currIsLetter;
                if (currNotLetterOrDigit) {
                    if (c2 == 112) {
                        c2 = currentCharacter;
                    }
                    flag10 = c2 == currentCharacter;
                    flag2 = flag10;
                }
                if (j > 2 && !flag2 && stringbuffer.length() > 0) {
                    char c3 = stringbuffer.charAt(stringbuffer.length() - 1);
                    stringbuffer.deleteCharAt(stringbuffer.length() - 1);
                    stringbuffer.append(Character.toLowerCase(c3));
                }
            }
            if (currIsLetter || currIsDigit) {
                if (currIsLetter) {
                    allLettersUppercase &= Character.isUpperCase((char)currentCharacter);
                }
                if (!flag10) {
                    currentCharacter = Character.toLowerCase((char)currentCharacter);
                }
                stringbuffer.append((char)currentCharacter);
            } else if (!flag2) {
                flag10 = false;
            }
            prevIsLetter = currIsLetter;
            prevNotLetterOrDigit = currNotLetterOrDigit;
        }
        String s1 = stringbuffer.toString();
        if (allLettersUppercase) {
            s1 = s1.toUpperCase();
        }
        return s1;
    }

    private void readList(LinearNode linearnode) throws GazetteerException {
        MappingNode mappingnode;
        if (linearnode == null) {
            throw new GazetteerException("LinearNode node is null");
        }
        GazetteerList gazetteerlist = this.listsByNode.get(linearnode);
        if (gazetteerlist == null) {
            throw new GazetteerException("gazetteer list not found by node");
        }
        String s = linearnode.getList();
        String majorType = linearnode.getMajorType();
        String minorType = linearnode.getMinorType();
        String language = linearnode.getLanguage();
        Lookup lookup1 = new Lookup(s, majorType, minorType, language);
        if (this.mappingDefinition != null && null != (mappingnode = this.mappingDefinition.getNodeByList(s))) {
            lookup1.oClass = mappingnode.getClassID();
            lookup1.ontology = mappingnode.getOntologyID();
        }
        lookup1.list = s;
        this.categoryList.add(lookup1);
        Iterator<GazetteerNode> iterator = gazetteerlist.iterator();
        String normalisedWord = null;
        while (iterator.hasNext()) {
            String word = iterator.next().toString();
            int wordLength = word.length();
            for (int j = 0; j < wordLength; ++j) {
                if (j + 1 != wordLength && !Character.isWhitespace(word.charAt(j))) continue;
                if (j + 1 == wordLength) {
                    j = wordLength;
                }
                normalisedWord = word.substring(0, j).trim();
            }
            this.add(normalisedWord, lookup1);
        }
    }

    @Override
    @HiddenCreoleParameter
    public void setWholeWordsOnly(Boolean wholeWordsOnly) {
        super.setWholeWordsOnly(wholeWordsOnly);
    }

    @Override
    @HiddenCreoleParameter
    public void setLongestMatchOnly(Boolean longestMatchOnly) {
        super.setLongestMatchOnly(longestMatchOnly);
    }

    @Sharable
    public void setMapsList(Map<String, List<Lookup>>[] mapsList) {
        this.mapsList = mapsList;
    }

    public Map<String, List<Lookup>>[] getMapsList() {
        return this.mapsList;
    }

    @Sharable
    public void setCategoryList(ArrayList<Lookup> categoryList) {
        this.categoryList = categoryList;
    }

    public ArrayList<Lookup> getCategoryList() {
        return this.categoryList;
    }
}

