/*
 * Decompiled with CFR 0.152.
 */
package gate.jape.constraint;

import gate.Annotation;
import gate.AnnotationSet;
import gate.jape.Constraint;
import gate.jape.JapeException;
import gate.jape.constraint.AbstractConstraintPredicate;
import gate.jape.constraint.AnnotationAccessor;
import java.util.Collection;
import java.util.Collections;

public abstract class EmbeddedConstraintPredicate
extends AbstractConstraintPredicate {
    private static final long serialVersionUID = 7472456256804424432L;
    protected Constraint valueConstraint;
    protected String annotType;

    public EmbeddedConstraintPredicate() {
    }

    public EmbeddedConstraintPredicate(AnnotationAccessor accessor, Object value) {
        super(accessor, value);
    }

    @Override
    public boolean doMatch(Object annotValue, AnnotationSet context) throws JapeException {
        Annotation annot = (Annotation)annotValue;
        AnnotationSet containedSet = this.doMatch(annot, context);
        Collection<Annotation> filteredSet = this.filterMatches(containedSet);
        return !filteredSet.isEmpty();
    }

    protected abstract AnnotationSet doMatch(Annotation var1, AnnotationSet var2);

    protected Collection<Annotation> filterMatches(AnnotationSet containedSet) {
        if (containedSet == null) {
            return Collections.emptySet();
        }
        if (this.valueConstraint == null || containedSet.isEmpty()) {
            return containedSet;
        }
        return this.valueConstraint.matches((Collection<Annotation>)containedSet, null, containedSet);
    }

    @Override
    public void setValue(Object v) {
        if (v instanceof Constraint) {
            Constraint c = (Constraint)v;
            this.annotType = c.getAnnotType();
            if (!c.getAttributeSeq().isEmpty()) {
                this.valueConstraint = c;
                this.value = c;
            }
        }
        if (this.annotType == null && this.valueConstraint == null) {
            this.value = v;
            this.annotType = String.valueOf(v);
        }
    }

    public String getAnnotType() {
        return this.annotType;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getOperator()).append(" ");
        if (this.annotType != null) {
            str.append(this.annotType);
        }
        if (this.valueConstraint != null) {
            str.append(": ").append(this.valueConstraint);
        }
        return str.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.annotType == null ? 0 : this.annotType.hashCode());
        result = 31 * result + (this.valueConstraint == null ? 0 : this.valueConstraint.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof EmbeddedConstraintPredicate)) {
            return false;
        }
        EmbeddedConstraintPredicate other = (EmbeddedConstraintPredicate)obj;
        if (this.annotType == null ? other.annotType != null : !this.annotType.equals(other.annotType)) {
            return false;
        }
        return !(this.valueConstraint == null ? other.valueConstraint != null : !this.valueConstraint.equals(other.valueConstraint));
    }
}

