/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.orthomatcher;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.creole.ExecutionException;
import gate.creole.orthomatcher.OrthoMatcherRule;
import gate.util.InvalidOffsetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrthoMatcherHelper {
    protected static final Logger log = Logger.getLogger(OrthoMatcherHelper.class);
    private static final boolean[] rulesUsedTable = new boolean[18];

    public static boolean straightCompare(String s1, String s2, boolean matchCase) {
        boolean matched = false;
        matched = !matchCase ? s1.equalsIgnoreCase(s2) : s1.equals(s2);
        return matched;
    }

    public static boolean initialMatch(String s1, String s2) {
        return s1.length() == 1 ^ s2.length() == 1 && s1.charAt(0) == s2.charAt(0);
    }

    public static String getStringForSpan(Long start, Long end, Document d) throws ExecutionException {
        try {
            return d.getContent().getContent(start, end).toString();
        }
        catch (InvalidOffsetException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    public static boolean executeDisjunction(Map<Integer, OrthoMatcherRule> allrules, int[] executeRules, String longName, String shortName, boolean[] mr) {
        boolean result = false;
        for (int i = 0; i < executeRules.length; ++i) {
            boolean current;
            mr[executeRules[i]] = current = allrules.get(executeRules[i]).value(longName, shortName);
            result = result || current;
        }
        return result;
    }

    public static Double round2Places(Double input) {
        return (double)Math.round(input * 100.0) / 100.0;
    }

    public static void usedRule(int rule) {
        OrthoMatcherHelper.rulesUsedTable[rule] = true;
    }

    public static void saveUsedTable() {
        if (rulesUsedTable != null) {
            log.debug((Object)"Saving table of used orthomatcher rules:");
            StringBuilder table = new StringBuilder();
            for (int i = 0; i < rulesUsedTable.length; ++i) {
                table.append("Rule: ").append(i).append(" fired: ").append(rulesUsedTable[i]).append("\r\n");
            }
            log.debug((Object)table);
            log.debug((Object)"End of table of used Orthomatcher rules");
        } else {
            log.debug((Object)"Could not save the table of used orthomatcher rules. This also results when no Orthomatcher rule has returned 'true'.");
        }
    }

    public static int[] convertArrayToInteger(String[] input) {
        int[] result = new int[input.length];
        for (int i = 0; i < input.length; ++i) {
            result[i] = Integer.parseInt(input[i].trim());
        }
        return result;
    }

    public static String SortByStartPosition(String input) {
        int ceil = 100000;
        String[] pairs = input.trim().split(",");
        int[] temp = new int[pairs.length];
        if (pairs.length > 1) {
            int i = 0;
            for (String pair : pairs) {
                int x;
                String[] s = pair.split(":");
                temp[i] = x = Integer.parseInt(s[0].trim()) * ceil + Integer.parseInt(s[1].trim());
                ++i;
            }
            Arrays.sort(temp);
            StringBuilder result = new StringBuilder();
            for (int n : temp) {
                int a = n / ceil;
                int b = n % ceil;
                result.append(a).append(":").append(b).append(", ");
            }
            return result.toString();
        }
        return input;
    }

    protected static void setMatchesPositions(AnnotationSet nameAllAnnots) {
        HashSet<String> fNames = new HashSet<String>();
        fNames.add("matches");
        AnnotationSet allMatchesAnnots = nameAllAnnots.get(null, fNames);
        if (allMatchesAnnots == null || allMatchesAnnots.isEmpty()) {
            return;
        }
        for (Annotation currentMatchAnnot : allMatchesAnnots) {
            String matchValue = currentMatchAnnot.getFeatures().get((Object)"matches").toString();
            matchValue = matchValue.substring(1);
            matchValue = matchValue.substring(0, matchValue.length() - 1);
            String[] annotationsIDs = matchValue.split(",");
            String matchPositionsValue = "";
            String sentinel = ", ";
            int[] integerIDs = OrthoMatcherHelper.convertArrayToInteger(annotationsIDs);
            for (int i = 0; i < integerIDs.length; ++i) {
                int id = integerIDs[i];
                Annotation ann = null;
                Iterator iter = nameAllAnnots.iterator();
                if (currentMatchAnnot.getId() == id) {
                    ann = currentMatchAnnot;
                } else {
                    while (iter.hasNext()) {
                        Annotation a = (Annotation)iter.next();
                        if (a.getId() != id) continue;
                        ann = a;
                        break;
                    }
                }
                if (ann == null) continue;
                matchPositionsValue = matchPositionsValue + ann.getStartNode().getOffset() + ":" + ann.getEndNode().getOffset() + sentinel;
            }
            if ((matchPositionsValue = OrthoMatcherHelper.SortByStartPosition(matchPositionsValue)).endsWith(sentinel)) {
                matchPositionsValue = matchPositionsValue.substring(0, matchPositionsValue.length() - sentinel.length());
            }
            matchPositionsValue = "[" + matchPositionsValue + "]";
            currentMatchAnnot.getFeatures().put((Object)"matches_positions", (Object)matchPositionsValue);
        }
    }

    static {
        for (int i = 0; i < rulesUsedTable.length; ++i) {
            OrthoMatcherHelper.rulesUsedTable[i] = false;
        }
    }
}

