/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.gazetteer;

import gate.creole.gazetteer.DefaultGazetteer;
import gate.creole.gazetteer.Lookup;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class FSMState
implements Serializable {
    private static final long serialVersionUID = -3339572027660481558L;
    protected DefaultGazetteer.CharMap transitionFunction = new DefaultGazetteer.CharMap();
    protected Set<Lookup> lookupSet;
    protected int myIndex = index.getAndIncrement();
    private static final AtomicInteger index = new AtomicInteger(0);

    public FSMState(DefaultGazetteer owner) {
        owner.fsmStates.add(this);
    }

    public void put(char chr, FSMState state) {
        this.transitionFunction.put(chr, state);
    }

    public FSMState next(char chr) {
        return (FSMState)this.transitionFunction.get(chr);
    }

    public String getEdgesGML() {
        String res = "";
        for (int i = 0; i < this.transitionFunction.itemsKeys.length; ++i) {
            char currentChar = this.transitionFunction.itemsKeys[i];
            FSMState nextState = this.next(currentChar);
            res = res + "edge [ source " + this.myIndex + " target " + nextState.getIndex() + " label \"'" + currentChar + "'\" ]\n";
        }
        return res;
    }

    public boolean isFinal() {
        if (this.lookupSet == null) {
            return false;
        }
        return !this.lookupSet.isEmpty();
    }

    public Set<Lookup> getLookupSet() {
        return this.lookupSet;
    }

    public void addLookup(Lookup lookup) {
        if (this.lookupSet == null) {
            this.lookupSet = new HashSet<Lookup>(4);
        }
        this.lookupSet.add(lookup);
    }

    public void removeLookup(Lookup lookup) {
        this.lookupSet.remove(lookup);
    }

    public int getIndex() {
        return this.myIndex;
    }
}

