/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.gazetteer;

import gate.Factory;
import gate.FeatureMap;
import gate.Resource;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.gazetteer.AbstractOntoGazetteer;
import gate.creole.gazetteer.Gazetteer;
import gate.creole.gazetteer.InvalidFormatException;
import gate.creole.gazetteer.Lookup;
import gate.creole.gazetteer.MappingDefinition;
import java.util.Set;

public class OntoGazetteerImpl
extends AbstractOntoGazetteer {
    private static final long serialVersionUID = -1899789184476649606L;

    @Override
    public Set<Lookup> lookup(String singleItem) {
        return this.gaz.lookup(singleItem);
    }

    public Resource init() throws ResourceInstantiationException {
        try {
            this.checkParameters();
            FeatureMap params = Factory.newFeatureMap();
            this.mappingDefinition = new MappingDefinition();
            this.mappingDefinition.setURL(this.mappingURL);
            this.mappingDefinition.load();
            params.put((Object)"caseSensitive", (Object)this.caseSensitive);
            params.put((Object)"listsURL", (Object)this.listsURL);
            params.put((Object)"encoding", (Object)this.encoding);
            params.put((Object)"mappingDefinition", (Object)this.mappingDefinition);
            this.gaz = (Gazetteer)Factory.createResource((String)this.gazetteerName, (FeatureMap)params);
        }
        catch (InvalidFormatException e) {
            throw new ResourceInstantiationException((Exception)((Object)e));
        }
        return this;
    }

    public void execute() throws ExecutionException {
        if (null == this.gaz) {
            throw new ExecutionException("gazetteer not initialized (null).");
        }
        this.gaz.setDocument(this.document);
        this.gaz.setAnnotationSetName(this.annotationSetName);
        this.gaz.setEncoding(this.encoding);
        this.gaz.setCorpus(this.corpus);
        this.gaz.execute();
    }

    private void checkParameters() throws ResourceInstantiationException {
        boolean set = null != this.gazetteerName;
        set &= null != this.listsURL;
        if (!(set &= null != this.mappingURL)) {
            throw new ResourceInstantiationException("some parameters are not set (e.g.gazetteerName,listURL,mappingDefinition, document");
        }
    }

    @Override
    public boolean remove(String singleItem) {
        return this.gaz.remove(singleItem);
    }

    @Override
    public boolean add(String singleItem, Lookup lookup) {
        return this.gaz.add(singleItem, lookup);
    }
}

