/*
 * Decompiled with CFR 0.152.
 */
package gate.util.reporting;

import gate.util.reporting.BenchmarkReportable;
import gate.util.reporting.FileWatcher;
import gate.util.reporting.ValueComparator;
import gate.util.reporting.exceptions.BenchmarkReportExecutionException;
import gate.util.reporting.exceptions.BenchmarkReportInputFileFormatException;
import gnu.getopt.Getopt;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PRTimeReporter
implements BenchmarkReportable {
    public static final String MEDIA_TEXT = "text";
    public static final String MEDIA_HTML = "html";
    public static final String SORT_EXEC_ORDER = "exec_order";
    public static final String SORT_TIME_TAKEN = "time_taken";
    private Hashtable<String, String> globalTotal = new Hashtable();
    private ArrayList<String> printLines = new ArrayList();
    private static final String NL = System.getProperty("line.separator");
    private String htmlElementTree = "<td rowspan=\"112\" width=\"550\">" + NL + "<div id=\"treemenu\" style=\"margin: 0;\">" + NL + "<ul id=\"tree\" style=\"margin-left: 0;\">" + NL;
    private String htmlTimeTree = "<td rowspan=\"112\" width=\"100\">" + NL + "<div style=\"margin-top: 0;\"><div>" + NL;
    private String htmlTimeInPercentTree = "<td rowspan=\"112\" width=\"100\">" + NL + "<div style=\"margin-top: 0;\"><div>" + NL;
    private int level = 1;
    private double globalValue = 0.0;
    private static final int STATUS_NORMAL = 0;
    private static final int STATUS_ERROR = 1;
    public int validEntries = 0;
    private static final int FILE_CHUNK_SIZE = 2000;
    public HashSet<String> pipelineNames = new HashSet();
    private File benchmarkFile = new File("benchmark.txt");
    private boolean suppressZeroTimeEntries = true;
    private String printMedia = "html";
    private String sortOrder = "exec_order";
    private File reportFile;
    private String logicalStart = null;

    public PRTimeReporter() {
    }

    PRTimeReporter(String[] args) {
        this.parseArguments(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object store(File inputFile) throws BenchmarkReportInputFileFormatException {
        LinkedHashMap<String, Object> globalStore = new LinkedHashMap<String, Object>();
        long fromPos = 0L;
        RandomAccessFile in = null;
        try {
            String logEntry;
            if (this.getLogicalStart() != null) {
                fromPos = this.tail(inputFile, 2000);
            }
            in = new RandomAccessFile(inputFile, "r");
            if (this.getLogicalStart() != null) {
                in.seek(fromPos);
            }
            ArrayList<String> startTokens = new ArrayList<String>();
            String docName = null;
            Pattern pattern = Pattern.compile("(\\d+) (\\d+) (.*) (.*) \\{(.*)\\}");
            while ((logEntry = in.readLine()) != null) {
                Matcher matcher = pattern.matcher(logEntry);
                if (logEntry.matches(".*documentLoaded.*")) continue;
                if (logEntry.matches(".*START.*")) {
                    String startToken;
                    String[] splittedStartEntry = logEntry.split("\\s");
                    String string = startToken = splittedStartEntry.length > 2 ? splittedStartEntry[2] : null;
                    if (startToken == null) {
                        throw new BenchmarkReportInputFileFormatException(this.getBenchmarkFile().getAbsolutePath() + " is invalid.");
                    }
                    startTokens.add(startToken);
                    if (startToken.endsWith("Start")) continue;
                    this.organizeEntries(globalStore, startToken.split("\\."), "0");
                }
                if (matcher == null || !matcher.matches() || !this.validateLogEntry(matcher.group(3), startTokens)) continue;
                String[] splittedBIDs = matcher.group(3).split("\\.");
                if (splittedBIDs.length > 1) {
                    docName = splittedBIDs[1];
                    this.pipelineNames.add(splittedBIDs[0]);
                }
                this.organizeEntries(globalStore, matcher.group(3).replaceFirst(Pattern.quote(docName) + ".", "").split("\\."), matcher.group(2));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            globalStore = null;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                globalStore = null;
            }
        }
        if (this.validEntries == 0) {
            if (this.logicalStart != null) {
                throw new BenchmarkReportInputFileFormatException("No valid log entries present in " + this.getBenchmarkFile().getAbsolutePath() + " does not contain a marker named " + this.logicalStart + ".");
            }
            throw new BenchmarkReportInputFileFormatException("No valid log entries present in " + this.getBenchmarkFile().getAbsolutePath());
        }
        return globalStore;
    }

    private void organizeEntries(LinkedHashMap<String, Object> store, String[] tokens, String bTime) {
        if (tokens.length > 0 && store.containsKey(tokens[0])) {
            if (tokens.length > 1) {
                String[] tempArr = new String[tokens.length - 1];
                System.arraycopy(tokens, 1, tempArr, 0, tokens.length - 1);
                if (store.get(tokens[0]) instanceof LinkedHashMap) {
                    this.organizeEntries((LinkedHashMap)store.get(tokens[0]), tempArr, bTime);
                } else if (store.get(tokens[0]) != null) {
                    store.put(tokens[0], new LinkedHashMap());
                } else {
                    store.put(tokens[0], bTime);
                }
            } else if (store.get(tokens[0]) != null) {
                if (!(store.get(tokens[0]) instanceof LinkedHashMap)) {
                    int total = Integer.parseInt((String)store.get(tokens[0])) + Integer.parseInt(bTime);
                    store.put(tokens[0], Integer.toString(total));
                } else {
                    int total = Integer.parseInt(bTime);
                    if (((LinkedHashMap)store.get(tokens[0])).get("systotal") != null) {
                        total += Integer.parseInt((String)((LinkedHashMap)store.get(tokens[0])).get("systotal"));
                    }
                    ((LinkedHashMap)store.get(tokens[0])).put("systotal", Integer.toString(total));
                }
            }
        } else if (tokens.length - 1 == 0) {
            store.put(tokens[0], bTime);
        } else {
            store.put(tokens[0], new LinkedHashMap());
            String[] tempArr = new String[tokens.length - 1];
            System.arraycopy(tokens, 1, tempArr, 0, tokens.length - 1);
            this.organizeEntries((LinkedHashMap)store.get(tokens[0]), tempArr, bTime);
        }
    }

    private LinkedHashMap<String, Object> sortReport(LinkedHashMap<String, Object> gStore) {
        Iterator<String> i = gStore.keySet().iterator();
        LinkedHashMap<String, Object> sortedReport = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, LinkedHashMap<String, Object>> mapperReport = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
        LinkedHashMap<String, String> unsortedReport = new LinkedHashMap<String, String>();
        while (i.hasNext()) {
            String key = i.next();
            if (gStore.get(key) instanceof LinkedHashMap) {
                int systotal = 0;
                if (((LinkedHashMap)gStore.get(key)).get("systotal") != null) {
                    systotal = Integer.parseInt((String)((LinkedHashMap)gStore.get(key)).get("systotal"));
                }
                if (systotal >= 0) {
                    unsortedReport.put(key, Integer.toString(systotal));
                }
                mapperReport.put(key, this.sortReport((LinkedHashMap)gStore.get(key)));
                continue;
            }
            if (key.equals("total") || key.equals("systotal") || Integer.parseInt((String)gStore.get(key)) < 0) continue;
            unsortedReport.put(key, new Integer((String)gStore.get(key)).toString());
        }
        LinkedHashMap<String, String> tempOutLHM = this.sortHashMapByValues(unsortedReport);
        for (String tempKey : tempOutLHM.keySet()) {
            sortedReport.put(tempKey, tempOutLHM.get(tempKey));
            if (!mapperReport.containsKey(tempKey)) continue;
            sortedReport.put(tempKey, mapperReport.get(tempKey));
        }
        sortedReport.put("total", gStore.get("total"));
        if (gStore.get("systotal") != null) {
            sortedReport.put("systotal", gStore.get("systotal"));
        }
        return sortedReport;
    }

    private LinkedHashMap<String, String> sortHashMapByValues(LinkedHashMap<String, String> passedMap) {
        ArrayList<String> mapKeys = new ArrayList<String>(passedMap.keySet());
        ArrayList<String> mapValues = new ArrayList<String>(passedMap.values());
        Collections.sort(mapValues, new ValueComparator());
        Collections.sort(mapKeys);
        Collections.reverse(mapValues);
        LinkedHashMap<String, String> sortedMap = new LinkedHashMap<String, String>();
        block0: for (String val : mapValues) {
            for (String key : mapKeys) {
                String comp2;
                String comp1 = passedMap.get(key);
                if (!comp1.equals(comp2 = val)) continue;
                passedMap.remove(key);
                mapKeys.remove(key);
                sortedMap.put(key, val);
                continue block0;
            }
        }
        return sortedMap;
    }

    @Override
    public Object calculate(Object reportContainer) {
        LinkedHashMap globalStore = (LinkedHashMap)reportContainer;
        Iterator iter = globalStore.keySet().iterator();
        int total = 0;
        while (iter.hasNext()) {
            String key = (String)iter.next();
            total = this.getTotal((LinkedHashMap)globalStore.get(key));
            this.globalTotal.put(key, Integer.toString(total));
        }
        return globalStore;
    }

    private int getTotal(LinkedHashMap<String, Object> reportContainer) {
        int total = 0;
        int diff = 0;
        int systotal = 0;
        int subLevelTotal = 0;
        for (String key : reportContainer.keySet()) {
            if (reportContainer.get(key) instanceof LinkedHashMap) {
                subLevelTotal = this.getTotal((LinkedHashMap)reportContainer.get(key));
                total += subLevelTotal;
                continue;
            }
            if (key.equals("systotal")) continue;
            total += Integer.parseInt((String)reportContainer.get(key));
        }
        if (reportContainer.get("systotal") != null) {
            systotal = Integer.parseInt((String)reportContainer.get("systotal"));
        }
        diff = systotal - total;
        reportContainer.put("total", Integer.toString(total));
        reportContainer.put("All others", Integer.toString(diff));
        return total += diff;
    }

    @Override
    public void printReport(Object reportSource, File outputFile) {
        if (this.printMedia.equalsIgnoreCase(MEDIA_TEXT)) {
            this.printToText(reportSource, outputFile, this.suppressZeroTimeEntries);
        } else if (this.printMedia.equalsIgnoreCase(MEDIA_HTML)) {
            this.printToHTML((LinkedHashMap)reportSource, outputFile, this.suppressZeroTimeEntries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printToText(Object reportContainer, File outputFile, boolean suppressZeroTimeEntries) {
        LinkedHashMap globalStore = (LinkedHashMap)reportContainer;
        this.prettyPrint(globalStore, "\t", suppressZeroTimeEntries);
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(outputFile));
            for (String line : this.printLines) {
                out.write(line);
                out.newLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void prettyPrint(LinkedHashMap<String, Object> gStore, String separator, boolean suppressZeroTimeEntries) {
        for (String key : gStore.keySet()) {
            if (this.globalTotal.containsKey(key)) {
                this.globalValue = Integer.parseInt(this.globalTotal.get(key));
            }
            if (gStore.get(key) instanceof LinkedHashMap) {
                int systotal = 0;
                if (((LinkedHashMap)gStore.get(key)).containsKey("systotal")) {
                    systotal = Integer.parseInt((String)((LinkedHashMap)gStore.get(key)).get("systotal"));
                }
                if (suppressZeroTimeEntries) {
                    if (systotal > 0) {
                        this.printLines.add(separator + key + " (" + (double)systotal / 1000.0 + ") [" + (double)Math.round((double)systotal / this.globalValue * 100.0 * 10.0) / 10.0 + "%]");
                    }
                } else {
                    this.printLines.add(separator + key + " (" + (double)systotal / 1000.0 + ") [" + (double)Math.round((double)systotal / this.globalValue * 100.0 * 10.0) / 10.0 + "%]");
                }
                this.prettyPrint((LinkedHashMap)gStore.get(key), separator + "\t", suppressZeroTimeEntries);
                continue;
            }
            if (key.equals("total") || key.equals("systotal")) continue;
            if (suppressZeroTimeEntries) {
                if (Integer.parseInt((String)gStore.get(key)) == 0) continue;
                this.printLines.add(separator + key + " (" + (double)Integer.parseInt((String)gStore.get(key)) / 1000.0 + ") [" + (double)Math.round((double)Integer.parseInt((String)gStore.get(key)) / this.globalValue * 100.0 * 10.0) / 10.0 + "%]");
                continue;
            }
            this.printLines.add(separator + key + " (" + (double)Integer.parseInt((String)gStore.get(key)) / 1000.0 + ") [" + (double)Math.round((double)Integer.parseInt((String)gStore.get(key)) / this.globalValue * 100.0 * 10.0) / 10.0 + "%]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printToHTML(LinkedHashMap<String, Object> gStore, File outputFile, boolean suppressZeroTimeEntries) {
        String htmlPipelineNames = "<ul>";
        for (String pipeline : this.pipelineNames) {
            htmlPipelineNames = htmlPipelineNames + "<li><b>" + pipeline + "</b></li>" + NL;
        }
        htmlPipelineNames = htmlPipelineNames + "</ul>" + NL;
        String htmlReport = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"" + NL + "\"http://www.w3.org/TR/html4/loose.dtd\">" + NL + "<html><head><title>Benchmarking Report</title>" + NL + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">" + NL + "<style type=\"text/css\">" + NL + "#treemenu li { list-style: none; }" + NL + "#treemenu li A { font-family: monospace; text-decoration: none; }" + NL + "</style>" + NL + "<script type=\"text/javascript\" language=\"javascript\">" + NL + "function expandCollapseTree(obj){" + NL + "  var li = obj.parentNode;" + NL + "  var uls = li.getElementsByTagName('ul');" + NL + "  var id = li.id;" + NL + "  var ul = uls[0];" + NL + "  var objTimeBranch = document.getElementById(id + '.1');" + NL + "  var divs = objTimeBranch.getElementsByTagName('div');" + NL + "  var div = divs[0];" + NL + "  var objperBranch = document.getElementById(id + '.2');" + NL + "  var perdivs = objperBranch.getElementsByTagName('div');" + NL + "  var perdiv = perdivs[0];" + NL + NL + "  if (ul.style.display == 'none' || ul.style.display == '') {" + NL + "    ul.style.display = 'block';" + NL + "    obj.innerHTML = '[&mdash;]';" + NL + "  } else {" + NL + "    ul.style.display = 'none';" + NL + "    obj.innerHTML = '[+]';" + NL + "  }" + NL + "  if (div.style.display == 'block') {" + NL + "    div.style.display = 'none';" + NL + "  } else {" + NL + "    div.style.display = 'block';" + NL + "  }" + NL + "  if (perdiv.style.display == 'block') {" + NL + "    perdiv.style.display = 'none';" + NL + "  } else {" + NL + "    perdiv.style.display = 'block';" + NL + "  }" + NL + "}" + NL + NL + "</script>" + NL + "</head>" + NL + "<body style=\"font-family:Verdana; color:navy;\">" + NL + "<table><tr bgcolor=\"#eeeeff\">" + NL + "<td><b>Processing elements of following pipelines</b>" + NL + htmlPipelineNames + NL + "</td>" + NL + "<td><b>Time in seconds</b></td>" + NL + "<td><b>% time taken</b></td></tr><tr>";
        this.generateCollapsibleHTMLTree(gStore, suppressZeroTimeEntries);
        this.htmlElementTree = this.htmlElementTree + "</ul></div></td>" + NL;
        this.htmlTimeTree = this.htmlTimeTree + "</div></div></td>" + NL;
        this.htmlTimeInPercentTree = this.htmlTimeInPercentTree + "</div></div></td>" + NL;
        htmlReport = htmlReport + this.htmlElementTree + this.htmlTimeTree + this.htmlTimeInPercentTree + "</tr></table>" + NL + "</body></html>";
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(outputFile));
            out.write(htmlReport);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void generateCollapsibleHTMLTree(LinkedHashMap<String, Object> gStore, boolean suppressZeroTimeEntries) {
        for (String key : gStore.keySet()) {
            if (this.globalTotal.containsKey(key)) {
                this.globalValue = Integer.parseInt(this.globalTotal.get(key));
            }
            if (gStore.get(key) instanceof LinkedHashMap) {
                int systotal = 0;
                if (((LinkedHashMap)gStore.get(key)).containsKey("systotal")) {
                    systotal = Integer.parseInt((String)((LinkedHashMap)gStore.get(key)).get("systotal"));
                }
                if (suppressZeroTimeEntries) {
                    if (systotal <= 0) continue;
                    this.htmlElementTree = this.htmlElementTree + "<li id=\"level" + this.level + "\"><a href=\"#\"  onclick=\"expandCollapseTree(this)\">[+]</a>&nbsp;" + key + "<ul style=\"display:none\">" + NL;
                    this.htmlTimeTree = this.htmlTimeTree + "<div id=level" + this.level + ".1>" + NL + (double)systotal / 1000.0 + NL + "<div style=\"display:none\">" + NL;
                    this.htmlTimeInPercentTree = this.htmlTimeInPercentTree + "<div id=level" + this.level + ".2>" + NL + (double)Math.round((double)systotal / this.globalValue * 100.0 * 10.0) / 10.0 + "<div style=\"display:none\">" + NL;
                    ++this.level;
                    this.generateCollapsibleHTMLTree((LinkedHashMap)gStore.get(key), suppressZeroTimeEntries);
                    this.htmlElementTree = this.htmlElementTree + "</ul></li>" + NL;
                    this.htmlTimeTree = this.htmlTimeTree + "</div></div>" + NL;
                    this.htmlTimeInPercentTree = this.htmlTimeInPercentTree + "</div></div>" + NL;
                    continue;
                }
                this.htmlElementTree = this.htmlElementTree + "<li id=level" + this.level + "><a href=\"#\" onclick=\"expandCollapseTree(this)\">[+]</a>&nbsp;" + key + "<ul style=\"display:none\">" + NL;
                this.htmlTimeTree = this.htmlTimeTree + "<div id=level" + this.level + ".1>" + NL + (double)systotal / 1000.0 + "<div style=\"display:none\">" + NL;
                this.htmlTimeInPercentTree = this.htmlTimeInPercentTree + "<div id=level" + this.level + ".2>" + NL + (double)Math.round((double)systotal / this.globalValue * 100.0 * 10.0) / 10.0 + "<div style=\"display:none\">" + NL;
                ++this.level;
                this.generateCollapsibleHTMLTree((LinkedHashMap)gStore.get(key), suppressZeroTimeEntries);
                this.htmlElementTree = this.htmlElementTree + "</ul></li>" + NL;
                this.htmlTimeTree = this.htmlTimeTree + "</div></div>" + NL;
                this.htmlTimeInPercentTree = this.htmlTimeInPercentTree + "</div></div>" + NL;
                continue;
            }
            if (key.equals("total") || key.equals("systotal")) continue;
            if (suppressZeroTimeEntries) {
                if (Integer.parseInt((String)gStore.get(key)) == 0) continue;
                this.htmlElementTree = this.htmlElementTree + "<li>&nbsp;&nbsp;&nbsp;" + key + "</li>" + NL;
                this.htmlTimeTree = this.htmlTimeTree + "<div>" + NL + (double)Integer.parseInt((String)gStore.get(key)) / 1000.0 + "</div>" + NL;
                this.htmlTimeInPercentTree = this.htmlTimeInPercentTree + "<div>" + NL + (double)Math.round((double)Integer.parseInt((String)gStore.get(key)) / this.globalValue * 100.0 * 10.0) / 10.0 + "</div>" + NL;
                continue;
            }
            this.htmlElementTree = this.htmlElementTree + "<li>&nbsp;&nbsp;&nbsp;" + key + "</li>" + NL;
            this.htmlTimeTree = this.htmlTimeTree + "<div>" + NL + (double)Integer.parseInt((String)gStore.get(key)) / 1000.0 + "</div>" + NL;
            this.htmlTimeInPercentTree = this.htmlTimeInPercentTree + "<div>" + NL + (double)Math.round((double)Integer.parseInt((String)gStore.get(key)) / this.globalValue * 100.0 * 10.0) / 10.0 + "</div>" + NL;
        }
    }

    private boolean parseLinesFromLast(byte[] bytearray, Vector<String> lastNlines) {
        String lastNChars = new String(bytearray);
        StringBuffer sb = new StringBuffer(lastNChars);
        lastNChars = sb.reverse().toString();
        StringTokenizer tokens = new StringTokenizer(lastNChars, NL);
        while (tokens.hasMoreTokens()) {
            StringBuffer sbLine = new StringBuffer(tokens.nextToken());
            lastNlines.add(sbLine.reverse().toString());
            if (!lastNlines.get(lastNlines.size() - 1).trim().endsWith(this.getLogicalStart())) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long tail(File fileToBeRead, int chunkSize) throws BenchmarkReportInputFileFormatException {
        try (RandomAccessFile raf = new RandomAccessFile(fileToBeRead, "r");){
            long fromPos;
            Vector<String> lastNlines = new Vector<String>();
            int delta = 0;
            long curPos = raf.length() - 1L;
            while (true) {
                byte[] bytearray;
                if ((fromPos = curPos - (long)chunkSize) <= 0L) {
                    raf.seek(0L);
                    bytearray = new byte[(int)curPos];
                    raf.readFully(bytearray);
                    if (!this.parseLinesFromLast(bytearray, lastNlines) || fromPos >= 0L) break;
                    fromPos = 0L;
                    break;
                }
                raf.seek(fromPos);
                bytearray = new byte[chunkSize];
                raf.readFully(bytearray);
                if (this.parseLinesFromLast(bytearray, lastNlines)) break;
                delta = lastNlines.get(lastNlines.size() - 1).length();
                lastNlines.remove(lastNlines.size() - 1);
                curPos = fromPos + (long)delta;
            }
            if (fromPos < 0L) {
                throw new BenchmarkReportInputFileFormatException(this.getBenchmarkFile().getAbsolutePath() + " does not contain a marker named " + this.getLogicalStart() + " indicating logical start of a run.");
            }
            long l = fromPos;
            return l;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    private boolean validateLogEntry(String benchmarkIDChain, ArrayList<String> startTokens) {
        String startTokenRegExp = "(";
        for (int i = 0; i < startTokens.size(); ++i) {
            if (benchmarkIDChain.split("\\.").length == 1 && benchmarkIDChain.equals(startTokens.get(i))) {
                startTokens.remove(i);
                ++this.validEntries;
                return true;
            }
            startTokenRegExp = startTokenRegExp + startTokens.get(i) + "|";
        }
        if (startTokenRegExp.length() > 1) {
            startTokenRegExp = startTokenRegExp.substring(0, startTokenRegExp.length() - 1);
        }
        if (benchmarkIDChain.matches((startTokenRegExp = startTokenRegExp + ")") + "\\.doc_.*?\\.pr_.*")) {
            ++this.validEntries;
            return true;
        }
        return false;
    }

    @Override
    public void parseArguments(String[] args) {
        int choice;
        Getopt g = new Getopt("gate.util.reporting.PRTimeReporter", args, "i:m:z:s:o:l:h");
        String argSuppressZeroTimeEntries = null;
        block9: while ((choice = g.getopt()) != -1) {
            switch (choice) {
                case 105: {
                    String argInPath = g.getOptarg();
                    if (argInPath == null) continue block9;
                    this.setBenchmarkFile(new File(argInPath));
                    continue block9;
                }
                case 109: {
                    String argPrintMedia = g.getOptarg();
                    if (argPrintMedia != null) {
                        this.setPrintMedia(argPrintMedia);
                        continue block9;
                    }
                    this.setPrintMedia(this.printMedia);
                    continue block9;
                }
                case 122: {
                    argSuppressZeroTimeEntries = g.getOptarg();
                    if (argSuppressZeroTimeEntries != null) continue block9;
                    this.setSuppressZeroTimeEntries(this.suppressZeroTimeEntries);
                    continue block9;
                }
                case 115: {
                    String argSortOrder = g.getOptarg();
                    if (argSortOrder != null) {
                        this.setSortOrder(argSortOrder);
                        continue block9;
                    }
                    this.setSortOrder(this.sortOrder);
                    continue block9;
                }
                case 111: {
                    String argOutPath = g.getOptarg();
                    if (argOutPath == null) continue block9;
                    this.setReportFile(new File(argOutPath));
                    continue block9;
                }
                case 108: {
                    String argLogicalStart = g.getOptarg();
                    if (argLogicalStart == null) continue block9;
                    this.setLogicalStart(argLogicalStart);
                    continue block9;
                }
                case 63: 
                case 104: {
                    PRTimeReporter.usage();
                    System.exit(0);
                    continue block9;
                }
            }
            PRTimeReporter.usage();
            System.exit(1);
        }
        if (argSuppressZeroTimeEntries != null) {
            if (argSuppressZeroTimeEntries.trim().equalsIgnoreCase("true")) {
                this.setSuppressZeroTimeEntries(true);
            } else if (argSuppressZeroTimeEntries.trim().equalsIgnoreCase("false")) {
                this.setSuppressZeroTimeEntries(false);
            } else {
                System.err.println("Suppress Zero Time Entries: parameter value" + NL + " passed is invalid. Please provide true or false as value.");
                PRTimeReporter.usage();
                System.exit(1);
            }
        }
    }

    public static void usage() {
        System.out.println("Usage: java gate.util.reporting.PRTimeReporter [Options]" + NL + "\t Options:" + NL + "\t -i input file path (default: benchmark.txt in the execution directory)" + NL + "\t -m print media - html/text (default: html)" + NL + "\t -z suppressZeroTimeEntries - true/false (default: true)" + NL + "\t -s sorting order - exec_order/time_taken (default: exec_order)" + NL + "\t -o output file path (default: report.html/txt in the system temporary directory)" + NL + "\t -l logical start (not set by default)" + NL + "\t -h show help" + NL);
    }

    public static void main(String[] args) throws BenchmarkReportInputFileFormatException {
        PRTimeReporter reportOne = new PRTimeReporter(args);
        reportOne.generateReport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateReport() throws BenchmarkReportInputFileFormatException {
        Timer timer = null;
        try {
            FileWatcher task = new FileWatcher(this.getBenchmarkFile()){

                @Override
                protected void onChange(File file) throws BenchmarkReportExecutionException {
                    throw new BenchmarkReportExecutionException(PRTimeReporter.this.getBenchmarkFile() + " file has been modified while generating the report.");
                }
            };
            timer = new Timer();
            timer.schedule((TimerTask)task, new Date(), 1000L);
            Object report1Container1 = this.store(this.getBenchmarkFile());
            LinkedHashMap<String, Object> report1Container2 = this.calculate(report1Container1);
            if (this.getSortOrder().equalsIgnoreCase(SORT_TIME_TAKEN)) {
                report1Container2 = this.sortReport(report1Container2);
            }
            if (this.reportFile == null) {
                this.reportFile = new File(System.getProperty("java.io.tmpdir"), "report." + (this.printMedia.equals(MEDIA_HTML) ? MEDIA_HTML : "txt"));
            }
            this.printReport(report1Container2, this.reportFile);
        }
        finally {
            if (timer != null) {
                timer.cancel();
            }
        }
    }

    @Override
    public void executeReport() throws BenchmarkReportInputFileFormatException {
        this.generateReport();
    }

    public boolean isSuppressZeroTimeEntries() {
        return this.suppressZeroTimeEntries;
    }

    public void setSuppressZeroTimeEntries(boolean suppressZeroTimeEntries) {
        this.suppressZeroTimeEntries = suppressZeroTimeEntries;
    }

    public String getPrintMedia() {
        return this.printMedia;
    }

    public void setPrintMedia(String printMedia) {
        if (!printMedia.equals(MEDIA_HTML) && !printMedia.equals(MEDIA_TEXT)) {
            throw new IllegalArgumentException("Illegal argument: " + printMedia);
        }
        this.printMedia = printMedia.trim();
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        if (!sortOrder.equals(SORT_EXEC_ORDER) && !sortOrder.equals(SORT_TIME_TAKEN)) {
            throw new IllegalArgumentException("Illegal argument: " + this.printMedia);
        }
        this.sortOrder = sortOrder.trim();
    }

    public String getLogicalStart() {
        return this.logicalStart;
    }

    public void setLogicalStart(String logicalStart) {
        this.logicalStart = logicalStart.trim();
    }

    public File getBenchmarkFile() {
        return this.benchmarkFile;
    }

    public void setBenchmarkFile(File benchmarkFile) {
        this.benchmarkFile = benchmarkFile;
    }

    public File getReportFile() {
        return this.reportFile;
    }

    public void setReportFile(File reportFile) {
        this.reportFile = reportFile;
    }
}

