/*
 * Decompiled with CFR 0.152.
 */
package gate.util.persistence;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.security.AnyTypePermission;
import java.util.regex.Pattern;

public interface XStreamSecurity {
    public void configure(XStream var1);

    public static final class MinimalBlacklist
    implements XStreamSecurity {
        private static final Pattern LAZY_ITERATORS = Pattern.compile(".*\\$LazyIterator");
        private static final Pattern JAVAX_CRYPTO = Pattern.compile("javax\\.crypto\\..*");
        private static final Pattern JAXWS_FILE_STREAM = Pattern.compile(".*\\.ReadAllStream\\$FileStream");

        @Override
        public void configure(XStream xstream) {
            xstream.addPermission(AnyTypePermission.ANY);
            xstream.denyTypes(new String[]{"java.beans.EventHandler", "java.lang.ProcessBuilder", "javax.imageio.ImageIO$ContainsFilter", "jdk.nashorn.internal.objects.NativeString"});
            xstream.denyTypesByRegExp(new Pattern[]{LAZY_ITERATORS, JAVAX_CRYPTO, JAXWS_FILE_STREAM});
            xstream.allowTypeHierarchy(Exception.class);
        }
    }
}

