/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.util.GateRuntimeException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ProcessManager {
    private static final boolean DEBUG = false;
    private StreamGobbler stdout = new StreamGobbler();
    private StreamGobbler stderr;
    private Process proc;

    public ProcessManager() {
        Thread t = new Thread(this.stdout);
        t.setDaemon(true);
        t.start();
        this.stderr = new StreamGobbler();
        t = new Thread(this.stderr);
        t.setDaemon(true);
        t.start();
    }

    public synchronized boolean isProcessRunning() {
        if (this.proc == null) {
            return false;
        }
        try {
            this.proc.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    public synchronized void destroyProcess() throws IOException {
        if (this.isProcessRunning()) {
            this.proc.destroy();
        }
        while (!this.stderr.isDone() || !this.stdout.isDone()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.proc = null;
        this.stdout.reset();
        this.stderr.reset();
        Exception ex = null;
        if (this.stdout.hasException()) {
            ex = this.stdout.getException();
            this.stderr.getException();
        } else if (this.stderr.hasException()) {
            ex = this.stderr.getException();
        }
        if (ex != null) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new GateRuntimeException(ex);
        }
    }

    public synchronized OutputStream startProcess(String[] argv, File dir, OutputStream out, OutputStream err) throws IOException {
        if (this.isProcessRunning()) {
            throw new IOException("The previous process is still running");
        }
        this.proc = Runtime.getRuntime().exec(argv, null, dir);
        this.stdout.setInputStream(this.proc.getInputStream());
        this.stdout.setOutputStream(out);
        this.stderr.setInputStream(this.proc.getErrorStream());
        this.stderr.setOutputStream(err);
        this.notifyAll();
        return this.proc.getOutputStream();
    }

    public synchronized int runProcess(String[] argv, boolean dumpOutput) throws IOException {
        return this.runProcess(argv, null, dumpOutput ? System.out : null, dumpOutput ? System.err : null);
    }

    public synchronized int runProcess(String[] argv, OutputStream out, OutputStream err) throws IOException {
        return this.runProcess(argv, null, out, err);
    }

    public synchronized int runProcess(String[] argv, File dir, OutputStream out, OutputStream err) throws IOException {
        if (this.isProcessRunning()) {
            throw new IOException("The previous process is still running");
        }
        this.proc = Runtime.getRuntime().exec(argv, null, dir);
        this.stdout.setInputStream(this.proc.getInputStream());
        this.stdout.setOutputStream(out);
        this.stderr.setInputStream(this.proc.getErrorStream());
        this.stderr.setOutputStream(err);
        this.notifyAll();
        while (!this.stderr.isDone() || !this.stdout.isDone()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        Integer returnCode = null;
        while (returnCode == null) {
            try {
                returnCode = new Integer(this.proc.waitFor());
            }
            catch (InterruptedException interruptedException) {}
        }
        this.proc = null;
        this.stdout.reset();
        this.stderr.reset();
        Exception ex = null;
        if (this.stdout.hasException()) {
            ex = this.stdout.getException();
            this.stderr.getException();
        } else if (this.stderr.hasException()) {
            ex = this.stderr.getException();
        }
        if (ex != null) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new GateRuntimeException(ex);
        }
        return returnCode;
    }

    private class StreamGobbler
    implements Runnable {
        private InputStream inputStream = null;
        private OutputStream outputStream = null;
        private byte[] buf = new byte[4096];
        private boolean done = false;
        private Exception exception = null;

        private StreamGobbler() {
        }

        void setInputStream(InputStream is) {
            this.inputStream = is;
        }

        void setOutputStream(OutputStream os) {
            this.outputStream = os;
        }

        boolean hasException() {
            return this.exception != null;
        }

        Exception getException() {
            Exception ex = this.exception;
            this.exception = null;
            return ex;
        }

        boolean isDone() {
            return this.done;
        }

        void reset() {
            this.done = false;
            this.exception = null;
            this.inputStream = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ProcessManager processManager = ProcessManager.this;
            synchronized (processManager) {
                while (this.inputStream == null) {
                    try {
                        ProcessManager.this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            while (true) {
                BufferedInputStream bis = new BufferedInputStream(this.inputStream);
                int bytesRead = -1;
                try {
                    while ((bytesRead = bis.read(this.buf)) != -1) {
                        if (this.outputStream == null) continue;
                        this.outputStream.write(this.buf, 0, bytesRead);
                    }
                }
                catch (Exception ex) {
                    this.exception = ex;
                }
                try {
                    bis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.done = true;
                this.inputStream = null;
                this.outputStream = null;
                ProcessManager processManager2 = ProcessManager.this;
                synchronized (processManager2) {
                    ProcessManager.this.notifyAll();
                    while (this.inputStream == null) {
                        try {
                            ProcessManager.this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
    }
}

