/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Annotation;
import gate.AnnotationSet;
import gate.util.Err;
import gate.util.Out;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;

public class ClassificationMeasures {
    private float[][] confusionMatrix;
    private float kappaCohen = 0.0f;
    private float kappaPi = 0.0f;
    private boolean isCalculatedKappas = false;
    private TreeSet<String> featureValues;

    public ClassificationMeasures() {
    }

    public float getObservedAgreement() {
        float agreed = this.getAgreedTrials();
        float total = this.getTotalTrials();
        if (total > 0.0f) {
            return agreed / total;
        }
        return 0.0f;
    }

    public float getKappaCohen() {
        if (!this.isCalculatedKappas) {
            this.computeKappaPairwise();
            this.isCalculatedKappas = true;
        }
        return this.kappaCohen;
    }

    public float getKappaPi() {
        if (!this.isCalculatedKappas) {
            this.computeKappaPairwise();
            this.isCalculatedKappas = true;
        }
        return this.kappaPi;
    }

    public float[][] getConfusionMatrix() {
        return (float[][])this.confusionMatrix.clone();
    }

    public SortedSet<String> getFeatureValues() {
        return Collections.unmodifiableSortedSet(this.featureValues);
    }

    public void calculateConfusionMatrix(AnnotationSet aS1, AnnotationSet aS2, String type, String feature, boolean verbose) {
        this.featureValues = new TreeSet();
        HashSet<String> mergedFeatures = new HashSet<String>();
        HashMap<String, HashMap<String, Float>> countMap = new HashMap<String, HashMap<String, Float>>();
        HashSet<String> featureSet = new HashSet<String>();
        featureSet.add(feature);
        AnnotationSet relevantAnns1 = aS1.get(type, featureSet);
        AnnotationSet relevantAnns2 = aS2.get(type, featureSet);
        for (Annotation relevantAnn1 : relevantAnns1) {
            Object aRelevantAnns12;
            ArrayList<Object> dupeAnnotations = new ArrayList<Object>();
            for (Object aRelevantAnns12 : relevantAnns1) {
                if (aRelevantAnns12.equals(relevantAnn1) || !aRelevantAnns12.coextensive(relevantAnn1)) continue;
                dupeAnnotations.add(aRelevantAnns12);
                dupeAnnotations.add(relevantAnn1);
            }
            if (dupeAnnotations.size() > 1) {
                if (!verbose) continue;
                Out.prln("ClassificationMeasures: Same span annotations in set 1 detected! Ignoring.");
                Out.prln(Arrays.toString(dupeAnnotations.toArray()));
                continue;
            }
            ArrayList<Annotation> coextensiveAnnotations = new ArrayList<Annotation>();
            aRelevantAnns12 = relevantAnns2.iterator();
            while (aRelevantAnns12.hasNext()) {
                Annotation relevantAnn2 = (Annotation)aRelevantAnns12.next();
                if (!relevantAnn2.coextensive(relevantAnn1)) continue;
                coextensiveAnnotations.add(relevantAnn2);
            }
            if (coextensiveAnnotations.size() == 0) {
                if (!verbose) continue;
                Out.prln("ClassificationMeasures: Annotation in set 1 with no counterpart in set 2 detected! Ignoring.");
                Out.prln(relevantAnn1.toString());
                continue;
            }
            if (coextensiveAnnotations.size() == 1) {
                Object featObj1 = relevantAnn1.getFeatures().get(feature);
                Object featObj2 = ((Annotation)coextensiveAnnotations.get(0)).getFeatures().get(feature);
                String featVal1 = String.valueOf(featObj1);
                String featVal2 = String.valueOf(featObj2);
                if (!featObj1.getClass().equals(featObj2.getClass()) && !mergedFeatures.contains(feature)) {
                    Err.println("Values for feature '" + feature + "' are of differing types, results may be inconsistent");
                    mergedFeatures.add(feature);
                }
                this.featureValues.add(featVal1);
                this.featureValues.add(featVal2);
                HashMap<String, Float> subHash = countMap.get(featVal1);
                if (subHash == null) {
                    HashMap<String, Float> subHashForNewAS1FeatVal = new HashMap<String, Float>();
                    subHashForNewAS1FeatVal.put(featVal2, Float.valueOf(1.0f));
                    countMap.put(featVal1, subHashForNewAS1FeatVal);
                    continue;
                }
                Float count = subHash.get(featVal2);
                if (count == null) {
                    subHash.put(featVal2, Float.valueOf(1.0f));
                    continue;
                }
                subHash.put(featVal2, Float.valueOf((float)count.intValue() + 1.0f));
                continue;
            }
            if (coextensiveAnnotations.size() <= 1 || !verbose) continue;
            Out.prln("ClassificationMeasures: Same span annotations in set 2 detected! Ignoring.");
            Out.prln(Arrays.toString(coextensiveAnnotations.toArray()));
        }
        this.confusionMatrix = this.convert2DHashTo2DFloatArray(countMap, this.featureValues);
    }

    public ClassificationMeasures(Collection<ClassificationMeasures> tables) {
        HashMap<String, HashMap<String, Float>> countMap = new HashMap<String, HashMap<String, Float>>();
        TreeSet<String> newFeatureValues = new TreeSet<String>();
        for (ClassificationMeasures table : tables) {
            int it1index = 0;
            for (String featureValue1 : table.featureValues) {
                newFeatureValues.add(featureValue1);
                int it2index = 0;
                for (String featureValue2 : table.featureValues) {
                    Float valtoadd = Float.valueOf(table.confusionMatrix[it1index][it2index]);
                    HashMap<String, Float> subHash = countMap.get(featureValue1);
                    if (subHash == null) {
                        HashMap<String, Float> subHashForNewAS1FeatVal = new HashMap<String, Float>();
                        subHashForNewAS1FeatVal.put(featureValue2, valtoadd);
                        countMap.put(featureValue1, subHashForNewAS1FeatVal);
                    } else {
                        Float count = subHash.get(featureValue2);
                        if (count == null) {
                            subHash.put(featureValue2, valtoadd);
                        } else {
                            subHash.put(featureValue2, Float.valueOf((float)count.intValue() + valtoadd.floatValue()));
                        }
                    }
                    ++it2index;
                }
                ++it1index;
            }
        }
        this.confusionMatrix = this.convert2DHashTo2DFloatArray(countMap, newFeatureValues);
        this.featureValues = newFeatureValues;
        this.isCalculatedKappas = false;
    }

    protected void computeKappaPairwise() {
        int i;
        float doubleSum;
        float observedAgreement = this.getObservedAgreement();
        int numCats = this.featureValues.size();
        float[] marginalArrayC = new float[numCats];
        float[] marginalArrayR = new float[numCats];
        float totalSum = 0.0f;
        for (int i2 = 0; i2 < numCats; ++i2) {
            int j;
            float sum = 0.0f;
            for (j = 0; j < numCats; ++j) {
                sum += this.confusionMatrix[i2][j];
            }
            marginalArrayC[i2] = sum;
            totalSum += sum;
            sum = 0.0f;
            for (j = 0; j < numCats; ++j) {
                sum += this.confusionMatrix[j][i2];
            }
            marginalArrayR[i2] = sum;
        }
        float pE = 0.0f;
        if (totalSum > 0.0f) {
            doubleSum = totalSum * totalSum;
            for (i = 0; i < numCats; ++i) {
                pE += marginalArrayC[i] * marginalArrayR[i] / doubleSum;
            }
        }
        this.kappaCohen = pE == 1.0f ? 1.0f : (totalSum > 0.0f ? (observedAgreement - pE) / (1.0f - pE) : 0.0f);
        pE = 0.0f;
        if (totalSum > 0.0f) {
            doubleSum = 2.0f * totalSum;
            for (i = 0; i < numCats; ++i) {
                float p = (marginalArrayC[i] + marginalArrayR[i]) / doubleSum;
                pE += p * p;
            }
        }
        this.kappaPi = pE == 1.0f ? 1.0f : (totalSum > 0.0f ? (observedAgreement - pE) / (1.0f - pE) : 0.0f);
        float[][] sAgreements = new float[numCats][2];
        for (i = 0; i < numCats; ++i) {
            sAgreements[i][0] = marginalArrayC[i] + marginalArrayR[i] > 0.0f ? 2.0f * this.confusionMatrix[i][i] / (marginalArrayC[i] + marginalArrayR[i]) : 0.0f;
            sAgreements[i][1] = 2.0f * totalSum - marginalArrayC[i] - marginalArrayR[i] > 0.0f ? 2.0f * (totalSum - marginalArrayC[i] - marginalArrayR[i] + this.confusionMatrix[i][i]) / (2.0f * totalSum - marginalArrayC[i] - marginalArrayR[i]) : 0.0f;
        }
    }

    public float getAgreedTrials() {
        float sumAgreed = 0.0f;
        for (int i = 0; i < this.featureValues.size(); ++i) {
            sumAgreed += this.confusionMatrix[i][i];
        }
        return sumAgreed;
    }

    public float getTotalTrials() {
        float sumTotal = 0.0f;
        for (int i = 0; i < this.featureValues.size(); ++i) {
            for (int j = 0; j < this.featureValues.size(); ++j) {
                sumTotal += this.confusionMatrix[i][j];
            }
        }
        return sumTotal;
    }

    public List<List<String>> getConfusionMatrix(String title) {
        ArrayList<List<String>> matrix = new ArrayList<List<String>>();
        ArrayList<String> row = new ArrayList<String>();
        row.add(" ");
        matrix.add(row);
        row = new ArrayList();
        row.add(title);
        matrix.add(row);
        TreeSet<String> features = new TreeSet<String>(this.getFeatureValues());
        row = new ArrayList();
        row.add("A \\ B");
        row.addAll(features);
        matrix.add(row);
        for (float[] confusionValues : this.getConfusionMatrix()) {
            row = new ArrayList();
            row.add((String)features.first());
            features.remove(features.first());
            for (float confusionValue : confusionValues) {
                row.add(String.valueOf((int)confusionValue));
            }
            matrix.add(row);
        }
        return matrix;
    }

    public List<String> getMeasuresRow(Object[] measures, String documentName) {
        NumberFormat f = NumberFormat.getInstance(Locale.ENGLISH);
        f.setMaximumFractionDigits(2);
        f.setMinimumFractionDigits(2);
        ArrayList<String> row = new ArrayList<String>();
        row.add(documentName);
        row.add(String.valueOf((int)this.getAgreedTrials()));
        row.add(String.valueOf((int)this.getTotalTrials()));
        for (Object object : measures) {
            float result;
            String measure = (String)object;
            if (measure.equals("Observed agreement")) {
                row.add(f.format(this.getObservedAgreement()));
            }
            if (measure.equals("Cohen's Kappa")) {
                result = this.getKappaCohen();
                row.add(Float.isNaN(result) ? "" : f.format(result));
            }
            if (!measure.equals("Pi's Kappa")) continue;
            result = this.getKappaPi();
            row.add(Float.isNaN(result) ? "" : f.format(result));
        }
        return row;
    }

    private float[][] convert2DHashTo2DFloatArray(HashMap<String, HashMap<String, Float>> countMap, TreeSet<String> featureValues) {
        int dimensionOfContingencyTable = featureValues.size();
        float[][] matrix = new float[dimensionOfContingencyTable][dimensionOfContingencyTable];
        int i = 0;
        int j = 0;
        for (String featureValue1 : featureValues) {
            HashMap<String, Float> hashForThisAS1FeatVal = countMap.get(featureValue1);
            j = 0;
            for (String featureValue2 : featureValues) {
                Float count = null;
                if (hashForThisAS1FeatVal != null) {
                    count = hashForThisAS1FeatVal.get(featureValue2);
                }
                matrix[i][j] = count != null ? count.floatValue() : 0.0f;
                ++j;
            }
            ++i;
        }
        return matrix;
    }
}

