/*
 * Decompiled with CFR 0.152.
 */
package gate.swing;

import gate.util.ObjectComparator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class XJTable
extends JTable {
    private volatile boolean componentSizedProperly = false;
    private volatile boolean sizingInProgress = false;
    protected SortingModel sortingModel;
    protected ObjectComparator defaultComparator;
    protected int sortedColumn = -1;
    protected boolean ascending = true;
    protected boolean sortable = true;
    protected List<ColumnData> columnData;
    protected HeaderMouseListener headerMouseListener;
    protected List<TableColumn> hiddenColumns;
    private boolean enableHidingColumns = false;
    private boolean tabSkipUneditableCell = false;
    private boolean editCellAsSoonAsFocus = false;
    private Action oldTabAction;
    private Action oldShiftTabAction;

    public XJTable() {
        this(null);
    }

    public XJTable(TableModel model) {
        if (model != null) {
            this.setModel(model);
        }
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    @Override
    public void setModel(TableModel dataModel) {
        this.sortingModel = new SortingModel(dataModel);
        this.componentSizedProperly = false;
        super.setModel(this.sortingModel);
        this.newColumns();
    }

    protected void newColumns() {
        this.columnData = new ArrayList<ColumnData>(this.dataModel.getColumnCount());
        this.hiddenColumns = new ArrayList<TableColumn>();
        for (int i = 0; i < this.dataModel.getColumnCount(); ++i) {
            this.columnData.add(new ColumnData(i));
        }
    }

    @Override
    public void setTableHeader(JTableHeader newTableHeader) {
        JTableHeader oldHeader = this.getTableHeader();
        if (oldHeader != null && this.headerMouseListener != null) {
            oldHeader.removeMouseListener(this.headerMouseListener);
        }
        super.setTableHeader(newTableHeader);
        if (this.headerMouseListener == null) {
            this.headerMouseListener = new HeaderMouseListener();
        }
        if (newTableHeader != null) {
            newTableHeader.addMouseListener(this.headerMouseListener);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculatePreferredSize() {
        try {
            if (this.sizingInProgress) {
                return;
            }
            this.sizingInProgress = true;
            int colCount = this.getColumnModel().getColumnCount();
            if (colCount == 0) {
                return;
            }
            if (!this.componentSizedProperly) {
                if (this.getParent() != null) {
                    this.setSize(this.getParent().getWidth(), this.getHeight());
                }
                Dimension spacing = this.getIntercellSpacing();
                for (int col = 0; col < colCount; ++col) {
                    TableColumn tColumn = this.getColumnModel().getColumn(col);
                    TableCellRenderer headerRenderer = tColumn.getHeaderRenderer();
                    boolean needToResetRenderer = false;
                    if (headerRenderer == null) {
                        needToResetRenderer = true;
                        JTableHeader tHeader = this.getTableHeader();
                        if (tHeader == null) {
                            tHeader = new JTableHeader();
                        }
                        headerRenderer = tHeader.getDefaultRenderer();
                        tColumn.setHeaderRenderer(headerRenderer);
                    }
                    if (headerRenderer != null) {
                        Component c = headerRenderer.getTableCellRendererComponent(this, tColumn.getHeaderValue(), false, false, 0, 0);
                        int width = c.getMinimumSize().width + spacing.width;
                        if (tColumn.getMinWidth() != width) {
                            tColumn.setMinWidth(width);
                        }
                        tColumn.setPreferredWidth(width);
                    } else {
                        tColumn.setMinWidth(1);
                        tColumn.setPreferredWidth(1);
                    }
                    if (!needToResetRenderer) continue;
                    tColumn.setHeaderRenderer(null);
                }
                for (int row = 0; row < this.getRowCount(); ++row) {
                    int newRowHeight = 1;
                    for (int column = 0; column < this.getColumnCount(); ++column) {
                        int height;
                        Component cellComponent = this.prepareRenderer(this.getCellRenderer(row, column), row, column);
                        TableColumn tColumn = this.getColumnModel().getColumn(column);
                        int minWidth = (cellComponent == null ? 0 : cellComponent.getMinimumSize().width) + spacing.width;
                        if (tColumn.getPreferredWidth() < minWidth) {
                            tColumn.setPreferredWidth(minWidth);
                        }
                        int n = height = cellComponent == null ? 0 : cellComponent.getPreferredSize().height;
                        if (newRowHeight >= height + spacing.height) continue;
                        newRowHeight = height + spacing.height;
                    }
                    this.setRowHeight(row, newRowHeight);
                }
            }
            if (this.getAutoResizeMode() != 0) {
                int viewportWidth;
                TableColumn resizingCol = null;
                if (this.getTableHeader() != null) {
                    resizingCol = this.getTableHeader().getResizingColumn();
                }
                int prefWidth = 0;
                for (int i = 0; i < colCount; ++i) {
                    int colWidth = this.getColumnModel().getColumn(i).getPreferredWidth();
                    if (colWidth <= 0) continue;
                    prefWidth += colWidth;
                }
                int requestedWidth = this.getWidth();
                Container parent = this.getParent();
                if (parent != null && parent instanceof JViewport && (viewportWidth = ((JViewport)parent).getExtentSize().width) > requestedWidth) {
                    requestedWidth = viewportWidth;
                }
                int extra = 0;
                if (requestedWidth > prefWidth) {
                    extra = requestedWidth - prefWidth;
                    if (this.getAutoResizeMode() == 4) {
                        int extraCol = extra / colCount;
                        for (int col = 0; col < colCount - 1; ++col) {
                            TableColumn tColumn = this.getColumnModel().getColumn(col);
                            if (tColumn == resizingCol) continue;
                            tColumn.setPreferredWidth(tColumn.getPreferredWidth() + extraCol);
                            extra -= extraCol;
                        }
                    }
                    TableColumn tColumn = this.getColumnModel().getColumn(colCount - 1);
                    tColumn.setPreferredWidth(tColumn.getPreferredWidth() + extra);
                }
            }
        }
        finally {
            this.componentSizedProperly = true;
            this.sizingInProgress = false;
        }
    }

    @Override
    public void doLayout() {
        this.calculatePreferredSize();
        super.doLayout();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        if (!this.componentSizedProperly) {
            this.calculatePreferredSize();
        }
        return super.getPreferredSize();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (super.getScrollableTracksViewportWidth()) {
            Container parent = this.getParent();
            if (parent != null && parent instanceof JViewport) {
                return ((JViewport)parent).getExtentSize().width > this.getPreferredSize().width;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        Container parent = this.getParent();
        Dimension dim = this.getPreferredSize();
        return parent != null && dim != null && parent instanceof JViewport && parent.getHeight() > this.getPreferredSize().height;
    }

    public int rowModelToView(int modelRow) {
        return this.sortingModel.sourceToTarget(modelRow);
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public boolean isColumnHidden(int columnIndex) {
        for (TableColumn hiddenColumn : this.hiddenColumns) {
            if (hiddenColumn.getModelIndex() != columnIndex) continue;
            return true;
        }
        return false;
    }

    public void hideColumn(int columnIndex) {
        int viewColumn = this.convertColumnIndexToView(columnIndex);
        TableColumn columnToHide = this.columnModel.getColumn(viewColumn);
        this.columnModel.removeColumn(columnToHide);
        this.hiddenColumns.add(columnToHide);
    }

    public void showColumn(int columnIndex, int insertionIndex) {
        for (TableColumn hiddenColumn : this.hiddenColumns) {
            if (hiddenColumn.getModelIndex() != columnIndex) continue;
            this.columnModel.addColumn(hiddenColumn);
            this.columnModel.moveColumn(this.columnModel.getColumnCount() - 1, insertionIndex);
            this.hiddenColumns.remove(hiddenColumn);
            break;
        }
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public int rowViewToModel(int viewRow) {
        return this.sortingModel.targetToSource(viewRow);
    }

    public void setEnableHidingColumns(boolean enableHidingColumns) {
        this.enableHidingColumns = enableHidingColumns;
    }

    public boolean isEnableHidingColumns() {
        return this.enableHidingColumns;
    }

    public boolean isEditCellAsSoonAsFocus() {
        return this.editCellAsSoonAsFocus;
    }

    public void setEditCellAsSoonAsFocus(boolean editCellAsSoonAsFocus) {
        this.editCellAsSoonAsFocus = editCellAsSoonAsFocus;
    }

    public boolean isTabSkipUneditableCell() {
        return this.tabSkipUneditableCell;
    }

    public void setTabSkipUneditableCell(boolean tabSkipUneditableCell) {
        this.tabSkipUneditableCell = tabSkipUneditableCell;
        InputMap im = this.getInputMap(1);
        KeyStroke tab = KeyStroke.getKeyStroke("TAB");
        KeyStroke shiftTab = KeyStroke.getKeyStroke("shift TAB");
        if (this.oldTabAction == null) {
            this.oldTabAction = this.getActionMap().get(im.get(tab));
            this.oldShiftTabAction = this.getActionMap().get(im.get(shiftTab));
        }
        if (tabSkipUneditableCell) {
            AbstractAction tabAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int column;
                    int row;
                    XJTable.this.oldTabAction.actionPerformed(e);
                    JTable table = (JTable)e.getSource();
                    int originalRow = row = table.getSelectedRow();
                    int originalColumn = column = table.getSelectedColumn();
                    while (!table.isCellEditable(row, column)) {
                        XJTable.this.oldTabAction.actionPerformed(e);
                        row = table.getSelectedRow();
                        column = table.getSelectedColumn();
                        if (row != originalRow || column != originalColumn) continue;
                        break;
                    }
                }
            };
            this.getActionMap().put(im.get(tab), tabAction);
            AbstractAction shiftTabAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int column;
                    int row;
                    XJTable.this.oldShiftTabAction.actionPerformed(e);
                    JTable table = (JTable)e.getSource();
                    int originalRow = row = table.getSelectedRow();
                    int originalColumn = column = table.getSelectedColumn();
                    while (!table.isCellEditable(row, column)) {
                        XJTable.this.oldShiftTabAction.actionPerformed(e);
                        row = table.getSelectedRow();
                        column = table.getSelectedColumn();
                        if (row != originalRow || column != originalColumn) continue;
                        break;
                    }
                }
            };
            this.getActionMap().put(im.get(shiftTab), shiftTabAction);
        } else {
            this.getActionMap().put(im.get(tab), this.oldTabAction);
            this.getActionMap().put(im.get(shiftTab), this.oldShiftTabAction);
        }
    }

    public void setComparator(int column, Comparator<?> comparator) {
        this.columnData.get((int)column).comparator = comparator;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public int getSortedColumn() {
        return this.sortedColumn;
    }

    public void setSortedColumn(int sortColumn) {
        this.sortedColumn = sortColumn;
    }

    public int getTableRow(int modelRow) {
        return this.sortingModel.sourceToTarget(modelRow);
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
        if (!toggle && !extend && this.editCellAsSoonAsFocus && !this.isEditing() && this.isCellEditable(rowIndex, columnIndex)) {
            this.editCellAt(rowIndex, columnIndex);
        }
    }

    @Override
    public int rowAtPoint(Point point) {
        if (!this.componentSizedProperly) {
            this.calculatePreferredSize();
        }
        return super.rowAtPoint(point);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e != null && e.getType() == 0 && e.getFirstRow() != -1 && e.getLastRow() != Integer.MAX_VALUE) {
            this.handleRowUpdate(e);
        } else {
            super.tableChanged(e);
        }
    }

    private void handleRowUpdate(TableModelEvent e) {
        Rectangle dirtyRegion;
        int modelColumn = e.getColumn();
        int start = e.getFirstRow();
        int end = e.getLastRow();
        if (modelColumn == -1) {
            int rowStart = 0;
            for (int row = 0; row < start; ++row) {
                rowStart += this.getRowHeight(row);
            }
            dirtyRegion = new Rectangle(0, rowStart, this.getColumnModel().getTotalColumnWidth(), 0);
        } else {
            int column = this.convertColumnIndexToView(modelColumn);
            dirtyRegion = this.getCellRect(start, column, true);
        }
        dirtyRegion.height = 0;
        for (int row = start; row <= end; ++row) {
            dirtyRegion.height += this.getRowHeight(row);
        }
        this.repaint(dirtyRegion.x, dirtyRegion.y, dirtyRegion.width, dirtyRegion.height);
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
        if (this.isEditing()) {
            this.cellEditor.stopCellEditing();
        }
        super.columnMoved(e);
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        if (this.isEditing()) {
            this.cellEditor.stopCellEditing();
        }
        TableColumn resizingCol = null;
        if (this.getTableHeader() != null) {
            resizingCol = this.getTableHeader().getResizingColumn();
        }
        if (resizingCol != null) {
            resizingCol.setPreferredWidth(resizingCol.getWidth());
        }
        super.columnMarginChanged(e);
    }

    protected class ColumnData {
        int column;
        int columnWidth;
        Comparator<?> comparator;

        public ColumnData(int column) {
            this.column = column;
        }
    }

    protected class HeaderMouseListener
    extends MouseAdapter {
        protected HeaderMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.process(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.process(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.process(e);
        }

        protected void process(MouseEvent e) {
            final int viewColumn = XJTable.this.columnModel.getColumnIndexAtX(e.getX());
            if (viewColumn != -1) {
                final int column = XJTable.this.convertColumnIndexToModel(viewColumn);
                if (e.isPopupTrigger() && XJTable.this.enableHidingColumns) {
                    JPopupMenu popup = new JPopupMenu();
                    if (XJTable.this.columnModel.getColumnCount() > 1) {
                        popup.add(new AbstractAction("Hide column " + XJTable.this.dataModel.getColumnName(column)){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                XJTable.this.hideColumn(column);
                            }
                        });
                    }
                    if (XJTable.this.hiddenColumns.size() > 0) {
                        popup.addSeparator();
                    }
                    Iterator<TableColumn> iterator = XJTable.this.hiddenColumns.iterator();
                    while (iterator.hasNext()) {
                        TableColumn hiddenColumn;
                        final TableColumn hiddenColumnF = hiddenColumn = iterator.next();
                        popup.add(new AbstractAction("Show column " + XJTable.this.dataModel.getColumnName(hiddenColumn.getModelIndex())){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                XJTable.this.showColumn(hiddenColumnF.getModelIndex(), viewColumn);
                            }
                        });
                    }
                    popup.show(e.getComponent(), e.getX(), e.getY());
                } else if (!e.isPopupTrigger() && e.getID() == 500 && e.getClickCount() == 1 && XJTable.this.sortable && column != -1) {
                    XJTable.this.ascending = column == XJTable.this.sortedColumn ? !XJTable.this.ascending : true;
                    XJTable.this.sortedColumn = column;
                    XJTable.this.sortingModel.sort();
                }
            }
        }
    }

    protected class SortingModel
    extends AbstractTableModel
    implements TableModelListener {
        protected int[] sourceToTarget;
        protected int[] targetToSource;
        protected TableModel sourceModel;
        protected ValueHolderComparator compWrapper = new ValueHolderComparator();

        public SortingModel(TableModel sourceModel) {
            this.init(sourceModel);
        }

        protected void init(TableModel sourceModel) {
            if (this.sourceModel != null) {
                this.sourceModel.removeTableModelListener(this);
            }
            this.sourceModel = sourceModel;
            int size = sourceModel.getRowCount();
            this.sourceToTarget = new int[size];
            this.targetToSource = new int[size];
            for (int i = 0; i < size; ++i) {
                this.sourceToTarget[i] = i;
                this.targetToSource[i] = i;
            }
            sourceModel.addTableModelListener(this);
            if (XJTable.this.isSortable() && XJTable.this.sortedColumn == -1) {
                XJTable.this.setSortedColumn(0);
            }
            XJTable.this.componentSizedProperly = false;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            int type = e.getType();
            int firstRow = e.getFirstRow();
            int lastRow = e.getLastRow();
            int column = e.getColumn();
            switch (type) {
                case 0: {
                    if (firstRow == -1) {
                        this.init(this.sourceModel);
                        XJTable.this.newColumns();
                        this.fireTableStructureChanged();
                        if (!XJTable.this.isSortable()) break;
                        this.sort();
                        break;
                    }
                    if (lastRow == Integer.MAX_VALUE) {
                        this.init(this.sourceModel);
                        if (XJTable.this.isSortable()) {
                            this.sort();
                            break;
                        }
                        XJTable.this.componentSizedProperly = false;
                        this.fireTableDataChanged();
                        break;
                    }
                    if (XJTable.this.isSortable() && (column == XJTable.this.sortedColumn || column == -1)) {
                        this.sort();
                        break;
                    }
                    XJTable.this.componentSizedProperly = false;
                    this.fireTableChanged(new TableModelEvent(this, this.sourceToTarget(firstRow), this.sourceToTarget(lastRow), column, type));
                    break;
                }
                case 1: {
                    this.init(this.sourceModel);
                    if (firstRow != -1 && firstRow == lastRow) {
                        if (XJTable.this.isSortable()) {
                            this.sort();
                            break;
                        }
                        XJTable.this.componentSizedProperly = false;
                        this.fireTableChanged(new TableModelEvent(this, this.sourceToTarget(firstRow), this.sourceToTarget(lastRow), column, type));
                        break;
                    }
                    if (XJTable.this.isSortable()) {
                        this.sort();
                        break;
                    }
                    XJTable.this.componentSizedProperly = false;
                    this.fireTableDataChanged();
                    break;
                }
                case -1: {
                    this.init(this.sourceModel);
                    if (XJTable.this.isSortable()) {
                        this.sort();
                        break;
                    }
                    XJTable.this.componentSizedProperly = false;
                    this.fireTableDataChanged();
                }
            }
        }

        @Override
        public int getRowCount() {
            return this.sourceToTarget.length;
        }

        @Override
        public int getColumnCount() {
            return this.sourceModel.getColumnCount();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.sourceModel.getColumnName(columnIndex);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.sourceModel.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            int sourceRow = this.targetToSource(rowIndex);
            return sourceRow >= 0 ? this.sourceModel.isCellEditable(sourceRow, columnIndex) : false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            int sourceRow = this.targetToSource(rowIndex);
            if (sourceRow >= 0) {
                this.sourceModel.setValueAt(aValue, sourceRow, columnIndex);
            }
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                return this.sourceModel.getValueAt(this.targetToSource(row), column);
            }
            catch (IndexOutOfBoundsException iobe) {
                return null;
            }
        }

        public void sort() {
            try {
                int i;
                if (XJTable.this.sortedColumn >= XJTable.this.columnData.size()) {
                    return;
                }
                int[] rows = XJTable.this.getSelectedRows();
                for (int i2 = 0; i2 < rows.length; ++i2) {
                    rows[i2] = XJTable.this.rowViewToModel(rows[i2]);
                }
                ArrayList<ValueHolder> sourceData = new ArrayList<ValueHolder>(this.sourceModel.getRowCount());
                for (int i3 = 0; i3 < this.sourceModel.getRowCount(); ++i3) {
                    Object value = this.sourceModel.getValueAt(i3, XJTable.this.sortedColumn);
                    sourceData.add(new ValueHolder(value, i3));
                }
                ObjectComparator comparator = XJTable.this.columnData.get((int)XJTable.this.sortedColumn).comparator;
                if (comparator == null) {
                    if (XJTable.this.defaultComparator == null) {
                        XJTable.this.defaultComparator = new ObjectComparator();
                    }
                    comparator = XJTable.this.defaultComparator;
                }
                this.compWrapper.setComparator(comparator);
                Collections.sort(sourceData, this.compWrapper);
                for (i = 0; i < sourceData.size(); ++i) {
                    int targetIndex = i;
                    int sourceIndex = ((ValueHolder)sourceData.get(i)).index;
                    this.sourceToTarget[sourceIndex] = targetIndex;
                    this.targetToSource[targetIndex] = sourceIndex;
                }
                sourceData.clear();
                XJTable.this.componentSizedProperly = false;
                this.fireTableDataChanged();
                XJTable.this.resizeAndRepaint();
                XJTable.this.clearSelection();
                for (i = 0; i < rows.length; ++i) {
                    rows[i] = XJTable.this.rowModelToView(rows[i]);
                    if (rows[i] <= 0 || rows[i] >= this.getRowCount()) continue;
                    XJTable.this.addRowSelectionInterval(rows[i], rows[i]);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }

        public int sourceToTarget(int index) {
            return index >= 0 && index < this.sourceToTarget.length ? this.sourceToTarget[index] : -1;
        }

        public int targetToSource(int index) {
            return index >= 0 && index < this.targetToSource.length ? this.targetToSource[index] : -1;
        }

        protected void buildTargetToSourceIndex() {
            this.targetToSource = new int[this.sourceToTarget.length];
            for (int i = 0; i < this.sourceToTarget.length; ++i) {
                this.targetToSource[this.sourceToTarget[i]] = i;
            }
        }

        protected class ValueHolderComparator
        implements Comparator<ValueHolder> {
            private Comparator comparator;

            protected ValueHolderComparator() {
            }

            protected Comparator getComparator() {
                return this.comparator;
            }

            protected void setComparator(Comparator comparator) {
                this.comparator = comparator;
            }

            @Override
            public int compare(ValueHolder o1, ValueHolder o2) {
                return XJTable.this.ascending ? this.comparator.compare(o1.value, o2.value) : this.comparator.compare(o1.value, o2.value) * -1;
            }
        }

        protected class ValueHolder {
            private Object value;
            private int index;

            public ValueHolder(Object value, int index) {
                this.value = value;
                this.index = index;
            }
        }
    }
}

