/*
 * Decompiled with CFR 0.152.
 */
package gate.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JPopupMenu;

public class MenuLayout
implements LayoutManager {
    private int[] columnForComponentIndex;
    private ArrayList<Integer> preferredWidthForColumn;

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        int membersCnt = target.getComponentCount();
        Dimension[] componentPrefSizes = new Dimension[membersCnt];
        for (int i = 0; i < membersCnt; ++i) {
            componentPrefSizes[i] = target.getComponent(i).getPreferredSize();
        }
        return this.getCompositeSize(target, componentPrefSizes);
    }

    protected Dimension getCompositeSize(Container target, Dimension[] componentSizes) {
        Component invoker;
        Point location = new Point(0, 0);
        if (target.isShowing()) {
            location = target.getLocationOnScreen();
        } else if (target instanceof JPopupMenu && (invoker = ((JPopupMenu)target).getInvoker()) != null) {
            location = invoker.getLocationOnScreen();
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Rectangle contentsBounds = new Rectangle(toolkit.getScreenSize());
        Insets screenInsets = new Insets(0, 0, 0, 0);
        GraphicsConfiguration gc = this.findGraphicsConfiguration(target);
        if (gc != null) {
            contentsBounds = gc.getBounds();
            screenInsets = toolkit.getScreenInsets(gc);
        }
        contentsBounds.width -= screenInsets.left + screenInsets.right;
        contentsBounds.height -= screenInsets.top + screenInsets.bottom;
        contentsBounds.height = Math.max(location.y, contentsBounds.height - location.y);
        Insets insets = target.getInsets();
        contentsBounds.width -= insets.left + insets.right;
        contentsBounds.height -= insets.top + insets.bottom;
        Dimension dim = new Dimension(0, 0);
        int previousColumnsWidth = 0;
        int previousColumnsHeight = 0;
        int columnIndex = 1;
        int firstComponentIndexForColumn = 0;
        this.columnForComponentIndex = new int[componentSizes.length];
        this.preferredWidthForColumn = new ArrayList();
        for (int i = 0; i < componentSizes.length; ++i) {
            if (dim.height + componentSizes[i].height <= contentsBounds.height) {
                dim.height += componentSizes[i].height;
                dim.width = Math.max(dim.width, componentSizes[i].width);
                continue;
            }
            Arrays.fill(this.columnForComponentIndex, firstComponentIndexForColumn, i, columnIndex);
            this.preferredWidthForColumn.add(dim.width);
            firstComponentIndexForColumn = i;
            ++columnIndex;
            previousColumnsWidth += dim.width;
            previousColumnsHeight = Math.max(previousColumnsHeight, dim.height);
            dim.height = componentSizes[i].height;
            dim.width = componentSizes[i].width;
        }
        Arrays.fill(this.columnForComponentIndex, firstComponentIndexForColumn, this.columnForComponentIndex.length, columnIndex);
        this.preferredWidthForColumn.add(dim.width);
        dim.height = Math.max(previousColumnsHeight, dim.height);
        dim.width += previousColumnsWidth;
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom;
        return dim;
    }

    protected GraphicsConfiguration findGraphicsConfiguration(Component target) {
        Component invoker;
        GraphicsConfiguration gc = null;
        if (!target.isShowing() && target instanceof JPopupMenu && (invoker = ((JPopupMenu)target).getInvoker()) != null) {
            target = invoker;
        }
        if (target.isShowing()) {
            Point position = target.getLocationOnScreen();
            gc = target.getGraphicsConfiguration();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (GraphicsDevice gd : ge.getScreenDevices()) {
                GraphicsConfiguration dgc;
                if (gd.getType() != 0 || !(dgc = gd.getDefaultConfiguration()).getBounds().contains(position)) continue;
                gc = dgc;
                break;
            }
        }
        return gc;
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        int membersCnt = target.getComponentCount();
        Dimension[] componentMinSizes = new Dimension[membersCnt];
        for (int i = 0; i < membersCnt; ++i) {
            componentMinSizes[i] = target.getComponent(i).getMinimumSize();
        }
        return this.getCompositeSize(target, componentMinSizes);
    }

    @Override
    public void layoutContainer(Container target) {
        Insets insets = target.getInsets();
        Rectangle bounds = target.getBounds();
        int maxheight = bounds.height - insets.bottom;
        int compCnt = target.getComponentCount();
        int y = insets.top;
        int x = insets.left;
        int rowWidth = 0;
        for (int i = 0; i < compCnt; ++i) {
            Component comp = target.getComponent(i);
            if (!comp.isVisible()) continue;
            Dimension d = comp.getPreferredSize();
            comp.setSize(d);
            if (y + d.height <= maxheight) {
                comp.setLocation(x, y);
                y += d.height;
                rowWidth = Math.max(rowWidth, d.width);
                continue;
            }
            x += rowWidth;
            rowWidth = 0;
            y = insets.top;
            comp.setLocation(x, y);
            y += d.height;
            rowWidth = Math.max(rowWidth, d.width);
        }
    }

    public int getColumnForComponentIndex(int index) {
        return this.columnForComponentIndex[index];
    }

    public int getPreferredWidthForColumn(int index) {
        return this.preferredWidthForColumn.get(index - 1);
    }
}

