/*
 * Decompiled with CFR 0.152.
 */
package gate.sgml;

import gate.Document;
import gate.sgml.CustomObject;
import gate.sgml.MyComparator;
import gate.util.Files;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;

public class Sgml2Xml {
    private Document m_doc = null;
    private StringBuffer m_modifier = null;
    private Stack<CustomObject> stack = null;
    private List<CustomObject> dubiousElements = null;
    private int m_cursor = 0;
    private int m_currState = 1;
    private char m_currChar = (char)32;
    private int charPos = 0;
    private String elemName = null;
    private int elemNameStart = 0;
    private int elemNameEnd = 0;
    private int closePos = 0;
    private int attrStart = 0;
    private int attrEnd = 0;
    private char endPair = (char)32;

    public Sgml2Xml(String SgmlDoc) {
        this.m_modifier = new StringBuffer(SgmlDoc);
        this.dubiousElements = new ArrayList<CustomObject>();
        this.stack = new Stack();
    }

    public Sgml2Xml(Document doc) {
        this.m_doc = doc;
        this.m_modifier = new StringBuffer(this.m_doc.getContent().toString());
        this.dubiousElements = new ArrayList<CustomObject>();
        this.stack = new Stack();
    }

    private void doState1(char currChar) {
        if ('<' == currChar) {
            this.m_currState = 2;
            if (!this.stack.isEmpty()) {
                CustomObject o = this.stack.peek();
                if (this.charPos > 0) {
                    o.setClosePos(this.charPos);
                    o.setEmpty(false);
                    this.charPos = 0;
                }
            }
        }
        if ('<' != currChar && !this.isWhiteSpace(currChar)) {
            this.charPos = this.m_cursor;
        }
    }

    private void doState2(char currChar) {
        if ('/' == currChar) {
            this.m_currState = 11;
        }
        if ('/' != this.m_currChar && !this.isWhiteSpace(this.m_currChar)) {
            this.elemNameStart = this.m_cursor - 1;
            this.m_currState = 3;
        }
    }

    private void doState3(char currChar) {
        if ('>' == currChar) {
            this.elemNameEnd = this.m_cursor - 1;
            this.closePos = this.m_cursor - 1;
            this.elemName = this.m_modifier.substring(this.elemNameStart, this.elemNameEnd);
            this.performFinalAction(this.elemName, this.closePos);
            this.m_currState = 1;
        }
        if (this.isWhiteSpace(currChar)) {
            this.m_currState = 4;
            this.elemNameEnd = this.m_cursor - 1;
            this.elemName = this.m_modifier.substring(this.elemNameStart, this.elemNameEnd);
        }
    }

    private void doState4(char currChar) {
        if ('>' == currChar) {
            this.closePos = this.m_cursor - 1;
            this.performFinalAction(this.elemName, this.closePos);
            this.m_currState = 1;
        }
        if ('>' != currChar && !this.isWhiteSpace(currChar)) {
            this.m_currState = 5;
            this.attrStart = this.m_cursor - 1;
        }
    }

    private void doState5(char currChar) {
        if ('=' == currChar) {
            this.m_currState = 6;
        }
        if ('>' == currChar) {
            this.attrEnd = this.m_cursor - 1;
            this.m_modifier.insert(this.attrEnd, '\"');
            this.m_modifier.insert(this.attrStart, "defaultAttr=\"");
            this.m_currState = 4;
            this.m_cursor = this.attrStart;
        }
        if (this.isWhiteSpace(currChar)) {
            this.m_currState = 10;
            this.attrEnd = this.m_cursor - 1;
        }
    }

    private void doState6(char currChar) {
        if ('\'' == currChar || '\"' == currChar) {
            this.endPair = currChar;
            if ('\'' == currChar) {
                this.m_modifier = this.m_modifier.replace(this.m_cursor - 1, this.m_cursor, "\"");
            }
            this.m_currState = 7;
        }
        if ('\'' != currChar && '\"' != currChar && !this.isWhiteSpace(currChar)) {
            this.m_currState = 8;
            this.m_modifier.insert(this.m_cursor - 1, '\"');
            ++this.m_cursor;
        }
    }

    private void doState7(char currChar) {
        if (this.endPair == currChar) {
            if ('\'' == currChar) {
                this.m_modifier = this.m_modifier.replace(this.m_cursor - 1, this.m_cursor, "\"");
            }
            this.endPair = (char)32;
            this.m_currState = 9;
        }
        if ('>' == currChar) {
            this.m_currState = 1;
            this.m_modifier.insert(this.m_cursor - 1, '\"');
            ++this.m_cursor;
            this.performFinalAction(this.elemName, this.m_cursor - 1);
        }
    }

    private void doState8(char currChar) {
        if ('>' == currChar) {
            this.m_currState = 1;
            this.m_modifier.insert(this.m_cursor - 1, '\"');
            ++this.m_cursor;
            this.performFinalAction(this.elemName, this.m_cursor - 1);
        }
        if (this.isWhiteSpace(currChar)) {
            this.m_currState = 9;
            this.m_modifier.insert(this.m_cursor - 1, '\"');
            ++this.m_cursor;
        }
    }

    private void doState9(char currChar) {
        if ('>' == currChar) {
            this.m_currState = 1;
            this.performFinalAction(this.elemName, this.m_cursor - 1);
        }
        if ('>' != currChar && !this.isWhiteSpace(this.m_currChar)) {
            this.m_currState = 5;
            this.attrStart = this.m_cursor - 1;
        }
    }

    private void doState10(char currChar) {
        if ('=' == currChar) {
            this.m_currState = 6;
        }
        if ('=' != currChar && !this.isWhiteSpace(currChar)) {
            this.m_modifier.insert(this.attrEnd, '\"');
            this.m_modifier.insert(this.attrStart, "defaultAttr=\"");
            this.m_currState = 4;
            this.m_cursor = this.attrStart;
        }
    }

    private void doState11(char currChar) {
        if (!this.isWhiteSpace(currChar)) {
            this.m_currState = 12;
            this.elemNameStart = this.m_cursor - 1;
        }
    }

    private void doState12(char currChar) {
        if ('>' == currChar) {
            this.elemNameEnd = this.m_cursor - 1;
            this.elemName = this.m_modifier.substring(this.elemNameStart, this.elemNameEnd);
            this.performActionWithEndElem(this.elemName);
            this.m_currState = 1;
        }
        if (this.isWhiteSpace(currChar)) {
            this.m_currState = 13;
            this.elemNameEnd = this.m_cursor - 1;
        }
    }

    private void doState13(char currChar) {
        if ('>' == currChar) {
            this.elemName = this.m_modifier.substring(this.elemNameStart, this.elemNameEnd);
            this.performActionWithEndElem(this.elemName);
            this.m_currState = 1;
        }
    }

    public String convert() throws IOException, MalformedURLException {
        while (this.thereAreCharsToBeProcessed()) {
            this.m_currChar = this.read();
            switch (this.m_currState) {
                case 1: {
                    this.doState1(this.m_currChar);
                    break;
                }
                case 2: {
                    this.doState2(this.m_currChar);
                    break;
                }
                case 3: {
                    this.doState3(this.m_currChar);
                    break;
                }
                case 4: {
                    this.doState4(this.m_currChar);
                    break;
                }
                case 5: {
                    this.doState5(this.m_currChar);
                    break;
                }
                case 6: {
                    this.doState6(this.m_currChar);
                    break;
                }
                case 7: {
                    this.doState7(this.m_currChar);
                    break;
                }
                case 8: {
                    this.doState8(this.m_currChar);
                    break;
                }
                case 9: {
                    this.doState9(this.m_currChar);
                    break;
                }
                case 10: {
                    this.doState10(this.m_currChar);
                    break;
                }
                case 11: {
                    this.doState11(this.m_currChar);
                    break;
                }
                case 12: {
                    this.doState12(this.m_currChar);
                    break;
                }
                case 13: {
                    this.doState13(this.m_currChar);
                }
            }
        }
        while (!this.stack.isEmpty()) {
            CustomObject obj = this.stack.pop();
            this.dubiousElements.add(obj);
        }
        Collections.sort(this.dubiousElements, new MyComparator());
        ListIterator<CustomObject> listIterator = this.dubiousElements.listIterator();
        while (listIterator.hasNext()) {
            CustomObject obj = listIterator.next();
            this.makeFinalModifications(obj);
        }
        this.m_modifier.insert(0, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        File file = Files.writeTempFile(this.m_modifier.toString(), "UTF-8");
        return file.toURI().toURL().toString();
    }

    private boolean thereAreCharsToBeProcessed() {
        return this.m_cursor < this.m_modifier.length();
    }

    private char read() {
        return this.m_modifier.charAt(this.m_cursor++);
    }

    private void performFinalAction(String elemName, int pos) {
        CustomObject obj = new CustomObject();
        obj.setElemName(elemName);
        obj.setClosePos(pos);
        obj.setEmpty(true);
        this.stack.push(obj);
    }

    private void performActionWithEndElem(String elemName) {
        CustomObject obj = null;
        boolean stop = false;
        while (!this.stack.isEmpty() && !stop) {
            obj = this.stack.pop();
            if (obj.getElemName().equalsIgnoreCase(elemName)) {
                stop = true;
                continue;
            }
            this.dubiousElements.add(obj);
        }
    }

    private void makeFinalModifications(CustomObject aCustomObject) {
        String endElement = null;
        if (aCustomObject.isEmpty()) {
            this.m_modifier.insert(aCustomObject.getClosePos(), "/");
        } else {
            endElement = "</" + aCustomObject.getElemName() + ">";
            this.m_modifier.insert(aCustomObject.getClosePos(), endElement);
        }
    }

    private boolean isWhiteSpace(char c) {
        return Character.isWhitespace(c);
    }
}

