/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class DownIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        GeneralPath shape = null;
        Color paint = null;
        BasicStroke stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 64.0, 64.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = DownIcon.getColor(254, 95, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(31.875, 59.6875);
        shape.lineTo(31.53125, 59.34375);
        shape.lineTo(31.40625, 59.46875);
        shape.lineTo(6.9375, 35.3125);
        shape.lineTo(13.25, 29.4375);
        shape.lineTo(27.125, 43.125);
        shape.lineTo(27.125, 4.46875);
        shape.lineTo(37.15625, 4.46875);
        shape.lineTo(37.15625, 42.9375);
        shape.lineTo(50.8125, 30.125);
        shape.lineTo(56.96875, 36.125);
        shape.lineTo(31.875, 59.6875);
        shape.closePath();
        shape.moveTo(31.90625, 47.84375);
        shape.lineTo(32.3125, 47.46875);
        shape.lineTo(31.53125, 47.46875);
        shape.lineTo(31.90625, 47.84375);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = DownIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.6944917f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(31.875, 59.6875);
        shape.lineTo(31.53125, 59.34375);
        shape.lineTo(31.40625, 59.46875);
        shape.lineTo(6.9375, 35.3125);
        shape.lineTo(13.25, 29.4375);
        shape.lineTo(27.125, 43.125);
        shape.lineTo(27.125, 4.46875);
        shape.lineTo(37.15625, 4.46875);
        shape.lineTo(37.15625, 42.9375);
        shape.lineTo(50.8125, 30.125);
        shape.lineTo(56.96875, 36.125);
        shape.lineTo(31.875, 59.6875);
        shape.closePath();
        shape.moveTo(31.90625, 47.84375);
        shape.lineTo(32.3125, 47.46875);
        shape.lineTo(31.53125, 47.46875);
        shape.lineTo(31.90625, 47.84375);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 6;
    }

    public static int getOrigY() {
        return 4;
    }

    public static int getOrigWidth() {
        return 64;
    }

    public static int getOrigHeight() {
        return 64;
    }

    public DownIcon() {
        this(DownIcon.getOrigWidth(), DownIcon.getOrigHeight(), false);
    }

    public DownIcon(boolean disabled) {
        this(DownIcon.getOrigWidth(), DownIcon.getOrigHeight(), disabled);
    }

    public DownIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public DownIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public DownIcon(int width, int height) {
        this(width, height, false);
    }

    public DownIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)DownIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)DownIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        DownIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

