/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class DatastoreIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        Shape shape = null;
        Paint paint = null;
        BasicStroke stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 64.0, 64.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = DatastoreIcon.getColor(206, 38, 38, 255, disabled);
        shape = new Rectangle2D.Double(19.092864990234375, 1.8962687253952026, 36.28733f, 53.14672088623047);
        g.setPaint(paint);
        g.fill(shape);
        paint = DatastoreIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.2325734f, 0, 0, 4.0f, null, 0.0f);
        shape = new Rectangle2D.Double(19.092864990234375, 1.8962687253952026, 36.28733f, 53.14672088623047);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        float alpha__0_0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = DatastoreIcon.getColor(106, 18, 18, 255, disabled);
        shape = new Rectangle2D.Double(10.880569458007812, 9.22255f, 36.28733f, 53.14672088623047);
        g.setPaint(paint);
        g.fill(shape);
        paint = DatastoreIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.2325734f, 0, 0, 4.0f, null, 0.0f);
        shape = new Rectangle2D.Double(10.880569458007812, 9.22255f, 36.28733f, 53.14672088623047);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_1;
        g.setTransform(defaultTransform__0_0_1);
        g.setClip(clip__0_0_1);
        float alpha__0_0_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_2 = g.getClip();
        AffineTransform defaultTransform__0_0_2 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = DatastoreIcon.getColor(106, 18, 18, 255, disabled);
        shape = new GeneralPath();
        ((GeneralPath)shape).moveTo(18.740345, 1.8628063);
        ((GeneralPath)shape).lineTo(55.34392, 1.5540226);
        ((GeneralPath)shape).lineTo(48.05711, 8.674797);
        ((GeneralPath)shape).lineTo(11.164414, 8.520404);
        ((GeneralPath)shape).lineTo(18.740345, 1.8628063);
        ((GeneralPath)shape).closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = DatastoreIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(0.8041758f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        ((GeneralPath)shape).moveTo(18.740345, 1.8628063);
        ((GeneralPath)shape).lineTo(55.34392, 1.5540226);
        ((GeneralPath)shape).lineTo(48.05711, 8.674797);
        ((GeneralPath)shape).lineTo(11.164414, 8.520404);
        ((GeneralPath)shape).lineTo(18.740345, 1.8628063);
        ((GeneralPath)shape).closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_2;
        g.setTransform(defaultTransform__0_0_2);
        g.setClip(clip__0_0_2);
        float alpha__0_0_3 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_3 = g.getClip();
        AffineTransform defaultTransform__0_0_3 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = DatastoreIcon.getColor(106, 18, 18, 255, disabled);
        shape = new GeneralPath();
        ((GeneralPath)shape).moveTo(48.192608, 9.700176);
        ((GeneralPath)shape).lineTo(55.633034, 2.4948509);
        ((GeneralPath)shape).lineTo(55.633034, 55.204884);
        ((GeneralPath)shape).lineTo(48.258106, 61.75518);
        ((GeneralPath)shape).lineTo(48.192608, 9.700176);
        ((GeneralPath)shape).closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = DatastoreIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.2325734f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        ((GeneralPath)shape).moveTo(48.192608, 9.700176);
        ((GeneralPath)shape).lineTo(55.633034, 2.4948509);
        ((GeneralPath)shape).lineTo(55.633034, 55.204884);
        ((GeneralPath)shape).lineTo(48.258106, 61.75518);
        ((GeneralPath)shape).lineTo(48.192608, 9.700176);
        ((GeneralPath)shape).closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_3;
        g.setTransform(defaultTransform__0_0_3);
        g.setClip(clip__0_0_3);
        float alpha__0_0_4 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_4 = g.getClip();
        AffineTransform defaultTransform__0_0_4 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = new LinearGradientPaint(new Point2D.Double(41.546146392822266, 16.15620231628418), new Point2D.Double(16.45088768005371, 32.46992874145508), new float[]{0.0f, 1.0f}, new Color[]{DatastoreIcon.getColor(255, 0, 0, 255, disabled), DatastoreIcon.getColor(255, 0, 0, 0, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.247378f, 0.0f, 0.0f, 1.217947f, -8.576225f, -6.740075f));
        shape = new Rectangle2D.Double(10.988222122192383, 10.97558f, 34.3333740234375, 23.574337005615234);
        g.setPaint(paint);
        g.fill(shape);
        paint = DatastoreIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.2110325f, 0, 0, 4.0f, null, 0.0f);
        shape = new Rectangle2D.Double(10.988222122192383, 10.97558f, 34.3333740234375, 23.574337005615234);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_4;
        g.setTransform(defaultTransform__0_0_4);
        g.setClip(clip__0_0_4);
        float alpha__0_0_5 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_5 = g.getClip();
        AffineTransform defaultTransform__0_0_5 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = DatastoreIcon.getColor(106, 18, 18, 255, disabled);
        shape = new Rectangle2D.Double(20.83461570739746, 23.96451f, 10.27798080444336, 2.779055118560791);
        g.setPaint(paint);
        g.fill(shape);
        paint = DatastoreIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.2485968f, 0, 1, 4.0f, null, 0.0f);
        shape = new Rectangle2D.Double(20.83461570739746, 23.96451f, 10.27798080444336, 2.779055118560791);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_5;
        g.setTransform(defaultTransform__0_0_5);
        g.setClip(clip__0_0_5);
        float alpha__0_0_6 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_6 = g.getClip();
        AffineTransform defaultTransform__0_0_6 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = new LinearGradientPaint(new Point2D.Double(62.02801f, 15.417367935180664), new Point2D.Double(17.210084915161133, 54.31932830810547), new float[]{0.0f, 1.0f}, new Color[]{DatastoreIcon.getColor(255, 0, 0, 255, disabled), DatastoreIcon.getColor(255, 0, 0, 0, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.247378f, 0.0f, 0.0f, 1.217947f, -8.576225f, -6.740075f));
        shape = new Rectangle2D.Double(11.0997f, 36.880062103271484, 34.3333740234375, 23.574337005615234);
        g.setPaint(paint);
        g.fill(shape);
        paint = DatastoreIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.2110325f, 0, 0, 4.0f, null, 0.0f);
        shape = new Rectangle2D.Double(11.0997f, 36.880062103271484, 34.3333740234375, 23.574337005615234);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_6;
        g.setTransform(defaultTransform__0_0_6);
        g.setClip(clip__0_0_6);
        float alpha__0_0_7 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_7 = g.getClip();
        AffineTransform defaultTransform__0_0_7 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = DatastoreIcon.getColor(106, 18, 18, 255, disabled);
        shape = new Rectangle2D.Double(20.94609f, 49.86898422241211, 10.27798080444336, 2.779055118560791);
        g.setPaint(paint);
        g.fill(shape);
        paint = DatastoreIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.2485968f, 0, 1, 4.0f, null, 0.0f);
        shape = new Rectangle2D.Double(20.94609f, 49.86898422241211, 10.27798080444336, 2.779055118560791);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_7;
        g.setTransform(defaultTransform__0_0_7);
        g.setClip(clip__0_0_7);
        float alpha__0_0_8 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_8 = g.getClip();
        AffineTransform defaultTransform__0_0_8 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = new LinearGradientPaint(new Point2D.Double(41.77030944824219, 10.756301879882812), new Point2D.Double(54.14005661010742, 13.62465f), new float[]{0.0f, 1.0f}, new Color[]{DatastoreIcon.getColor(255, 0, 0, 255, disabled), DatastoreIcon.getColor(255, 0, 0, 0, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.247378f, 0.0f, 0.0f, 1.217947f, -8.576225f, -6.740075f));
        shape = new GeneralPath();
        ((GeneralPath)shape).moveTo(48.304417, 9.91852);
        ((GeneralPath)shape).lineTo(55.744846, 2.7131944);
        ((GeneralPath)shape).lineTo(55.744846, 55.423225);
        ((GeneralPath)shape).lineTo(48.369915, 61.973522);
        ((GeneralPath)shape).lineTo(48.304417, 9.91852);
        ((GeneralPath)shape).closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = DatastoreIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.2325734f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        ((GeneralPath)shape).moveTo(48.304417, 9.91852);
        ((GeneralPath)shape).lineTo(55.744846, 2.7131944);
        ((GeneralPath)shape).lineTo(55.744846, 55.423225);
        ((GeneralPath)shape).lineTo(48.369915, 61.973522);
        ((GeneralPath)shape).lineTo(48.304417, 9.91852);
        ((GeneralPath)shape).closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_8;
        g.setTransform(defaultTransform__0_0_8);
        g.setClip(clip__0_0_8);
        float alpha__0_0_9 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_9 = g.getClip();
        AffineTransform defaultTransform__0_0_9 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = new LinearGradientPaint(new Point2D.Double(44.45938491821289, 12.750892639160156), new Point2D.Double(42.84593963623047, 6.25191f), new float[]{0.0f, 1.0f}, new Color[]{DatastoreIcon.getColor(255, 0, 0, 255, disabled), DatastoreIcon.getColor(255, 0, 0, 0, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.247378f, 0.0f, 0.0f, 1.217947f, -8.576225f, -6.740075f));
        shape = new GeneralPath();
        ((GeneralPath)shape).moveTo(18.72678, 1.580513);
        ((GeneralPath)shape).lineTo(55.330357, 1.2717291);
        ((GeneralPath)shape).lineTo(48.043545, 8.392504);
        ((GeneralPath)shape).lineTo(11.150849, 8.23811);
        ((GeneralPath)shape).lineTo(18.72678, 1.580513);
        ((GeneralPath)shape).closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = DatastoreIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(0.8041758f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        ((GeneralPath)shape).moveTo(18.72678, 1.580513);
        ((GeneralPath)shape).lineTo(55.330357, 1.2717291);
        ((GeneralPath)shape).lineTo(48.043545, 8.392504);
        ((GeneralPath)shape).lineTo(11.150849, 8.23811);
        ((GeneralPath)shape).lineTo(18.72678, 1.580513);
        ((GeneralPath)shape).closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_9;
        g.setTransform(defaultTransform__0_0_9);
        g.setClip(clip__0_0_9);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 11;
    }

    public static int getOrigY() {
        return 1;
    }

    public static int getOrigWidth() {
        return 64;
    }

    public static int getOrigHeight() {
        return 64;
    }

    public DatastoreIcon() {
        this(DatastoreIcon.getOrigWidth(), DatastoreIcon.getOrigHeight(), false);
    }

    public DatastoreIcon(boolean disabled) {
        this(DatastoreIcon.getOrigWidth(), DatastoreIcon.getOrigHeight(), disabled);
    }

    public DatastoreIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public DatastoreIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public DatastoreIcon(int width, int height) {
        this(width, height, false);
    }

    public DatastoreIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)DatastoreIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)DatastoreIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        DatastoreIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

