/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.creole.AnnotationVisualResource;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.event.AnnotationEvent;
import gate.event.AnnotationListener;
import gate.gui.MainFrame;
import gate.gui.annedit.AnnotationData;
import gate.gui.annedit.AnnotationDataImpl;
import gate.gui.annedit.AnnotationEditorOwner;
import gate.gui.annedit.OwnedAnnotationEditor;
import gate.gui.docview.AbstractDocumentView;
import gate.gui.docview.AnnotationList;
import gate.gui.docview.DocumentView;
import gate.gui.docview.TextualDocumentView;
import gate.swing.XJTable;
import gate.util.Err;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.JTextComponent;

public class AnnotationListView
extends AbstractDocumentView
implements AnnotationListener,
AnnotationList,
AnnotationEditorOwner {
    protected XJTable table;
    protected AnnotationTableModel tableModel;
    protected JScrollPane scroller;
    protected List<AnnotationData> annDataList = new ArrayList<AnnotationData>();
    protected volatile boolean localSelectionUpdating = false;
    protected JPanel mainPanel;
    protected JLabel statusLabel;
    protected JTextField filterTextField;
    protected TextualDocumentView textView;
    protected Map<String, AnnotationVisualResource> editorsCache = new HashMap<String, AnnotationVisualResource>();
    private static final int TYPE_COL = 0;
    private static final int SET_COL = 1;
    private static final int START_COL = 2;
    private static final int END_COL = 3;
    private static final int ID_COL = 4;
    private static final int FEATURES_COL = 5;

    @Override
    public AnnotationData getAnnotationAtRow(int row) {
        return this.annDataList == null ? null : this.annDataList.get(this.table.rowViewToModel(row));
    }

    @Override
    public ListSelectionModel getSelectionModel() {
        return this.table == null ? null : this.table.getSelectionModel();
    }

    @Override
    public void cleanup() {
        super.cleanup();
        for (AnnotationData aData : this.annDataList) {
            aData.getAnnotation().removeAnnotationListener(this);
        }
        this.annDataList.clear();
        this.textView = null;
    }

    @Override
    protected void initGUI() {
        this.tableModel = new AnnotationTableModel();
        this.table = new XJTable(this.tableModel);
        this.table.setAutoResizeMode(3);
        this.table.setSortable(true);
        this.table.setSortedColumn(2);
        this.table.setIntercellSpacing(new Dimension(2, 0));
        this.table.setEnableHidingColumns(true);
        this.scroller = new JScrollPane(this.table);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridwidth = 4;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.mainPanel.add((Component)this.scroller, constraints);
        constraints.gridx = -1;
        constraints.gridwidth = 1;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        this.statusLabel = new JLabel();
        this.mainPanel.add((Component)this.statusLabel, constraints);
        constraints.fill = 2;
        constraints.anchor = 13;
        this.mainPanel.add(Box.createHorizontalStrut(10), constraints);
        this.mainPanel.add((Component)new JLabel("Select: "), constraints);
        this.filterTextField = new JTextField(20);
        this.filterTextField.setToolTipText("Select the rows containing this text.");
        this.mainPanel.add((Component)this.filterTextField, constraints);
        Iterator<DocumentView> centralViewsIter = this.owner.getCentralViews().iterator();
        while (this.textView == null && centralViewsIter.hasNext()) {
            DocumentView aView = centralViewsIter.next();
            if (!(aView instanceof TextualDocumentView)) continue;
            this.textView = (TextualDocumentView)aView;
        }
        this.initListeners();
    }

    @Override
    public Component getGUI() {
        return this.mainPanel;
    }

    protected void initListeners() {
        this.tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                AnnotationListView.this.statusLabel.setText(Integer.toString(AnnotationListView.this.tableModel.getRowCount()) + " Annotations (" + Integer.toString(AnnotationListView.this.table.getSelectedRowCount()) + " selected)");
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int modelRow;
                if (!AnnotationListView.this.isActive()) {
                    return;
                }
                if (e.getValueIsAdjusting()) {
                    return;
                }
                AnnotationListView.this.statusLabel.setText(Integer.toString(AnnotationListView.this.tableModel.getRowCount()) + " Annotations (" + Integer.toString(AnnotationListView.this.table.getSelectedRowCount()) + " selected)");
                if (AnnotationListView.this.localSelectionUpdating) {
                    return;
                }
                int[] viewRows = AnnotationListView.this.table.getSelectedRows();
                ArrayList<AnnotationData> selAnns = new ArrayList<AnnotationData>();
                for (int i = 0; i < viewRows.length; ++i) {
                    modelRow = AnnotationListView.this.table.rowViewToModel(viewRows[i]);
                    if (modelRow < 0) continue;
                    selAnns.add(AnnotationListView.this.annDataList.get(modelRow));
                }
                AnnotationListView.this.owner.setSelectedAnnotations(selAnns);
                if (AnnotationListView.this.table.getSelectedRowCount() >= 1) {
                    AnnotationData aHandler;
                    int viewRow = AnnotationListView.this.table.getSelectionModel().getLeadSelectionIndex();
                    if (AnnotationListView.this.table.getSelectionModel().isSelectedIndex(viewRow) && (aHandler = AnnotationListView.this.annDataList.get(modelRow = AnnotationListView.this.table.rowViewToModel(viewRow))) != null && aHandler.getAnnotation() != null) {
                        AnnotationListView.this.textView.scrollAnnotationToVisible(aHandler.getAnnotation());
                    }
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                this.processMouseEvent(me);
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                this.processMouseEvent(me);
            }

            @Override
            public void mousePressed(MouseEvent me) {
                int row = AnnotationListView.this.table.rowAtPoint(me.getPoint());
                if (me.isPopupTrigger() && !AnnotationListView.this.table.isRowSelected(row)) {
                    AnnotationListView.this.table.getSelectionModel().setSelectionInterval(row, row);
                }
                this.processMouseEvent(me);
            }

            protected void processMouseEvent(MouseEvent me) {
                int modelRow;
                int viewRow = AnnotationListView.this.table.rowAtPoint(me.getPoint());
                int n = modelRow = viewRow == -1 ? viewRow : AnnotationListView.this.table.rowViewToModel(viewRow);
                if (me.isPopupTrigger()) {
                    JPopupMenu popup = new JPopupMenu();
                    popup.add(new DeleteAction());
                    if (modelRow != -1) {
                        AnnotationData aHandler = AnnotationListView.this.annDataList.get(modelRow);
                        popup.addSeparator();
                        List<Action> specificEditorActions = AnnotationListView.this.getSpecificEditorActions(aHandler.getAnnotationSet(), aHandler.getAnnotation());
                        for (Action action : specificEditorActions) {
                            popup.add(action);
                        }
                        if (!(popup.getComponent(popup.getComponentCount() - 1) instanceof JSeparator)) {
                            popup.addSeparator();
                        }
                        for (Action action : AnnotationListView.this.getGenericEditorActions(aHandler.getAnnotationSet(), aHandler.getAnnotation())) {
                            if (specificEditorActions.contains(action)) continue;
                            popup.add(action);
                        }
                        if (popup.getComponent(popup.getComponentCount() - 1) instanceof JSeparator) {
                            popup.remove(popup.getComponentCount() - 1);
                        }
                    }
                    popup.show(AnnotationListView.this.table, me.getX(), me.getY());
                }
            }
        });
        this.table.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                AnnotationListView.this.tableModel.fireTableDataChanged();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        });
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){
            private Timer timer = new Timer("Annotation list selection timer", true);
            private TimerTask timerTask;

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                if (this.timerTask != null) {
                    this.timerTask.cancel();
                }
                Date timeToRun = new Date(System.currentTimeMillis() + 300L);
                this.timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        this.selectRows();
                    }
                };
                this.timer.schedule(this.timerTask, timeToRun);
            }

            private void selectRows() {
                AnnotationListView.this.table.clearSelection();
                if (AnnotationListView.this.filterTextField.getText().trim().length() < 2 || AnnotationListView.this.table.getRowCount() == 0) {
                    return;
                }
                AnnotationListView.this.localSelectionUpdating = true;
                block0: for (int row = 0; row < AnnotationListView.this.table.getRowCount(); ++row) {
                    for (int col = 0; col < AnnotationListView.this.table.getColumnCount(); ++col) {
                        if (AnnotationListView.this.table.getValueAt(row, col) == null || !AnnotationListView.this.table.getValueAt(row, col).toString().contains(AnnotationListView.this.filterTextField.getText().trim())) continue;
                        AnnotationListView.this.table.addRowSelectionInterval(row, row);
                        continue block0;
                    }
                }
                AnnotationListView.this.localSelectionUpdating = false;
                if (AnnotationListView.this.table.isCellSelected(0, 0)) {
                    AnnotationListView.this.table.addRowSelectionInterval(0, 0);
                } else {
                    AnnotationListView.this.table.removeRowSelectionInterval(0, 0);
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    new DeleteAction().actionPerformed(new ActionEvent(e.getSource(), e.getID(), "", e.getWhen(), e.getModifiers()));
                }
            }
        });
    }

    public List<Action> getSpecificEditorActions(AnnotationSet set, Annotation annotation) {
        ArrayList<Action> actions = new ArrayList<Action>();
        List<String> specificEditorClasses = Gate.getCreoleRegister().getAnnotationVRs(annotation.getType());
        if (specificEditorClasses != null && specificEditorClasses.size() > 0) {
            for (String editorClass : specificEditorClasses) {
                AnnotationVisualResource editor = this.editorsCache.get(editorClass);
                if (editor == null) {
                    try {
                        editor = (AnnotationVisualResource)Factory.createResource(editorClass);
                        this.editorsCache.put(editorClass, editor);
                    }
                    catch (ResourceInstantiationException rie) {
                        rie.printStackTrace(Err.getPrintWriter());
                    }
                }
                actions.add(new EditAnnotationAction(set, annotation, editor));
            }
        }
        return actions;
    }

    public List<Action> getGenericEditorActions(AnnotationSet set, Annotation annotation) {
        ArrayList<Action> actions = new ArrayList<Action>();
        List<String> genericEditorClasses = Gate.getCreoleRegister().getAnnotationVRs();
        if (genericEditorClasses != null && genericEditorClasses.size() > 0) {
            for (String editorClass : genericEditorClasses) {
                AnnotationVisualResource editor = this.editorsCache.get(editorClass);
                if (editor == null) {
                    try {
                        ResourceData resData = (ResourceData)Gate.getCreoleRegister().get(editorClass);
                        Class<? extends Resource> resClass = resData.getResourceClass();
                        if (OwnedAnnotationEditor.class.isAssignableFrom(resClass)) {
                            OwnedAnnotationEditor newEditor = (OwnedAnnotationEditor)resClass.newInstance();
                            newEditor.setOwner(this);
                            newEditor.init();
                            editor = newEditor;
                        } else {
                            editor = (AnnotationVisualResource)Factory.createResource(editorClass);
                        }
                        this.editorsCache.put(editorClass, editor);
                    }
                    catch (Exception rie) {
                        rie.printStackTrace(Err.getPrintWriter());
                    }
                }
                actions.add(new EditAnnotationAction(set, annotation, editor));
            }
        }
        return actions;
    }

    @Override
    protected void registerHooks() {
    }

    @Override
    protected void unregisterHooks() {
    }

    @Override
    public int getType() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnnotationDataImpl addAnnotation(Annotation ann, AnnotationSet set) {
        AnnotationDataImpl aData = new AnnotationDataImpl(set, ann);
        this.annDataList.add(aData);
        int row = this.annDataList.size() - 1;
        try {
            this.localSelectionUpdating = true;
            if (this.tableModel != null) {
                this.tableModel.fireTableRowsInserted(row, row);
            }
        }
        finally {
            this.localSelectionUpdating = false;
        }
        aData.getAnnotation().addAnnotationListener(this);
        return aData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotation(AnnotationData tag) {
        int row = this.annDataList.indexOf(tag);
        if (row >= 0) {
            AnnotationData aHandler = this.annDataList.get(row);
            List<AnnotationData> selAnns = this.owner.getSelectedAnnotations();
            if (selAnns.remove(tag)) {
                this.owner.setSelectedAnnotations(selAnns);
            }
            aHandler.getAnnotation().removeAnnotationListener(this);
            this.annDataList.remove(row);
            try {
                this.localSelectionUpdating = true;
                if (this.tableModel != null) {
                    this.tableModel.fireTableRowsDeleted(row, row);
                }
            }
            finally {
                this.localSelectionUpdating = false;
            }
        }
    }

    public void removeAnnotations(Collection<AnnotationData> tags) {
        if (this.table != null) {
            this.table.getSelectionModel().clearSelection();
        }
        final List<AnnotationData> selAnns = this.owner.getSelectedAnnotations();
        boolean selectionChanged = false;
        for (AnnotationData aData : tags) {
            this.annDataList.remove(aData);
            if (selAnns.remove(aData)) {
                selectionChanged = true;
            }
            aData.getAnnotation().removeAnnotationListener(this);
        }
        if (this.tableModel != null) {
            this.tableModel.fireTableDataChanged();
        }
        if (selectionChanged) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AnnotationListView.this.owner.setSelectedAnnotations(selAnns);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AnnotationData> addAnnotations(List<Annotation> annotations, AnnotationSet set) {
        ArrayList<AnnotationData> tags = new ArrayList<AnnotationData>();
        for (Annotation ann : annotations) {
            AnnotationDataImpl aTag = new AnnotationDataImpl(set, ann);
            tags.add(aTag);
            this.annDataList.add(aTag);
            ann.addAnnotationListener(this);
        }
        try {
            this.localSelectionUpdating = true;
            if (this.tableModel != null) {
                this.tableModel.fireTableDataChanged();
            }
        }
        finally {
            this.localSelectionUpdating = false;
        }
        return tags;
    }

    public List<AnnotationData> getAllAnnotations() {
        return this.annDataList;
    }

    @Override
    public void annotationUpdated(AnnotationEvent e) {
        int i;
        if (this.table == null) {
            return;
        }
        int[] selection = this.table.getSelectedRows();
        if (selection != null) {
            this.localSelectionUpdating = true;
        }
        Annotation ann = (Annotation)e.getSource();
        if (this.tableModel != null) {
            for (i = 0; i < this.annDataList.size(); ++i) {
                AnnotationData aHandler = this.annDataList.get(i);
                if (aHandler.getAnnotation() != ann) continue;
                this.tableModel.fireTableRowsUpdated(i, i);
            }
        }
        this.table.clearSelection();
        if (selection != null) {
            this.localSelectionUpdating = true;
            for (i = 0; i < selection.length; ++i) {
                this.table.addRowSelectionInterval(selection[i], selection[i]);
            }
            this.localSelectionUpdating = false;
        }
    }

    @Override
    public void setSelectedAnnotations(final List<AnnotationData> selectedAnnots) {
        int[] viewRows = this.table.getSelectedRows();
        ArrayList<AnnotationData> localSelAnns = new ArrayList<AnnotationData>();
        for (int viewRow : viewRows) {
            int modelRow = this.table.rowViewToModel(viewRow);
            if (modelRow < 0) continue;
            localSelAnns.add(this.annDataList.get(modelRow));
        }
        if (localSelAnns.size() == selectedAnnots.size()) {
            localSelAnns.removeAll(selectedAnnots);
            if (localSelAnns.isEmpty()) {
                return;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AnnotationListView.this.localSelectionUpdating = true;
                    AnnotationListView.this.table.getSelectionModel().clearSelection();
                    int rowToScrollTo = -1;
                    for (AnnotationData aData : selectedAnnots) {
                        int modelRow = AnnotationListView.this.annDataList.indexOf(aData);
                        if (modelRow == -1) continue;
                        int viewRow = AnnotationListView.this.table.rowModelToView(modelRow);
                        AnnotationListView.this.table.getSelectionModel().addSelectionInterval(viewRow, viewRow);
                        rowToScrollTo = viewRow;
                    }
                    if (rowToScrollTo >= 0) {
                        AnnotationListView.this.table.scrollRectToVisible(AnnotationListView.this.table.getCellRect(rowToScrollTo, 0, true));
                    }
                }
                finally {
                    AnnotationListView.this.localSelectionUpdating = false;
                }
            }
        });
    }

    public void selectAnnotationForTag(Object tag) {
        int modelPosition = this.annDataList.indexOf(tag);
        this.table.getSelectionModel().clearSelection();
        if (modelPosition != -1) {
            int tablePosition = this.table.rowModelToView(modelPosition);
            this.table.getSelectionModel().setSelectionInterval(tablePosition, tablePosition);
            this.table.scrollRectToVisible(this.table.getCellRect(tablePosition, 0, false));
        }
    }

    @Override
    public void annotationChanged(Annotation ann, AnnotationSet set, String oldType) {
    }

    @Override
    public Annotation getNextAnnotation() {
        return null;
    }

    @Override
    public Annotation getPreviousAnnotation() {
        return null;
    }

    @Override
    public JTextComponent getTextComponent() {
        Iterator<DocumentView> centralViewsIter = this.owner.getCentralViews().iterator();
        while (this.textView == null && centralViewsIter.hasNext()) {
            DocumentView aView = centralViewsIter.next();
            if (!(aView instanceof TextualDocumentView)) continue;
            this.textView = (TextualDocumentView)aView;
        }
        return (JTextArea)((JScrollPane)this.textView.getGUI()).getViewport().getView();
    }

    @Override
    public void selectAnnotation(AnnotationData data) {
    }

    @Override
    public int getRowForAnnotation(AnnotationData data) {
        return this.annDataList.indexOf(data);
    }

    protected class EditAnnotationAction
    extends AbstractAction {
        String title;
        Annotation ann;
        AnnotationSet set;
        AnnotationVisualResource editor;

        public EditAnnotationAction(AnnotationSet set, Annotation ann, AnnotationVisualResource editor) {
            this.set = set;
            this.ann = ann;
            this.editor = editor;
            ResourceData rData = (ResourceData)Gate.getCreoleRegister().get(editor.getClass().getName());
            if (rData != null) {
                this.title = rData.getName();
                this.putValue("Name", "Edit with " + this.title);
                this.putValue("ShortDescription", rData.getComment());
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (this.editor instanceof OwnedAnnotationEditor) {
                ((OwnedAnnotationEditor)this.editor).setPinnedMode(false);
                ((OwnedAnnotationEditor)this.editor).placeDialog(this.ann.getStartNode().getOffset().intValue(), this.ann.getEndNode().getOffset().intValue());
                ((OwnedAnnotationEditor)this.editor).setPinnedMode(true);
                this.editor.editAnnotation(this.ann, this.set);
            } else {
                this.editor.editAnnotation(this.ann, this.set);
                JScrollPane scroller = new JScrollPane((Component)((Object)this.editor));
                JOptionPane optionPane = new JOptionPane(scroller, 3, 2, null, new String[]{"OK", "Cancel"});
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                scroller.setMaximumSize(new Dimension((int)((double)screenSize.width * 0.75), (int)((double)screenSize.height * 0.75)));
                JDialog dialog = optionPane.createDialog(AnnotationListView.this.getGUI(), this.title);
                dialog.setModal(true);
                dialog.setResizable(true);
                dialog.setVisible(true);
                try {
                    if (optionPane.getValue().equals("OK")) {
                        this.editor.okAction();
                    } else {
                        this.editor.cancelAction();
                    }
                }
                catch (GateException ge) {
                    throw new GateRuntimeException(ge);
                }
            }
        }
    }

    class AnnotationTableModel
    extends AbstractTableModel {
        AnnotationTableModel() {
        }

        @Override
        public int getRowCount() {
            return AnnotationListView.this.annDataList.size();
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Type";
                }
                case 1: {
                    return "Set";
                }
                case 2: {
                    return "Start";
                }
                case 3: {
                    return "End";
                }
                case 4: {
                    return "Id";
                }
                case 5: {
                    return "Features";
                }
            }
            return "?";
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Long.class;
                }
                case 3: {
                    return Long.class;
                }
                case 4: {
                    return Integer.class;
                }
                case 5: {
                    return String.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row >= AnnotationListView.this.annDataList.size()) {
                return null;
            }
            AnnotationData aData = AnnotationListView.this.annDataList.get(row);
            switch (column) {
                case 0: {
                    return aData.getAnnotation().getType();
                }
                case 1: {
                    return aData.getAnnotationSet().getName();
                }
                case 2: {
                    return aData.getAnnotation().getStartNode().getOffset();
                }
                case 3: {
                    return aData.getAnnotation().getEndNode().getOffset();
                }
                case 4: {
                    return aData.getAnnotation().getId();
                }
                case 5: {
                    FeatureMap features = aData.getAnnotation().getFeatures();
                    ArrayList keyList = new ArrayList(features.keySet());
                    Collections.sort(keyList);
                    StringBuffer strBuf = new StringBuffer("{");
                    Iterator keyIter = keyList.iterator();
                    boolean first = true;
                    while (keyIter.hasNext()) {
                        Object key = keyIter.next();
                        Object value = features.get(key);
                        if (first) {
                            first = false;
                        } else {
                            strBuf.append(", ");
                        }
                        strBuf.append(key.toString());
                        strBuf.append("=");
                        strBuf.append(value == null ? "[null]" : value.toString());
                    }
                    strBuf.append("}");
                    return strBuf.toString();
                }
            }
            return "?";
        }
    }

    protected class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super("Delete Annotations");
            this.putValue("ShortDescription", "Delete selected annotations");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int choice;
            if ((event.getModifiers() & 1) != 1 && (event.getModifiers() & 0x10) != 16 && ((choice = JOptionPane.showOptionDialog(MainFrame.getInstance(), new Object[]{"Are you sure you want to delete the " + AnnotationListView.this.table.getSelectedRowCount() + " selected annotations?", "<html><i>You can use Shift+Delete to bypass this dialog.</i>\n\n"}, "Delete annotations", -1, 3, null, new String[]{"Delete annotations", "Cancel"}, "Cancel")) == -1 || choice == 1)) {
                return;
            }
            ArrayList<AnnotationData> annotationsData = new ArrayList<AnnotationData>();
            for (int selectedRow : AnnotationListView.this.table.getSelectedRows()) {
                annotationsData.add(AnnotationListView.this.annDataList.get(AnnotationListView.this.table.rowViewToModel(selectedRow)));
            }
            Object object = annotationsData.iterator();
            while (object.hasNext()) {
                AnnotationData annotationData = (AnnotationData)object.next();
                annotationData.getAnnotationSet().remove(annotationData.getAnnotation());
            }
        }
    }
}

