/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.search.Explanation;
import gate.creole.annic.apache.lucene.search.HitCollector;
import gate.creole.annic.apache.lucene.search.Scorer;
import gate.creole.annic.apache.lucene.search.Searcher;
import gate.creole.annic.apache.lucene.search.Similarity;
import java.io.IOException;

final class BooleanScorer
extends Scorer {
    private SubScorer scorers = null;
    private BucketTable bucketTable = new BucketTable(this);
    private int maxCoord = 1;
    private float[] coordFactors = null;
    private int requiredMask = 0;
    private int prohibitedMask = 0;
    private int nextMask = 1;
    private int end;
    private Bucket current;

    BooleanScorer(Similarity similarity) {
        super(similarity);
    }

    final void add(Scorer scorer, boolean required, boolean prohibited) throws IOException {
        int mask = 0;
        if (required || prohibited) {
            if (this.nextMask == 0) {
                throw new IndexOutOfBoundsException("More than 32 required/prohibited clauses in query.");
            }
            mask = this.nextMask;
            this.nextMask <<= 1;
        } else {
            mask = 0;
        }
        if (!prohibited) {
            ++this.maxCoord;
        }
        if (prohibited) {
            this.prohibitedMask |= mask;
        } else if (required) {
            this.requiredMask |= mask;
        }
        this.scorers = new SubScorer(scorer, required, prohibited, this.bucketTable.newCollector(mask), this.scorers);
    }

    private final void computeCoordFactors() throws IOException {
        this.coordFactors = new float[this.maxCoord];
        for (int i = 0; i < this.maxCoord; ++i) {
            this.coordFactors[i] = this.getSimilarity().coord(i, this.maxCoord - 1);
        }
    }

    @Override
    public int doc() {
        return this.current.doc;
    }

    @Override
    public boolean next(Searcher searcher) throws IOException {
        this.searcher = searcher;
        while (true) {
            if (this.bucketTable.first != null) {
                this.current = this.bucketTable.first;
                this.bucketTable.first = this.current.next;
                if ((this.current.bits & this.prohibitedMask) != 0 || (this.current.bits & this.requiredMask) != this.requiredMask) continue;
                return true;
            }
            boolean more = false;
            this.end += 1024;
            SubScorer sub = this.scorers;
            while (sub != null) {
                Scorer scorer = sub.scorer;
                while (!sub.done && scorer.doc() < this.end) {
                    sub.collector.collect(scorer.doc(), scorer.score(this.searcher));
                    sub.done = !scorer.next(this.searcher);
                }
                if (!sub.done) {
                    more = true;
                }
                sub = sub.next;
            }
            if (!(this.bucketTable.first != null | more)) break;
        }
        return false;
    }

    @Override
    public float score(Searcher searcher) throws IOException {
        this.searcher = searcher;
        if (this.coordFactors == null) {
            this.computeCoordFactors();
        }
        return this.current.score * this.coordFactors[this.current.coord];
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Explanation explain(int doc) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("boolean(");
        SubScorer sub = this.scorers;
        while (sub != null) {
            buffer.append(sub.scorer.toString());
            buffer.append(" ");
            sub = sub.next;
        }
        buffer.append(")");
        return buffer.toString();
    }

    static final class Collector
    extends HitCollector {
        private BucketTable bucketTable;
        private int mask;

        public Collector(int mask, BucketTable bucketTable) {
            this.mask = mask;
            this.bucketTable = bucketTable;
        }

        @Override
        public final void collect(int doc, float score) {
            BucketTable table = this.bucketTable;
            int i = doc & 0x3FF;
            Bucket bucket = table.buckets[i];
            if (bucket == null) {
                table.buckets[i] = bucket = new Bucket();
            }
            if (bucket.doc != doc) {
                bucket.doc = doc;
                bucket.score = score;
                bucket.bits = this.mask;
                bucket.coord = 1;
                bucket.next = table.first;
                table.first = bucket;
            } else {
                bucket.score += score;
                bucket.bits |= this.mask;
                ++bucket.coord;
            }
        }
    }

    static final class BucketTable {
        public static final int SIZE = 1024;
        public static final int MASK = 1023;
        final Bucket[] buckets = new Bucket[1024];
        Bucket first = null;
        private BooleanScorer scorer;

        public BucketTable(BooleanScorer scorer) {
            this.scorer = scorer;
        }

        public final int size() {
            return 1024;
        }

        public HitCollector newCollector(int mask) {
            return new Collector(mask, this);
        }
    }

    static final class Bucket {
        int doc = -1;
        float score;
        int bits;
        int coord;
        Bucket next;

        Bucket() {
        }
    }

    static final class SubScorer {
        public Scorer scorer;
        public boolean done;
        public boolean required = false;
        public boolean prohibited = false;
        public HitCollector collector;
        public SubScorer next;
        protected Searcher searcher;

        public SubScorer(Scorer scorer, boolean required, boolean prohibited, HitCollector collector, SubScorer next) throws IOException {
            this.searcher = scorer.searcher;
            this.scorer = scorer;
            this.done = !scorer.next(this.searcher);
            this.required = required;
            this.prohibited = prohibited;
            this.collector = collector;
            this.next = next;
        }
    }
}

