/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Controller;
import gate.Factory;
import gate.Gate;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.AbstractController;
import gate.creole.AbstractResource;
import gate.creole.CustomDuplication;
import gate.creole.ExecutionException;
import gate.creole.ExecutionInterruptedException;
import gate.creole.Parameter;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleResource;
import gate.event.ControllerEvent;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.event.StatusListener;
import gate.util.Benchmark;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.profile.Profiler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CreoleResource(name="Pipeline", comment="A simple serial controller for PR pipelines.", helpURL="http://gate.ac.uk/userguide/sec:developer:apps")
public class SerialController
extends AbstractController
implements CreoleListener,
CustomDuplication {
    private static final long serialVersionUID = 5865826535505675541L;
    protected static final Logger log = LoggerFactory.getLogger(SerialController.class);
    protected Profiler prof;
    protected Map<String, Long> timeMap;
    protected Map<String, Long> prTimeMap;
    protected List<ProcessingResource> prList = Collections.synchronizedList(new ArrayList());
    protected StatusListener sListener = new AbstractController.InternalStatusListener();

    public SerialController() {
        this.prTimeMap = new HashMap<String, Long>();
        if (log.isDebugEnabled()) {
            this.prof = new Profiler();
            this.prof.enableGCCalling(false);
            this.prof.printToSystemOut(true);
            this.timeMap = new HashMap<String, Long>();
        }
        Gate.getCreoleRegister().addCreoleListener(this);
    }

    public List<ProcessingResource> getPRs() {
        return Collections.unmodifiableList(this.prList);
    }

    @Override
    public void setPRs(Collection<? extends ProcessingResource> prs) {
        this.prList.clear();
        Iterator<? extends ProcessingResource> prIter = prs.iterator();
        while (prIter.hasNext()) {
            this.add(prIter.next());
        }
    }

    public void add(int index, ProcessingResource pr) {
        this.prList.add(index, pr);
        this.fireResourceAdded(new ControllerEvent(this, 0, pr));
    }

    public void add(ProcessingResource pr) {
        this.prList.add(pr);
        this.fireResourceAdded(new ControllerEvent(this, 0, pr));
    }

    public ProcessingResource remove(int index) {
        ProcessingResource aPr = this.prList.remove(index);
        this.fireResourceRemoved(new ControllerEvent(this, 1, aPr));
        return aPr;
    }

    public boolean remove(ProcessingResource pr) {
        boolean ret = this.prList.remove(pr);
        if (ret) {
            this.fireResourceRemoved(new ControllerEvent(this, 1, pr));
        }
        return ret;
    }

    public ProcessingResource set(int index, ProcessingResource pr) {
        return this.prList.set(index, pr);
    }

    protected void checkParameters() throws ExecutionException {
        List<ProcessingResource> badPRs;
        try {
            badPRs = this.getOffendingPocessingResources();
        }
        catch (ResourceInstantiationException rie) {
            throw new ExecutionException("Could not check runtime parameters for the processing resources:\n" + rie.toString());
        }
        if (badPRs != null && !badPRs.isEmpty()) {
            throw new ExecutionException("Some of the processing resources in this controller have unset runtime parameters:\n" + badPRs.toString());
        }
    }

    @Override
    protected void executeImpl() throws ExecutionException {
        this.checkParameters();
        if (log.isDebugEnabled()) {
            this.prof.initRun("Execute controller [" + this.getName() + "]");
        }
        this.interrupted = false;
        for (int i = 0; i < this.prList.size(); ++i) {
            if (this.isInterrupted()) {
                throw new ExecutionInterruptedException("The execution of the " + this.getName() + " application has been abruptly interrupted!");
            }
            this.runComponent(i);
            if (!log.isDebugEnabled()) continue;
            this.prof.checkPoint("~Execute PR [" + this.prList.get(i).getName() + "]");
            Long timeOfPR = this.timeMap.get(this.prList.get(i).getName());
            if (timeOfPR == null) {
                this.timeMap.put(this.prList.get(i).getName(), this.prof.getLastDuration());
            } else {
                this.timeMap.put(this.prList.get(i).getName(), timeOfPR + this.prof.getLastDuration());
            }
            log.debug("Time taken so far by " + this.prList.get(i).getName() + ": " + this.timeMap.get(this.prList.get(i).getName()));
        }
        if (log.isDebugEnabled()) {
            this.prof.checkPoint("Execute controller [" + this.getName() + "] finished");
        }
        this.fireStatusChanged("Finished running " + this.getName());
    }

    public void resetPrTimeMap() {
        this.prTimeMap.clear();
    }

    public Map<String, Long> getPrTimeMap() {
        return this.prTimeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runComponent(int componentIndex) throws ExecutionException {
        ProcessingResource currentPR = this.prList.get(componentIndex);
        HashMap<String, EventListener> listeners = new HashMap<String, EventListener>();
        listeners.put("gate.event.StatusListener", this.sListener);
        int componentProgress = 100 / this.prList.size();
        listeners.put("gate.event.ProgressListener", new AbstractController.IntervalProgressListener(componentIndex * componentProgress, (componentIndex + 1) * componentProgress));
        try {
            AbstractResource.setResourceListeners(currentPR, listeners);
        }
        catch (Exception e) {
            log.error("Could not set listeners for " + currentPR.getClass().getName() + "\n" + e.toString() + "\n...nothing to lose any sleep over.");
        }
        try {
            this.benchmarkFeatures.put("prName", currentPR.getName());
            long startTime = System.currentTimeMillis();
            Benchmark.executeWithBenchmarking(currentPR, Benchmark.createBenchmarkId("pr_" + currentPR.getName(), this.getBenchmarkId()), this, this.benchmarkFeatures);
            this.benchmarkFeatures.remove("prName");
            long timeTakenByThePR = System.currentTimeMillis() - startTime;
            Long time = this.prTimeMap.get(currentPR.getName());
            if (time == null) {
                time = 0L;
            }
            time = time + timeTakenByThePR;
            this.prTimeMap.put(currentPR.getName(), time);
        }
        finally {
            try {
                AbstractResource.removeResourceListeners(currentPR, listeners);
            }
            catch (Exception e) {
                log.error("Could not clear listeners for " + currentPR.getClass().getName() + "\n" + e.toString() + "\n...nothing to lose any sleep over.");
            }
        }
    }

    @Override
    public void cleanup() {
        Gate.getCreoleRegister().removeCreoleListener(this);
        if (this.prList != null && !this.prList.isEmpty()) {
            try {
                List<Resource> allOtherControllers = Gate.getCreoleRegister().getAllInstances("gate.Controller");
                allOtherControllers.remove(this);
                ArrayList<ProcessingResource> prsInOtherControllers = new ArrayList<ProcessingResource>();
                for (Resource aController : allOtherControllers) {
                    prsInOtherControllers.addAll(((Controller)aController).getPRs());
                }
                for (Resource aPr : new ArrayList(this.getPRs())) {
                    if (prsInOtherControllers.contains(aPr)) continue;
                    Factory.deleteResource(aPr);
                }
            }
            catch (GateException gateException) {
                // empty catch block
            }
        }
    }

    @Override
    public Resource duplicate(Factory.DuplicationContext ctx) throws ResourceInstantiationException {
        Controller c = (Controller)Factory.defaultDuplicate(this, ctx);
        ArrayList<ProcessingResource> newPRs = new ArrayList<ProcessingResource>();
        for (ProcessingResource pr : this.prList) {
            newPRs.add((ProcessingResource)Factory.duplicate(pr, ctx));
        }
        c.setPRs(newPRs);
        return c;
    }

    @Override
    public void resourceLoaded(CreoleEvent e) {
    }

    @Override
    public void resourceUnloaded(CreoleEvent e) {
        if (e.getResource() instanceof ProcessingResource) {
            while (this.remove((ProcessingResource)e.getResource())) {
            }
        }
        for (int i = 0; i < this.prList.size(); ++i) {
            ProcessingResource aPr = this.prList.get(i);
            ResourceData rData = (ResourceData)Gate.getCreoleRegister().get(aPr.getClass().getName());
            if (rData == null) continue;
            for (List<Parameter> aDisjunction : rData.getParameterList().getRuntimeParameters()) {
                for (Parameter aParam : aDisjunction) {
                    String paramName = aParam.getName();
                    try {
                        if (aPr.getParameterValue(paramName) != e.getResource()) continue;
                        aPr.setParameterValue(paramName, null);
                    }
                    catch (ResourceInstantiationException rie) {
                        throw new GateRuntimeException(rie);
                    }
                }
            }
        }
    }

    @Override
    public void resourceRenamed(Resource resource, String oldName, String newName) {
    }

    @Override
    public void datastoreOpened(CreoleEvent e) {
    }

    @Override
    public void datastoreCreated(CreoleEvent e) {
    }

    @Override
    public void datastoreClosed(CreoleEvent e) {
    }
}

