/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Gate;
import gate.creole.Plugin;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceReference
implements Serializable {
    private static final long serialVersionUID = 2526144106607856721L;
    protected static final Logger log = LoggerFactory.getLogger(ResourceReference.class);
    private URI uri;

    public ResourceReference(URL url) throws URISyntaxException {
        this.uri = url.toURI();
        if (!this.uri.isAbsolute()) {
            throw new URISyntaxException(this.uri.toString(), "We only support absolute URIs");
        }
        if ("jar".equals(this.uri.getScheme())) {
            try {
                String[] parts = url.toExternalForm().split("!");
                URL base = new URL(parts[0] + "!/");
                for (Plugin plugin : Gate.getCreoleRegister().getPlugins()) {
                    if (!plugin.getBaseURL().equals(base)) continue;
                    this.uri = plugin.getBaseURI().resolve(parts[1]);
                }
            }
            catch (MalformedURLException e) {
                throw new URISyntaxException(this.uri.toString(), "Error normalizing plugin based URL");
            }
        }
    }

    public ResourceReference(URI uri) throws URISyntaxException {
        this.uri = uri;
        if (!uri.isAbsolute()) {
            throw new URISyntaxException(uri.toString(), "We only support absolute URIs");
        }
    }

    public ResourceReference(Plugin plugin, String path) throws URISyntaxException {
        if (path == null) {
            path = "";
        }
        path = path.trim();
        this.uri = plugin != null ? plugin.getBaseURI().resolve(path) : new URI(path);
        if (!this.uri.isAbsolute()) {
            throw new URISyntaxException(path, "We only support absolute URIs");
        }
    }

    public ResourceReference(ResourceReference context, String path) throws URISyntaxException {
        path = path.trim();
        this.uri = context != null ? context.uri.resolve(path) : new URI(path);
        if (!this.uri.isAbsolute()) {
            throw new URISyntaxException(path, "We only support absolute URIs");
        }
    }

    public InputStream openStream() throws IOException {
        return this.toURL().openStream();
    }

    public URLConnection openConnection() throws IOException {
        return this.toURL().openConnection();
    }

    public URL toURL() throws IOException {
        if (!this.uri.getScheme().equals("creole")) {
            return this.uri.toURL();
        }
        try {
            URI base = new URI("creole", this.uri.getAuthority(), "/", null, null);
            for (Plugin plugin : Gate.getCreoleRegister().getPlugins()) {
                if (!plugin.getBaseURI().equals(base)) continue;
                String path = this.uri.getPath();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                return new URL(plugin.getBaseURL(), path);
            }
        }
        catch (URISyntaxException e) {
            log.debug("An impossible exception case happened, how?", (Throwable)e);
        }
        throw new IOException("Unable to locate URI: " + this.uri);
    }

    public URI toURI() {
        return this.uri;
    }

    public String toString() {
        return this.uri.toString();
    }

    public String toExternalForm() {
        return this.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceReference other = (ResourceReference)obj;
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

