/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora.export;

import gate.Document;
import gate.DocumentExporter;
import gate.FeatureMap;
import gate.corpora.DocumentStaxUtils;
import gate.creole.metadata.AutoInstance;
import gate.creole.metadata.CreoleResource;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;

@CreoleResource(name="GATE XML Exporter", tool=true, autoinstances={@AutoInstance}, icon="GATEXML")
public class GateXMLExporter
extends DocumentExporter {
    private static final long serialVersionUID = -5725505758491779035L;

    public GateXMLExporter() {
        super("GATE XML", "xml", "text/xml");
    }

    @Override
    public void export(Document doc, File file, FeatureMap options) throws IOException {
        super.export(doc, file, options);
        doc.setSourceUrl(file.toURI().toURL());
    }

    @Override
    public void export(Document doc, OutputStream out, FeatureMap options) throws IOException {
        try {
            DocumentStaxUtils.writeDocument(doc, out, "");
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }
}

