/*
 * Decompiled with CFR 0.152.
 */
package gate.util.profile;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Profiler {
    protected static final Logger log = LoggerFactory.getLogger(Profiler.class);
    private boolean m_enabled = true;
    private boolean m_garbageCollection = true;
    private boolean m_doPrintToStdOut = true;
    private Map<String, Long> m_categorySums;
    private Map<String, Long> m_categoryLasts;
    private Runtime m_rt = Runtime.getRuntime();
    private long m_startTime;
    private long m_lastCheckTime;
    private long m_profilerTime;
    private long m_lastDuration;
    private long m_maxMemory;
    private long m_currMemory;
    private long m_diffMemory;

    public void enable(boolean isEnabled) {
        this.m_enabled = isEnabled;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void enableGCCalling(boolean collect) {
        this.m_garbageCollection = collect;
    }

    public boolean isGCCallingEnabled() {
        return this.m_garbageCollection;
    }

    public long getProfilerTime() {
        return this.m_profilerTime;
    }

    public long getNetRunTime() {
        return this.m_lastCheckTime - this.m_profilerTime;
    }

    public long getRunDuration() {
        return this.m_lastCheckTime;
    }

    public long getLastDuration() {
        return this.m_lastDuration;
    }

    public String initRun(String runDescription) {
        StringBuffer buf = new StringBuffer();
        buf.append("-----------------------------------------------\n");
        buf.append("New profiler run: " + runDescription);
        buf.append("\n-----------------------------------------------\n");
        this.m_maxMemory = 0L;
        this.m_currMemory = 0L;
        this.m_diffMemory = 0L;
        this.m_profilerTime = 0L;
        this.m_startTime = System.currentTimeMillis();
        this.m_lastCheckTime = 0L;
        this.m_lastDuration = 0L;
        this.m_categorySums = new HashMap<String, Long>();
        this.m_categoryLasts = new HashMap<String, Long>();
        if (this.m_doPrintToStdOut) {
            log.debug(buf.toString());
        }
        return buf.toString();
    }

    public String checkPoint(String execPointDescr) {
        return this.checkPoint(execPointDescr, new String[0], true, true, true);
    }

    public String checkPoint(String execPointDescr, String[] categories, boolean showDescr, boolean showStats, boolean memoryCheck) {
        if (!this.m_enabled) {
            return "";
        }
        long currTime = System.currentTimeMillis() - this.m_startTime;
        this.m_lastDuration = currTime - this.m_lastCheckTime;
        if (memoryCheck) {
            long oldMemory = this.m_currMemory;
            if (this.m_garbageCollection) {
                do {
                    this.m_currMemory = this.m_rt.totalMemory() - this.m_rt.freeMemory();
                    this.m_rt.gc();
                    try {
                        this.wait(300L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.m_rt.gc();
                } while (this.m_currMemory > this.m_rt.totalMemory() - this.m_rt.freeMemory());
            } else {
                this.m_currMemory = this.m_rt.totalMemory() - this.m_rt.freeMemory();
            }
            this.m_currMemory /= 1000L;
            this.m_maxMemory = Math.max(this.m_maxMemory, this.m_currMemory);
            this.m_diffMemory = this.m_currMemory - oldMemory;
        }
        this.m_lastCheckTime = System.currentTimeMillis() - this.m_startTime;
        this.m_profilerTime += this.m_lastCheckTime - currTime;
        this.checkCategories(categories);
        return this.showResults(execPointDescr, showDescr, showStats);
    }

    private void checkCategories(String[] categs) {
        int size = categs.length;
        for (int i = 0; i < size; ++i) {
            String categ = categs[i].toUpperCase();
            Long l = this.m_categorySums.get(categ);
            long sum = l == null ? 0L : l;
            this.m_categorySums.put(categ, new Long(sum += this.m_lastDuration));
            this.m_categoryLasts.put(categ, new Long(this.m_lastDuration));
        }
    }

    private String showResults(String execPointDescr, boolean showDescr, boolean showStats) {
        StringBuffer buff = new StringBuffer(500);
        if (showDescr) {
            buff.append("---------LOG: ");
            buff.append(execPointDescr);
            buff.append("---------");
        }
        if (showStats) {
            buff.append("\nMemory: ");
            buff.append(this.m_currMemory);
            buff.append("k; change: ");
            buff.append(this.m_diffMemory);
            buff.append("k; max: ");
            buff.append(this.m_maxMemory);
            buff.append("k; Net time:   ");
            buff.append(this.printTime(this.getNetRunTime()));
            buff.append("; since prev. millisecs: ");
            buff.append(this.m_lastDuration);
        }
        if (buff.length() > 0 && this.m_doPrintToStdOut) {
            log.debug(buff.toString());
        }
        return buff.toString();
    }

    public long getCategoryTimeSum(String category) {
        Long sum = this.m_categorySums.get(category.toUpperCase());
        return sum == null ? 0L : sum;
    }

    public long getCategoryTimeLast(String category) {
        Long sum = this.m_categoryLasts.get(category.toUpperCase());
        return sum == null ? 0L : sum;
    }

    public void showCategoryTimes() {
        log.debug("Time spent by categories:");
        for (String categ : this.m_categorySums.keySet()) {
            this.showCategoryTime(categ);
        }
    }

    public void showCategoryTime(String categ) {
        log.debug(categ + ", sum=" + this.printTime(this.getCategoryTimeSum(categ)) + ", last=" + this.printTime(this.getCategoryTimeLast(categ)));
    }

    public String printTime(long timeMillis) {
        long round = timeMillis / 1000L;
        long remaind = timeMillis % 1000L / 10L;
        StringBuffer buff = new StringBuffer(10);
        buff.append(round);
        buff.append(".");
        buff.append(remaind);
        buff.append("s");
        return buff.toString();
    }

    public String printSpeed(long timeMillis, double whatever, String whateverMeasure) {
        double speed1000 = whatever / (double)timeMillis;
        long round = (long)(speed1000 * 1000.0);
        long remaind = (long)(speed1000 * 100000.0 - (double)(100L * round));
        StringBuffer buff = new StringBuffer(10);
        buff.append(round);
        buff.append(".");
        buff.append(remaind);
        buff.append(whateverMeasure);
        buff.append("/s");
        return buff.toString();
    }

    public void printCategAvg(String categ, long items, double volume, String whateverMeasure) {
        long time = this.getCategoryTimeSum(categ);
        if (time == 0L) {
            log.debug("Category \"" + categ + "\" not found");
        }
        log.debug("Category \"" + categ + "\",  Time= " + this.printTime(time) + "; avg. time= " + this.printTime(time / items) + "; speed= " + this.printSpeed(time, volume, whateverMeasure));
    }

    public void printToSystemOut(boolean doPrint) {
        this.m_doPrintToStdOut = doPrint;
    }
}

