/*
 * Decompiled with CFR 0.152.
 */
package gate.util.ant.packager;

import gate.util.BomStrippingInputStreamReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResourceIterator;

public class GazetteerLists
extends DataType
implements ResourceCollection {
    private File definition;
    private String encoding = null;
    private String[] listNames = null;

    public void setDefinition(File definition) {
        this.definition = definition;
    }

    public Iterator<Resource> iterator() {
        this.load();
        if (this.listNames.length == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new FileResourceIterator(this.getProject(), this.definition.getParentFile(), this.listNames);
    }

    public boolean isFilesystemOnly() {
        return true;
    }

    public int size() {
        this.load();
        return this.listNames.length;
    }

    private void load() {
        this.log("Listing gazetteer lists", 3);
        if (this.definition == null) {
            throw new BuildException("\"definition\" attribute is required for gazetteerlists");
        }
        this.log("definition file: " + this.definition, 3);
        HashSet<String> lists = new HashSet<String>();
        try (BomStrippingInputStreamReader in = new BomStrippingInputStreamReader((InputStream)new FileInputStream(this.definition), this.encoding != null ? this.encoding : Charset.defaultCharset().name());){
            String line;
            while ((line = ((BufferedReader)in).readLine()) != null) {
                int indexOfColon = line.indexOf(58);
                if (indexOfColon <= 0) continue;
                String listFile = line.substring(0, indexOfColon);
                lists.add(listFile);
                this.log("Found list file " + listFile, 3);
            }
        }
        catch (IOException ioe) {
            throw new BuildException("Error reading gazetteer definition file " + this.definition, (Throwable)ioe);
        }
        this.listNames = lists.toArray(new String[lists.size()]);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

