/*
 * Decompiled with CFR 0.152.
 */
package gate.swing;

import gate.Gate;
import gate.creole.Plugin;
import gate.event.PluginListener;
import gate.resources.img.svg.GATEIcon;
import gate.resources.img.svg.InvalidIcon;
import gate.swing.XJFileChooser;
import gate.util.ExtensionFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceReferenceChooser
implements PluginListener,
TreeWillExpandListener {
    private static final Logger log = LoggerFactory.getLogger(ResourceReferenceChooser.class);
    private static final int ERROR = -1;
    private static final int CANCEL = 0;
    private static final int APPROVE_FILE = 1;
    private static final int APPROVE_RESOURCE = 2;
    private final InvalidIcon invalidIcon = new InvalidIcon(16, 16);
    private XJFileChooser fileChooser = new XJFileChooser();
    private JOptionPane pluginChooser;
    private JLabel pluginChooserStatus;
    private JComboBox<PluginFileFilter> pluginFileFilterBox;
    private JTree pluginTree;
    private DefaultTreeModel pluginTreeModel;
    private DefaultMutableTreeNode treeRoot;
    private JTabbedPane tabPane = new JTabbedPane();
    private boolean isResourceSelected = false;
    private int returnValue = -1;
    private JDialog dialog;
    private static Comparator<Plugin.Maven> PLUGIN_COMPARATOR = Comparator.comparing(Plugin.Maven::getName).thenComparing(Plugin.Maven::getGroup).thenComparing(Plugin.Maven::getArtifact).thenComparing(Plugin::getVersion);

    public ResourceReferenceChooser() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.fileChooser, "Center");
        this.tabPane.addTab("File", panel);
        this.fileChooser.addActionListener(e -> {
            this.returnValue = "ApproveSelection".equals(e.getActionCommand()) ? 1 : 0;
            if (this.dialog != null) {
                this.dialog.setVisible(false);
            }
        });
        this.tabPane.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 2L) != 0L && !ResourceReferenceChooser.this.tabPane.isDisplayable()) {
                    ResourceReferenceChooser.this.isResourceSelected = false;
                    ResourceReferenceChooser.this.setSuffixes(null);
                }
            }
        });
        JPanel pluginPanel = new JPanel(new BorderLayout());
        this.pluginChooserStatus = new JLabel("Select a resource");
        this.pluginChooserStatus.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pluginPanel.add((Component)this.pluginChooserStatus, "North");
        this.pluginFileFilterBox = new JComboBox();
        this.pluginFileFilterBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Box fileTypeBox = Box.createHorizontalBox();
        fileTypeBox.add(Box.createHorizontalGlue());
        JLabel ffLabel = new JLabel("File format:");
        ffLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        fileTypeBox.add(ffLabel);
        fileTypeBox.add(this.pluginFileFilterBox);
        fileTypeBox.add(Box.createHorizontalGlue());
        pluginPanel.add((Component)fileTypeBox, "South");
        this.pluginFileFilterBox.addActionListener(e -> this.pluginTree.repaint());
        this.treeRoot = new DefaultMutableTreeNode();
        this.pluginTreeModel = new DefaultTreeModel(this.treeRoot);
        this.pluginTree = new JTree(this.pluginTreeModel);
        this.pluginTree.getSelectionModel().setSelectionMode(1);
        this.pluginTree.setRootVisible(false);
        this.pluginTree.setShowsRootHandles(true);
        this.pluginTree.setCellRenderer(new Renderer());
        JScrollPane treeScroller = new JScrollPane(this.pluginTree);
        pluginPanel.add((Component)treeScroller, "Center");
        this.pluginChooser = new JOptionPane(pluginPanel, -1, 2);
        this.pluginChooser.addPropertyChangeListener("value", e -> {
            block8: {
                if (this.dialog != null && e.getNewValue() instanceof Integer) {
                    if ((Integer)e.getNewValue() == 0) {
                        if (this.pluginTree.getSelectionCount() > 0) {
                            try {
                                String selected = ((AsUri)this.pluginTree.getSelectionPath().getLastPathComponent()).getAsURI();
                                if (((PluginFileFilter)this.pluginFileFilterBox.getSelectedItem()).pattern.matcher(selected).find()) {
                                    this.returnValue = 2;
                                    this.dialog.setVisible(false);
                                    break block8;
                                }
                                this.pluginChooser.setValue(JOptionPane.UNINITIALIZED_VALUE);
                                this.pluginChooserStatus.setIcon(this.invalidIcon);
                                this.pluginChooserStatus.setText("Selected resource does not have the right suffix");
                            }
                            catch (URISyntaxException ex) {
                                this.pluginChooser.setValue(JOptionPane.UNINITIALIZED_VALUE);
                                this.pluginChooserStatus.setIcon(this.invalidIcon);
                                this.pluginChooserStatus.setText("Error extracting selected resource from tree");
                            }
                        } else {
                            this.pluginChooser.setValue(JOptionPane.UNINITIALIZED_VALUE);
                            this.pluginChooserStatus.setIcon(this.invalidIcon);
                            this.pluginChooserStatus.setText("Nothing selected - please select a resource");
                        }
                    } else {
                        this.returnValue = 0;
                        this.dialog.setVisible(false);
                    }
                }
            }
        });
        this.tabPane.addTab("Plugin resource", this.pluginChooser);
        this.refreshTreeForPlugins();
        this.pluginTree.expandPath(new TreePath(this.treeRoot));
        this.pluginTree.addTreeWillExpandListener(this);
        this.pluginTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath selPath;
                if (e.getClickCount() == 2 && (selPath = ResourceReferenceChooser.this.pluginTree.getPathForLocation(e.getX(), e.getY())) != null && ((DefaultMutableTreeNode)selPath.getLastPathComponent()).isLeaf()) {
                    ResourceReferenceChooser.this.pluginChooser.setValue(0);
                }
            }
        });
        Gate.getCreoleRegister().addPluginListener(this);
        this.setSuffixes(null);
    }

    private void refreshTreeForPlugins() {
        List mavenPluginsWithResources = Gate.getCreoleRegister().getPlugins().stream().filter(p -> p instanceof Plugin.Maven && p.hasResources()).map(p -> (Plugin.Maven)p).sorted(PLUGIN_COMPARATOR).collect(Collectors.toList());
        Enumeration<TreeNode> nodes = this.treeRoot.children();
        Iterator listIt = mavenPluginsWithResources.iterator();
        Plugin.Maven curPlug = listIt.hasNext() ? (Plugin.Maven)listIt.next() : null;
        ArrayList<Integer> indicesToRemove = new ArrayList<Integer>(this.treeRoot.getChildCount());
        ArrayList<PluginTreeNode> nodesToRemove = new ArrayList<PluginTreeNode>(this.treeRoot.getChildCount());
        int i = 0;
        while (nodes.hasMoreElements()) {
            PluginTreeNode n = (PluginTreeNode)nodes.nextElement();
            Plugin.Maven nodePlugin = (Plugin.Maven)n.getUserObject();
            int cmp = -1;
            while (curPlug != null && (cmp = PLUGIN_COMPARATOR.compare(nodePlugin, curPlug)) > 0) {
                curPlug = listIt.hasNext() ? (Plugin.Maven)listIt.next() : null;
            }
            if (cmp < 0) {
                indicesToRemove.add(i);
                nodesToRemove.add(n);
            }
            ++i;
        }
        if (indicesToRemove.size() > 0) {
            ListIterator indicesIt = indicesToRemove.listIterator(indicesToRemove.size());
            while (indicesIt.hasPrevious()) {
                this.treeRoot.remove((Integer)indicesIt.previous());
            }
            this.pluginTreeModel.nodesWereRemoved(this.treeRoot, indicesToRemove.stream().mapToInt(j -> j).toArray(), nodesToRemove.toArray());
        }
        nodes = this.treeRoot.children();
        listIt = mavenPluginsWithResources.iterator();
        PluginTreeNode curNode = nodes.hasMoreElements() ? (PluginTreeNode)nodes.nextElement() : null;
        ArrayList<Integer> indicesToAdd = new ArrayList<Integer>(mavenPluginsWithResources.size());
        ArrayList<PluginTreeNode> nodesToAdd = new ArrayList<PluginTreeNode>(mavenPluginsWithResources.size());
        i = 0;
        while (listIt.hasNext()) {
            Plugin.Maven p2 = (Plugin.Maven)listIt.next();
            int cmp = -1;
            while (curNode != null && (cmp = PLUGIN_COMPARATOR.compare(p2, (Plugin.Maven)curNode.getUserObject())) > 0) {
                curNode = nodes.hasMoreElements() ? (PluginTreeNode)nodes.nextElement() : null;
                ++i;
            }
            if (cmp >= 0 && curNode != null) continue;
            indicesToAdd.add(i);
            nodesToAdd.add(new PluginTreeNode(p2, 0));
            ++i;
        }
        if (indicesToAdd.size() > 0) {
            Iterator indicesIt = indicesToAdd.iterator();
            Iterator nodesIt = nodesToAdd.iterator();
            while (indicesIt.hasNext()) {
                this.treeRoot.insert((MutableTreeNode)nodesIt.next(), (Integer)indicesIt.next());
            }
            this.pluginTreeModel.nodesWereInserted(this.treeRoot, indicesToAdd.stream().mapToInt(j -> j).toArray());
        }
        for (int d = 0; d < 3; ++d) {
            HashMap<String, List> groupByDesc = new HashMap<String, List>();
            nodes = this.treeRoot.children();
            while (nodes.hasMoreElements()) {
                PluginTreeNode n = (PluginTreeNode)nodes.nextElement();
                groupByDesc.computeIfAbsent(n.toString(), k -> new ArrayList()).add(n);
            }
            boolean anyDups = false;
            for (Map.Entry entry : groupByDesc.entrySet()) {
                if (((List)entry.getValue()).size() <= 1) continue;
                anyDups = true;
                for (PluginTreeNode groupNode : (List)entry.getValue()) {
                    ++groupNode.nameDepth;
                }
            }
        }
    }

    public void setResource(String resource) {
        this.fileChooser.setResource(resource);
    }

    public String getResource() {
        return this.fileChooser.getResource();
    }

    public void setSelectedResource(String uriStr) {
        try {
            URI uri = new URI(uriStr);
            if ("creole".equals(uri.getScheme())) {
                String path = uri.getPath();
                URI pluginBaseUri = uri.resolve("/");
                PluginTreeNode pluginNode = null;
                Enumeration<TreeNode> pluginNodes = this.treeRoot.children();
                while (pluginNodes.hasMoreElements()) {
                    PluginTreeNode n = (PluginTreeNode)pluginNodes.nextElement();
                    URI bu = ((Plugin.Maven)n.getUserObject()).getBaseURI();
                    if (!bu.equals(pluginBaseUri)) continue;
                    pluginNode = n;
                    break;
                }
                if (pluginNode != null) {
                    this.pluginTree.expandPath(new TreePath(new Object[]{this.treeRoot, pluginNode}));
                    DefaultMutableTreeNode nearestNode = pluginNode;
                    LinkedList<PluginResourceTreeNode> nodesToTry = new LinkedList<PluginResourceTreeNode>();
                    Enumeration<TreeNode> children = pluginNode.children();
                    while (children.hasMoreElements()) {
                        nodesToTry.add((PluginResourceTreeNode)children.nextElement());
                    }
                    ListIterator<PluginResourceTreeNode> iter = nodesToTry.listIterator();
                    while (iter.hasNext()) {
                        PluginResourceTreeNode n = (PluginResourceTreeNode)iter.next();
                        if (!path.startsWith(n.getFullPath())) continue;
                        nearestNode = n;
                        int stepsBack = 0;
                        children = n.children();
                        while (children.hasMoreElements()) {
                            iter.add((PluginResourceTreeNode)children.nextElement());
                            ++stepsBack;
                        }
                        for (int i = 0; i < stepsBack; ++i) {
                            iter.previous();
                        }
                    }
                    Object[] pathToRoot = nearestNode.getPath();
                    for (int i = 1; i < pathToRoot.length; ++i) {
                        DefaultMutableTreeNode n = (DefaultMutableTreeNode)pathToRoot[i];
                        Enumeration<? extends TreeNode> siblings = n.getParent().children();
                        while (siblings.hasMoreElements()) {
                            DefaultMutableTreeNode sib = (DefaultMutableTreeNode)siblings.nextElement();
                            if (sib == n) continue;
                            this.pluginTree.collapsePath(new TreePath(sib.getPath()));
                        }
                    }
                    this.pluginTree.expandPath(new TreePath(Arrays.copyOf(pathToRoot, pathToRoot.length - 1)));
                    TreePath selPath = new TreePath(pathToRoot);
                    this.pluginTree.setSelectionPath(selPath);
                    this.pluginTree.scrollPathToVisible(selPath);
                    this.tabPane.setSelectedIndex(1);
                    this.isResourceSelected = true;
                }
            } else if ("file".equals(uri.getScheme())) {
                this.fileChooser.setSelectedFile(new File(uri));
                this.tabPane.setSelectedIndex(0);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public void setSuffixes(Collection<String> suffixes) {
        this.setSuffixes(suffixes == null ? null : "Known file types " + suffixes.toString(), suffixes);
    }

    public void setSuffixes(String description, Collection<String> suffixes) {
        this.fileChooser.resetChoosableFileFilters();
        this.fileChooser.setAcceptAllFileFilterUsed(true);
        this.fileChooser.setFileFilter(this.fileChooser.getAcceptAllFileFilter());
        this.pluginFileFilterBox.removeAllItems();
        PluginFileFilter allFilter = new PluginFileFilter();
        allFilter.pattern = Pattern.compile("");
        allFilter.description = "All files";
        this.pluginFileFilterBox.addItem(allFilter);
        this.pluginFileFilterBox.setSelectedItem(allFilter);
        if (suffixes != null && !suffixes.isEmpty()) {
            ExtensionFileFilter fileFilter = new ExtensionFileFilter();
            suffixes.forEach(suf -> fileFilter.addExtension((String)suf));
            fileFilter.setDescription(description);
            this.fileChooser.addChoosableFileFilter(fileFilter);
            this.fileChooser.setFileFilter(fileFilter);
            PluginFileFilter suffixFilter = new PluginFileFilter();
            suffixFilter.description = description;
            suffixFilter.pattern = Pattern.compile("(?:" + suffixes.stream().map(Pattern::quote).collect(Collectors.joining("|")) + ")$");
            this.pluginFileFilterBox.addItem(suffixFilter);
            this.pluginFileFilterBox.setSelectedItem(suffixFilter);
        }
    }

    public String showDialog(Window parent, String title) {
        if (this.dialog != null) {
            throw new IllegalStateException("ResourceReferenceChooser dialog already showing");
        }
        this.fileChooser.setSelectedFileFromPreferences();
        if (!this.isResourceSelected) {
            this.tabPane.setSelectedIndex(0);
            String resourceClass = this.getResource();
            if (resourceClass != null) {
                Enumeration<TreeNode> nodes = this.treeRoot.children();
                while (nodes.hasMoreElements()) {
                    PluginTreeNode node = (PluginTreeNode)nodes.nextElement();
                    Plugin.Maven plugin = (Plugin.Maven)node.getUserObject();
                    if (plugin.getResourceInfoList().stream().anyMatch(ri -> resourceClass.equals(ri.getResourceClassName()))) {
                        TreePath path = new TreePath(node.getPath());
                        this.pluginTree.setSelectionPath(path);
                        this.pluginTree.expandPath(path);
                        this.pluginTree.scrollPathToVisible(path);
                        break;
                    }
                    Enumeration<TreeNode> descendants = node.postorderEnumeration();
                    while (descendants.hasMoreElements()) {
                        this.pluginTree.collapsePath(new TreePath(((DefaultMutableTreeNode)descendants.nextElement()).getPath()));
                    }
                }
            }
        }
        this.dialog = new JDialog(parent, title, Dialog.DEFAULT_MODALITY_TYPE);
        try {
            Object selected;
            this.pluginChooser.setValue(JOptionPane.UNINITIALIZED_VALUE);
            this.pluginChooserStatus.setIcon(null);
            this.pluginChooserStatus.setText("Select a resource");
            this.dialog.setDefaultCloseOperation(1);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ResourceReferenceChooser.this.returnValue = 0;
                }
            });
            this.returnValue = -1;
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.getContentPane().add((Component)this.tabPane, "Center");
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(parent);
            this.dialog.setVisible(true);
            if (this.returnValue == 2) {
                String string;
                selected = this.pluginTree.getSelectionPath();
                if (selected == null) {
                    string = null;
                    return string;
                }
                string = ((AsUri)((TreePath)selected).getLastPathComponent()).getAsURI();
                return string;
            }
            if (this.returnValue == 1) {
                selected = this.fileChooser.getSelectedFile().toURI().toString();
                return selected;
            }
            selected = null;
            return selected;
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.dialog.getContentPane().removeAll();
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    @Override
    public void pluginLoaded(Plugin plugin) {
        SwingUtilities.invokeLater(this::refreshTreeForPlugins);
    }

    @Override
    public void pluginUnloaded(Plugin plugin) {
        SwingUtilities.invokeLater(this::refreshTreeForPlugins);
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) {
        DefaultMutableTreeNode expandingNode = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        if (expandingNode instanceof PluginTreeNode) {
            try {
                ((PluginTreeNode)expandingNode).expanding();
            }
            catch (IOException | URISyntaxException e) {
                log.warn("Error processing resources for plugin " + expandingNode.getUserObject(), (Throwable)e);
            }
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) {
    }

    static class PluginFileFilter {
        Pattern pattern;
        String description;

        PluginFileFilter() {
        }

        public String toString() {
            return this.description;
        }
    }

    class Renderer
    extends DefaultTreeCellRenderer {
        private Icon pluginIcon;

        Renderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel renderer = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof PluginTreeNode) {
                renderer.setEnabled(true);
                renderer.setIcon(this.pluginIcon);
            } else if (value instanceof PluginResourceTreeNode) {
                PluginResourceTreeNode node = (PluginResourceTreeNode)value;
                if (!node.isLeaf() || ((PluginFileFilter)((ResourceReferenceChooser)ResourceReferenceChooser.this).pluginFileFilterBox.getSelectedItem()).pattern.matcher(node.fullPath).find()) {
                    renderer.setEnabled(true);
                } else {
                    Icon icon = renderer.getIcon();
                    LookAndFeel laf = UIManager.getLookAndFeel();
                    Icon disabledIcon = laf.getDisabledIcon(tree, icon);
                    if (disabledIcon != null) {
                        icon = disabledIcon;
                    }
                    renderer.setDisabledIcon(icon);
                    renderer.setEnabled(false);
                }
            }
            return renderer;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            Icon defaultIcon = this.getDefaultClosedIcon();
            this.pluginIcon = new GATEIcon(defaultIcon == null ? 16 : defaultIcon.getIconWidth(), defaultIcon == null ? 16 : defaultIcon.getIconHeight());
        }
    }

    static class PluginResourceTreeNode
    extends DefaultMutableTreeNode
    implements Comparable<PluginResourceTreeNode>,
    AsUri {
        private Plugin.Maven plugin;
        private String fullPath;
        private boolean directory;

        PluginResourceTreeNode(Plugin.Maven plugin, String fullPath, String myName, boolean directory) {
            super(myName);
            this.directory = directory;
            this.plugin = plugin;
            this.fullPath = fullPath;
        }

        public String getFullPath() {
            return this.fullPath;
        }

        @Override
        public String getAsURI() throws URISyntaxException {
            URI pluginBase = this.plugin.getBaseURI();
            return new URI(pluginBase.getScheme(), pluginBase.getAuthority(), this.fullPath, null, null).toString();
        }

        @Override
        public boolean isLeaf() {
            return !this.directory;
        }

        @Override
        public int compareTo(PluginResourceTreeNode other) {
            return ((String)this.getUserObject()).compareToIgnoreCase((String)other.getUserObject());
        }
    }

    static class PluginTreeNode
    extends DefaultMutableTreeNode
    implements AsUri {
        int nameDepth = 0;
        boolean hasExpanded = false;

        public PluginTreeNode(Plugin.Maven plugin, int nameDepth) {
            super(plugin, true);
            this.nameDepth = nameDepth;
        }

        @Override
        public String getAsURI() throws URISyntaxException {
            return ((Plugin)this.getUserObject()).getBaseURI().toString();
        }

        @Override
        public String toString() {
            Plugin.Maven p = (Plugin.Maven)this.getUserObject();
            if (this.nameDepth == 0) {
                return p.getName();
            }
            if (this.nameDepth == 1) {
                return p.getName() + " (" + p.getVersion() + ")";
            }
            if (this.nameDepth == 2) {
                return p.getName() + " (" + p.getArtifact() + ":" + p.getVersion() + ")";
            }
            return p.getName() + " (" + p.getGroup() + ":" + p.getArtifact() + ":" + p.getVersion() + ")";
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        void expanding() throws IOException, URISyntaxException {
            if (this.hasExpanded) {
                return;
            }
            this.hasExpanded = true;
            final Plugin.Maven thisPlugin = (Plugin.Maven)this.getUserObject();
            final LinkedList<PluginTreeNode> nodeStack = new LinkedList<PluginTreeNode>();
            final LinkedList childLists = new LinkedList();
            nodeStack.addLast(this);
            childLists.addLast(new ArrayList());
            thisPlugin.walkResources((FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (dir.getNameCount() > 1) {
                        String sep = dir.getFileSystem().getSeparator();
                        String name = dir.getFileName().toString();
                        if (name.endsWith(sep)) {
                            name = name.substring(0, name.length() - sep.length());
                        }
                        PluginResourceTreeNode dirNode = new PluginResourceTreeNode(thisPlugin, dir.toString(), name, true);
                        ((List)childLists.getLast()).add(dirNode);
                        childLists.addLast(new ArrayList());
                        nodeStack.addLast(dirNode);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    PluginResourceTreeNode fileNode = new PluginResourceTreeNode(thisPlugin, file.toString(), file.getFileName().toString(), false);
                    ((List)childLists.getLast()).add(fileNode);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    List children = (List)childLists.removeLast();
                    DefaultMutableTreeNode thisDirNode = (DefaultMutableTreeNode)nodeStack.removeLast();
                    Collections.sort(children);
                    for (DefaultMutableTreeNode node : children) {
                        thisDirNode.add(node);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    static interface AsUri {
        public String getAsURI() throws URISyntaxException;
    }
}

