/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class RIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        GeneralPath shape = null;
        Color paint = null;
        Object stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -0.0f, -0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 48.0, 48.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, -1004.3622f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        shape = new GeneralPath();
        shape.moveTo(43.063755, 1044.3622);
        shape.lineTo(35.1536, 1044.3622);
        shape.lineTo(26.554966, 1035.7196);
        shape.lineTo(14.9827, 1035.7196);
        shape.lineTo(14.9827, 1030.4169);
        shape.lineTo(29.382114, 1030.4169);
        shape.quadTo(32.355747, 1030.4169, 34.37723, 1029.1132);
        shape.quadTo(36.677036, 1027.5751, 36.677036, 1024.7479);
        shape.quadTo(36.677036, 1018.97644, 29.382114, 1018.97644);
        shape.lineTo(11.833286, 1018.97644);
        shape.lineTo(11.833286, 1044.3622);
        shape.lineTo(6.4866066, 1044.3622);
        shape.lineTo(6.4866066, 1013.62976);
        shape.lineTo(28.532505, 1013.62976);
        shape.quadTo(34.47977, 1013.62976, 38.112583, 1016.19324);
        shape.quadTo(42.302036, 1019.1229, 42.302036, 1024.7919);
        shape.quadTo(42.302036, 1028.659, 39.870396, 1031.4423);
        shape.quadTo(37.629185, 1034.0643, 33.74735, 1035.0897);
        shape.lineTo(43.063755, 1044.3622);
        shape.closePath();
        paint = RIcon.getColor(255, 0, 0, 255, disabled);
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 7;
    }

    public static int getOrigY() {
        return 10;
    }

    public static int getOrigWidth() {
        return 48;
    }

    public static int getOrigHeight() {
        return 48;
    }

    public RIcon() {
        this(RIcon.getOrigWidth(), RIcon.getOrigHeight(), false);
    }

    public RIcon(boolean disabled) {
        this(RIcon.getOrigWidth(), RIcon.getOrigHeight(), disabled);
    }

    public RIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public RIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public RIcon(int width, int height) {
        this(width, height, false);
    }

    public RIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)RIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)RIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        RIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

