/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class GATEIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        GeneralPath shape = null;
        Color paint = null;
        Object stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -0.0f, -0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 64.0, 64.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.25f, 0.0f, 0.0f, -1.25f, 0.0f, 64.00001f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GATEIcon.getColor(0, 150, 65, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(48.9632, 17.84605);
        shape.lineTo(48.9632, 28.515894);
        shape.lineTo(23.987465, 28.515894);
        shape.lineTo(23.987465, 20.059998);
        shape.lineTo(38.55523, 20.059998);
        shape.curveTo(36.811333, 14.757246, 32.853947, 11.734123, 27.146854, 11.734123);
        shape.curveTo(18.887589, 11.734123, 13.918179, 16.834469, 13.918179, 25.564705);
        shape.curveTo(13.918179, 33.75296, 18.821907, 38.989586, 26.206768, 38.989586);
        shape.curveTo(30.503284, 38.989586, 33.722546, 37.311363, 35.46644, 34.157776);
        shape.lineTo(48.15939, 34.157776);
        shape.curveTo(45.67245, 43.821846, 37.483334, 49.600006, 26.206766, 49.600006);
        shape.curveTo(12.109046, 49.600006, 2.2367992, 39.662483, 2.2367992, 25.564707);
        shape.curveTo(2.2367992, 11.466929, 12.17428, 1.6000061, 26.272001, 1.6000061);
        shape.curveTo(38.691505, 1.6000061, 46.547302, 9.722582, 48.9632, 17.84605);
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 3;
    }

    public static int getOrigY() {
        return 2;
    }

    public static int getOrigWidth() {
        return 64;
    }

    public static int getOrigHeight() {
        return 64;
    }

    public GATEIcon() {
        this(GATEIcon.getOrigWidth(), GATEIcon.getOrigHeight(), false);
    }

    public GATEIcon(boolean disabled) {
        this(GATEIcon.getOrigWidth(), GATEIcon.getOrigHeight(), disabled);
    }

    public GATEIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public GATEIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public GATEIcon(int width, int height) {
        this(width, height, false);
    }

    public GATEIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)GATEIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)GATEIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        GATEIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

