/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.persistence;

import gate.gui.AlternatingTableCellEditor;
import gate.gui.MainFrame;
import gate.persist.PersistenceException;
import gate.resources.img.svg.GreenBallIcon;
import gate.resources.img.svg.InvalidIcon;
import gate.resources.img.svg.OpenFileIcon;
import gate.resources.img.svg.RedBallIcon;
import gate.resources.img.svg.SaveIcon;
import gate.resources.img.svg.YellowBallIcon;
import gate.swing.XJFileChooser;
import gate.swing.XJTable;
import gate.util.ExtensionFileFilter;
import gate.util.persistence.PersistenceManager;
import gate.util.persistence.UpgradeXGAPP;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XgappUpgradeSelector
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(XgappUpgradeSelector.class);
    private List<UpgradeXGAPP.UpgradePath> upgrades;
    private URI gappUri;
    private EnumMap<UpgradeXGAPP.UpgradePath.UpgradeStrategy, Icon> strategyIcons;
    private Icon disabledStrategyIcon;
    private JLabel statusLabel;
    private JPanel mainPanel;
    private Icon warningIcon = new InvalidIcon(16, 16);
    private UpgradePathTableModel model;

    public XgappUpgradeSelector(URI gappUri, List<UpgradeXGAPP.UpgradePath> upgrades) {
        this.gappUri = gappUri;
        this.upgrades = upgrades;
        this.model = new UpgradePathTableModel(upgrades);
        this.strategyIcons = new EnumMap(UpgradeXGAPP.UpgradePath.UpgradeStrategy.class);
        this.strategyIcons.put(UpgradeXGAPP.UpgradePath.UpgradeStrategy.UPGRADE, new GreenBallIcon(16, 16));
        this.strategyIcons.put(UpgradeXGAPP.UpgradePath.UpgradeStrategy.PLUGIN_ONLY, new YellowBallIcon(16, 16));
        this.strategyIcons.put(UpgradeXGAPP.UpgradePath.UpgradeStrategy.SKIP, new RedBallIcon(16, 16));
        this.disabledStrategyIcon = new RedBallIcon(16, 16, true);
        XJTable pluginTable = new XJTable(this.model);
        pluginTable.setAutoResizeMode(4);
        JScrollPane scroller = new JScrollPane(pluginTable);
        this.statusLabel = new JLabel("Select plugin versions to upgrade to");
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)this.statusLabel, "Center");
        Box buttonBox = Box.createHorizontalBox();
        JButton loadButton = new JButton();
        loadButton.setIcon(new OpenFileIcon(24, 24));
        loadButton.setToolTipText("Load a saved upgrade script");
        loadButton.setActionCommand("LOADSCRIPT");
        loadButton.addActionListener(this);
        buttonBox.add(loadButton);
        buttonBox.add(Box.createHorizontalStrut(5));
        JButton saveButton = new JButton();
        saveButton.setIcon(new SaveIcon(24, 24));
        saveButton.setToolTipText("Save selected upgrades as a script");
        saveButton.setActionCommand("SAVESCRIPT");
        saveButton.addActionListener(this);
        buttonBox.add(saveButton);
        topPanel.add((Component)buttonBox, "South");
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)topPanel, "North");
        this.mainPanel.add((Component)scroller, "Center");
        DefaultTableCellRenderer newPluginRenderer = new DefaultTableCellRenderer();
        newPluginRenderer.setToolTipText("Double-click or press the space key to change");
        pluginTable.getColumnModel().getColumn(1).setCellRenderer(newPluginRenderer);
        pluginTable.getColumnModel().getColumn(2).setCellRenderer(new UpgradeStrategyRenderer());
        pluginTable.getColumnModel().getColumn(3).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                label.setEnabled(((UpgradeXGAPP.UpgradePath.UpgradeStrategy)((Object)table.getValueAt((int)row, (int)2))).upgradePlugin);
                return label;
            }
        });
        pluginTable.getColumnModel().getColumn(1).setCellEditor(new PluginCoordinatesEditor());
        pluginTable.getColumnModel().getColumn(2).setCellEditor(new AlternatingTableCellEditor(new UpgradeStrategyEditor(), new UpgradeStrategyEditor()));
        pluginTable.getColumnModel().getColumn(3).setCellEditor(new AlternatingTableCellEditor(new UpgradeVersionEditor(), new UpgradeVersionEditor()));
        this.model.fireTableDataChanged();
    }

    public boolean showDialog(Window parent) {
        JOptionPane optionPane = new JOptionPane(this.mainPanel, -1, 2);
        JDialog dialog = optionPane.createDialog(parent, "Select plugin versions");
        dialog.setResizable(true);
        dialog.setVisible(true);
        return (Integer)optionPane.getValue() == 0;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        XJFileChooser fileChooser = MainFrame.getFileChooser();
        fileChooser.setResource("xgappUpgradeScript");
        fileChooser.setFileSelectionMode(0);
        ExtensionFileFilter filter = new ExtensionFileFilter("Tab-separated values", ".tsv");
        fileChooser.resetChoosableFileFilters();
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.setFileFilter(filter);
        if ("SAVESCRIPT".equals(event.getActionCommand())) {
            fileChooser.setDialogTitle("Save upgrade script");
            int result = fileChooser.showSaveDialog(this.mainPanel);
            if (result == 0) {
                try {
                    UpgradeXGAPP.saveUpgradePaths(this.model.upgrades, this.gappUri, fileChooser.getSelectedFile());
                }
                catch (IOException e) {
                    log.error("Error writing upgrade script", (Throwable)e);
                    this.statusLabel.setIcon(this.warningIcon);
                    this.statusLabel.setText("Couldn't save upgrade script, see messages pane for details");
                }
            }
        } else if ("LOADSCRIPT".equals(event.getActionCommand())) {
            fileChooser.setDialogTitle("Select upgrade script to load");
            int result = fileChooser.showOpenDialog(this.mainPanel);
            if (result == 0) {
                try {
                    UpgradeXGAPP.loadUpgradePaths(this.model.upgrades, this.gappUri, fileChooser.getSelectedFile());
                    this.model.fireTableDataChanged();
                }
                catch (IOException e) {
                    log.error("Error reading upgrade script", (Throwable)e);
                    this.statusLabel.setIcon(this.warningIcon);
                    this.statusLabel.setText("Couldn't load upgrade script, see messages pane for details");
                }
            }
        }
    }

    protected static class PluginCoordinates {
        String groupId;
        String artifactId;

        public PluginCoordinates(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public String toString() {
            if (this.groupId == null) {
                return "<html><body><em>&lt;unknown&gt;</em></body></html>";
            }
            if ("uk.ac.gate.plugins".equals(this.groupId)) {
                return this.artifactId;
            }
            return this.groupId + ":" + this.artifactId;
        }
    }

    protected class PluginCoordinatesEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        TableCellRenderer renderer = new DefaultTableCellRenderer();
        JPanel mainPanel;
        JTextField groupIdField;
        JTextField artifactIdField;
        PluginCoordinates selected = null;

        PluginCoordinatesEditor() {
            GridBagLayout layout = new GridBagLayout();
            this.mainPanel = new JPanel(layout);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(5, 5, 5, 5);
            JLabel label = new JLabel("Please enter Maven co-ordinates of new plugin");
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 10;
            c.weightx = 0.0;
            c.gridwidth = 2;
            this.mainPanel.add(label);
            layout.setConstraints(label, c);
            c.anchor = 21;
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 1;
            label = new JLabel("Group ID");
            this.mainPanel.add(label);
            layout.setConstraints(label, c);
            c.gridx = 1;
            c.weightx = 1.0;
            this.groupIdField = new JTextField(30);
            this.mainPanel.add(this.groupIdField);
            layout.setConstraints(this.groupIdField, c);
            c.gridx = 0;
            c.gridy = 2;
            c.weightx = 0.0;
            label = new JLabel("Artifact ID");
            this.mainPanel.add(label);
            layout.setConstraints(label, c);
            c.gridx = 1;
            c.weightx = 1.0;
            this.artifactIdField = new JTextField(30);
            this.mainPanel.add(this.artifactIdField);
            layout.setConstraints(this.artifactIdField, c);
        }

        @Override
        public Object getCellEditorValue() {
            return this.selected;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= 2;
            }
            return true;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            PluginCoordinates coords = (PluginCoordinates)value;
            if (coords.groupId != null) {
                this.groupIdField.setText(coords.groupId);
            } else {
                this.groupIdField.setText("");
            }
            this.artifactIdField.setText(coords.artifactId);
            SwingUtilities.invokeLater(() -> {
                int retVal = JOptionPane.showConfirmDialog(table, this.mainPanel, "Select new plugin", 2, -1);
                if (retVal == 2) {
                    this.selected = null;
                    this.fireEditingCanceled();
                } else {
                    this.selected = new PluginCoordinates(this.groupIdField.getText(), this.artifactIdField.getText());
                    this.fireEditingStopped();
                }
            });
            return this.renderer.getTableCellRendererComponent(table, value, isSelected, true, row, column);
        }
    }

    protected class UpgradeStrategyEditor
    extends DefaultCellEditor {
        protected UpgradeStrategyEditor() {
            super(new JComboBox());
            JComboBox combo = (JComboBox)this.getComponent();
            combo.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel renderer = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    renderer.setText(((UpgradeXGAPP.UpgradePath.UpgradeStrategy)((Object)value)).label);
                    renderer.setToolTipText(((UpgradeXGAPP.UpgradePath.UpgradeStrategy)((Object)value)).tooltip);
                    renderer.setIcon((Icon)XgappUpgradeSelector.this.strategyIcons.get(value));
                    renderer.setDisabledIcon(XgappUpgradeSelector.this.disabledStrategyIcon);
                    return renderer;
                }
            });
            combo.setModel(new DefaultComboBoxModel());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JComboBox combo = (JComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            DefaultComboBoxModel model = (DefaultComboBoxModel)combo.getModel();
            model.removeAllElements();
            if (((String)table.getValueAt(row, 0)).startsWith("<html>")) {
                model.addElement(UpgradeXGAPP.UpgradePath.UpgradeStrategy.UPGRADE);
                model.addElement(UpgradeXGAPP.UpgradePath.UpgradeStrategy.PLUGIN_ONLY);
                model.addElement(UpgradeXGAPP.UpgradePath.UpgradeStrategy.SKIP);
            } else {
                model.addElement(UpgradeXGAPP.UpgradePath.UpgradeStrategy.UPGRADE);
                model.addElement(UpgradeXGAPP.UpgradePath.UpgradeStrategy.SKIP);
            }
            combo.setSelectedItem(value);
            return combo;
        }
    }

    protected class UpgradeStrategyRenderer
    extends DefaultTableCellRenderer {
        private JLabel prototype = new DefaultTableCellRenderer();

        protected UpgradeStrategyRenderer() {
            this.prototype.setText(UpgradeXGAPP.UpgradePath.UpgradeStrategy.PLUGIN_ONLY.label);
            this.prototype.setIcon((Icon)XgappUpgradeSelector.this.strategyIcons.get((Object)UpgradeXGAPP.UpgradePath.UpgradeStrategy.PLUGIN_ONLY));
        }

        @Override
        public Dimension getMinimumSize() {
            return this.prototype.getMinimumSize();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel renderer = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            renderer.setText(((UpgradeXGAPP.UpgradePath.UpgradeStrategy)((Object)value)).label);
            renderer.setToolTipText(((UpgradeXGAPP.UpgradePath.UpgradeStrategy)((Object)value)).tooltip);
            renderer.setIcon((Icon)XgappUpgradeSelector.this.strategyIcons.get(value));
            renderer.setDisabledIcon(XgappUpgradeSelector.this.disabledStrategyIcon);
            renderer.setEnabled(((PluginCoordinates)table.getValueAt((int)row, (int)1)).groupId != null);
            return renderer;
        }
    }

    protected class UpgradeVersionEditor
    extends DefaultCellEditor {
        protected UpgradeVersionEditor() {
            super(new JComboBox());
            JComboBox combo = (JComboBox)this.getComponent();
            combo.setModel(new DefaultComboBoxModel());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JComboBox combo = (JComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            DefaultComboBoxModel model = (DefaultComboBoxModel)combo.getModel();
            model.removeAllElements();
            UpgradeXGAPP.UpgradePath path = (UpgradeXGAPP.UpgradePath)table.getValueAt(row, -1);
            for (Version v : path.getVersions()) {
                model.addElement(v);
            }
            combo.setSelectedItem(value);
            return combo;
        }
    }

    protected class UpgradePathTableModel
    extends AbstractTableModel {
        private List<UpgradeXGAPP.UpgradePath> upgrades;
        private int[] namedepths;

        UpgradePathTableModel(List<UpgradeXGAPP.UpgradePath> upgrades) {
            this.upgrades = upgrades;
            this.namedepths = new int[upgrades.size()];
            Arrays.fill(this.namedepths, 0);
            this.refreshDepths();
        }

        private void refreshDepths() {
            boolean finished = false;
            while (!finished) {
                finished = true;
                Map<String, List<Integer>> grouped = IntStream.range(0, this.namedepths.length).boxed().collect(Collectors.groupingBy(i -> (String)this.getValueAt((int)i, 0)));
                for (Map.Entry<String, List<Integer>> e : grouped.entrySet()) {
                    if (e.getValue().size() <= 1) continue;
                    for (Integer i2 : e.getValue()) {
                        if (this.namedepths[i2] >= 2) continue;
                        int n = i2;
                        this.namedepths[n] = this.namedepths[n] + 1;
                        finished = false;
                    }
                }
            }
        }

        @Override
        public int getRowCount() {
            return this.upgrades.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Old plugin";
                }
                case 1: {
                    return "New plugin";
                }
                case 2: {
                    return "Upgrade?";
                }
                case 3: {
                    return "Target version";
                }
            }
            return "UNKNOWN";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return PluginCoordinates.class;
                }
                case 2: {
                    return UpgradeXGAPP.UpgradePath.UpgradeStrategy.class;
                }
                case 3: {
                    return Version.class;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            UpgradeXGAPP.UpgradePath path = this.upgrades.get(rowIndex);
            return columnIndex == 1 || columnIndex == 2 && path.getGroupID() != null || columnIndex == 3 && path.getUpgradeStrategy().upgradePlugin;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            UpgradeXGAPP.UpgradePath path = this.upgrades.get(rowIndex);
            if (columnIndex == 1) {
                List versions;
                PluginCoordinates coords = (PluginCoordinates)aValue;
                VersionRangeResult vrr = UpgradeXGAPP.getPluginVersions(coords.groupId, coords.artifactId);
                List list = versions = vrr == null ? null : vrr.getVersions();
                if (versions != null && !versions.isEmpty()) {
                    path.setGroupID(coords.groupId);
                    path.setArtifactID(coords.artifactId);
                    path.setVersionRangeResult(vrr);
                    path.setUpgradeStrategy(UpgradeXGAPP.UpgradePath.UpgradeStrategy.UPGRADE);
                    this.fireTableCellUpdated(rowIndex, 2);
                    if (!versions.contains(path.getSelectedVersion())) {
                        path.setSelectedVersion(UpgradeXGAPP.getDefaultSelection(vrr));
                        this.fireTableCellUpdated(rowIndex, 3);
                    }
                } else {
                    XgappUpgradeSelector.this.statusLabel.setIcon(XgappUpgradeSelector.this.warningIcon);
                    XgappUpgradeSelector.this.statusLabel.setText(coords + " is not a valid GATE plugin");
                }
            } else if (columnIndex == 2) {
                path.setUpgradeStrategy((UpgradeXGAPP.UpgradePath.UpgradeStrategy)((Object)aValue));
                this.fireTableCellUpdated(rowIndex, 3);
            } else if (columnIndex == 3) {
                path.setSelectedVersion((Version)aValue);
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            UpgradeXGAPP.UpgradePath path = this.upgrades.get(rowIndex);
            if (columnIndex == 0) {
                if (path.getOldPath().startsWith("$gate")) {
                    int startOffset = 18;
                    if (path.getOldPath().startsWith("$gateplugins$")) {
                        startOffset = 13;
                    }
                    return "Pre-8.5 " + path.getOldPath().substring(startOffset, path.getOldPath().length() - 1) + " (built-in)";
                }
                if (path.getOldPath().startsWith("creole:")) {
                    String[] gav = path.getOldPath().substring(9).split(";", 3);
                    if (this.namedepths[rowIndex] == 0) {
                        return gav[1];
                    }
                    if (this.namedepths[rowIndex] == 1) {
                        return gav[1] + ":" + gav[2];
                    }
                    return gav[0] + ":" + gav[1] + ":" + gav[2];
                }
                try {
                    URI oldURI = PersistenceManager.URLHolder.unpackPersistentRepresentation(XgappUpgradeSelector.this.gappUri, path.getOldPath());
                    String[] parts = oldURI.toString().split("/");
                    return "<html><body>Directory plugin \"" + parts[parts.length - 1] + "\"<br><span style='font-size:75%'>" + oldURI + "</span></body></html>";
                }
                catch (PersistenceException e) {
                    return path.getOldPath();
                }
            }
            if (columnIndex == 1) {
                return new PluginCoordinates(path.getGroupID(), path.getArtifactID());
            }
            if (columnIndex == 2) {
                return path.getUpgradeStrategy();
            }
            if (columnIndex == 3) {
                return path.getSelectedVersion();
            }
            return path;
        }
    }
}

