/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Controller;
import gate.CreoleRegister;
import gate.Factory;
import gate.Gate;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.Resource;
import gate.VisualResource;
import gate.creole.AnnotationVisualResource;
import gate.creole.CreoleAnnotationHandler;
import gate.creole.CreoleXmlHandler;
import gate.creole.PackagedController;
import gate.creole.Plugin;
import gate.creole.ResourceData;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.event.PluginListener;
import gate.util.CreoleXmlUpperCaseFilter;
import gate.util.GateClassLoader;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.SAXOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.XMLFilter;

public class CreoleRegisterImpl
extends HashMap<String, ResourceData>
implements CreoleRegister {
    protected static final Logger log = LoggerFactory.getLogger(CreoleRegisterImpl.class);
    protected static final boolean DEBUG = false;
    protected Set<Plugin> plugins;
    protected transient SAXBuilder jdomBuilder = null;
    public static final String PLUGIN_NAMES_MAPPING_FILE = "plugin-mappings.xml";
    protected Map<String, String> pluginNamesMappings = null;
    protected Set<String> lrTypes;
    protected Set<String> prTypes;
    protected List<String> vrTypes;
    protected Set<String> controllerTypes;
    protected Set<String> toolTypes;
    protected Set<String> applicationTypes;
    private transient Vector<CreoleListener> creoleListeners;
    private transient List<PluginListener> pluginListeners = new CopyOnWriteArrayList<PluginListener>();

    public CreoleRegisterImpl() throws GateException {
        this.lrTypes = new HashSet<String>();
        this.prTypes = new HashSet<String>();
        this.vrTypes = new LinkedList<String>();
        this.toolTypes = new HashSet<String>();
        this.applicationTypes = new HashSet<String>();
        this.plugins = new LinkedHashSet<Plugin>();
        this.jdomBuilder = new SAXBuilder(false);
        this.jdomBuilder.setXMLFilter((XMLFilter)new CreoleXmlUpperCaseFilter());
        this.readPluginNamesMappings();
    }

    private void readPluginNamesMappings() {
        if (this.pluginNamesMappings != null) {
            return;
        }
        this.pluginNamesMappings = new HashMap<String, String>();
        SAXBuilder builder = new SAXBuilder();
        try {
            URL creoleDirURL = Gate.getBuiltinCreoleDir();
            URL pluginMappingsFileURL = new URL(creoleDirURL, PLUGIN_NAMES_MAPPING_FILE);
            Document document = builder.build(pluginMappingsFileURL);
            List plugins = document.getRootElement().getChildren("Plugin");
            if (plugins != null) {
                for (Element aPlugin : plugins) {
                    String oldName = aPlugin.getChildText("OldName");
                    String newName = aPlugin.getChildText("NewName");
                    this.pluginNamesMappings.put(oldName, newName);
                }
            }
        }
        catch (JDOMException e) {
            log.warn("plugin-mappings.xml is not well-formed.", (Throwable)e);
        }
        catch (IOException e) {
            log.warn("Could not check plugin-mappings.xml", (Throwable)e);
        }
    }

    @Override
    @Deprecated
    public Set<URL> getDirectories() {
        return Collections.unmodifiableSet(new HashSet());
    }

    @Override
    public void registerPlugin(Plugin plugin) throws GateException {
        this.registerPlugin(plugin, true);
    }

    @Override
    public void registerPlugin(Plugin plugin, boolean loadDependencies) throws GateException {
        if (!this.plugins.contains(plugin)) {
            Gate.addKnownPlugin(plugin);
            try {
                if (loadDependencies) {
                    for (Plugin required : plugin.getRequiredPlugins()) {
                        this.registerPlugin(required, true);
                    }
                }
                Document creoleXML = plugin.getCreoleXML();
                if (!plugin.isValid()) {
                    throw new GateException("plugin is invalid");
                }
                this.parseDirectory(plugin, creoleXML, plugin.getBaseURL(), new URL(plugin.getBaseURL(), "creole.xml"));
                log.info("CREOLE plugin loaded: " + plugin.getName() + " " + plugin.getVersion());
            }
            catch (Throwable e) {
                throw new GateException("couldn't open creole.xml for plugin: " + plugin, e);
            }
            this.plugins.add(plugin);
            this.firePluginLoaded(plugin);
        }
    }

    @Override
    public void registerComponent(Class<? extends Resource> resourceClass) throws GateException {
        try {
            this.registerPlugin(new Plugin.Component(resourceClass));
        }
        catch (MalformedURLException mue) {
            throw new GateException("Unable to register component", mue);
        }
    }

    @Override
    public void registerDirectories(URL directoryUrl, boolean loadDependencies) throws GateException {
        try {
            Plugin.Directory plugin = new Plugin.Directory(directoryUrl);
            this.registerPlugin(plugin);
        }
        catch (Exception e) {
            throw new GateException("Failed to load plugin", e);
        }
    }

    @Override
    public void registerDirectories(URL directoryUrl) throws GateException {
        this.registerDirectories(directoryUrl, true);
    }

    protected void parseDirectory(Plugin plugin, Document jdomDoc, URL directoryUrl, URL creoleFileUrl) throws GateException {
        try {
            CreoleAnnotationHandler annotationHandler = new CreoleAnnotationHandler(plugin);
            GateClassLoader gcl = Gate.getClassLoader().getDisposableClassLoader(plugin.getBaseURI().toString());
            annotationHandler.addJarsToClassLoader(gcl, jdomDoc);
            annotationHandler.createResourceElementsForDirInfo(jdomDoc);
            this.processFullCreoleXmlTree(plugin, jdomDoc, annotationHandler);
        }
        catch (IOException | URISyntaxException e) {
            throw new GateException(e);
        }
        catch (JDOMException je) {
            throw new GateException(je);
        }
    }

    private void processFullCreoleXmlTree(Plugin plugin, Document jdomDoc, CreoleAnnotationHandler annotationHandler) throws GateException, IOException, JDOMException {
        annotationHandler.processAnnotations(jdomDoc);
        CreoleXmlHandler handler = new CreoleXmlHandler(this, plugin);
        SAXOutputter outputter = new SAXOutputter((ContentHandler)handler, (ErrorHandler)handler, (DTDHandler)handler, (EntityResolver)handler);
        outputter.output(jdomDoc);
    }

    @Override
    public void registerBuiltins() throws GateException {
        try {
            URL creoleDirURL = Gate.getBuiltinCreoleDir();
            Plugin.Directory plugin = new Plugin.Directory(creoleDirURL);
            this.parseDirectory(plugin, ((Plugin)plugin).getCreoleXML(), plugin.getBaseURL(), new URL(plugin.getBaseURL(), "creole.xml"));
            log.info("CREOLE plugin loaded: " + ((Plugin)plugin).getName() + " " + plugin.getVersion());
        }
        catch (Exception e) {
            throw new GateException(e);
        }
    }

    @Override
    public ResourceData put(String key, ResourceData rd) {
        if (super.containsKey(key)) {
            ResourceData rData = (ResourceData)super.get(key);
            rData.increaseReferenceCount();
            log.warn(key + " is already defined, new reference will be ignored.");
            return rData;
        }
        Class<? extends Resource> resClass = null;
        try {
            resClass = rd.getResourceClass();
        }
        catch (ClassNotFoundException e) {
            throw new GateRuntimeException("Couldn't get resource class from the resource data:" + e);
        }
        if (LanguageResource.class.isAssignableFrom(resClass)) {
            if (this.lrTypes == null) {
                this.lrTypes = new HashSet<String>();
            }
            this.lrTypes.add(rd.getClassName());
        }
        if (ProcessingResource.class.isAssignableFrom(resClass)) {
            if (this.prTypes == null) {
                this.prTypes = new HashSet<String>();
            }
            this.prTypes.add(rd.getClassName());
        }
        if (VisualResource.class.isAssignableFrom(resClass)) {
            if (this.vrTypes == null) {
                this.vrTypes = new LinkedList<String>();
            }
            if (!this.vrTypes.contains(rd.getClassName())) {
                this.vrTypes.add(rd.getClassName());
            }
        }
        if (Controller.class.isAssignableFrom(resClass)) {
            if (this.controllerTypes == null) {
                this.controllerTypes = new HashSet<String>();
            }
            this.controllerTypes.add(rd.getClassName());
        }
        if (PackagedController.class.isAssignableFrom(resClass)) {
            if (this.applicationTypes == null) {
                this.applicationTypes = new HashSet<String>();
            }
            this.applicationTypes.add(rd.getClassName());
        }
        if (rd.isTool()) {
            if (this.toolTypes == null) {
                this.toolTypes = new HashSet<String>();
            }
            this.toolTypes.add(rd.getClassName());
        }
        return super.put(key, rd);
    }

    @Override
    public void unregisterPlugin(Plugin plugin) {
        if (this.plugins.remove(plugin)) {
            ArrayList<Plugin> dependantPlugins = new ArrayList<Plugin>();
            for (Plugin plugin2 : this.plugins) {
                if (!plugin2.getRequiredPlugins().contains(plugin)) continue;
                dependantPlugins.add(plugin2);
            }
            for (Plugin plugin3 : dependantPlugins) {
                this.unregisterPlugin(plugin3);
            }
            int prCount = 0;
            for (Gate.ResourceInfo rInfo : plugin.getResourceInfoList()) {
                ResourceData rData = (ResourceData)this.get(rInfo.getResourceClassName());
                if (rData != null && rData.getReferenceCount() == 1) {
                    try {
                        List<Resource> loaded = this.getAllInstances(rInfo.getResourceClassName(), true);
                        prCount += loaded.size();
                        for (Resource r : loaded) {
                            Factory.deleteResource(r);
                        }
                    }
                    catch (GateException e) {
                        e.printStackTrace();
                    }
                }
                this.remove(rInfo.getResourceClassName());
            }
            try {
                Gate.getClassLoader().forgetClassLoader(plugin.getBaseURI().toString(), plugin);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            log.info("CREOLE plugin unloaded: " + plugin.getName() + " " + plugin.getVersion());
            if (prCount > 0) {
                log.warn(prCount + " resources were deleted as they relied on the " + plugin.getName() + " plugin");
            }
            this.firePluginUnloaded(plugin);
        }
    }

    @Override
    @Deprecated
    public void removeDirectory(URL directory) {
        if (directory == null) {
            return;
        }
        for (Plugin plugin : this.plugins) {
            if (!directory.equals(plugin.getBaseURL())) continue;
            this.unregisterPlugin(plugin);
            break;
        }
    }

    @Override
    public ResourceData remove(Object key) {
        ResourceData rd = (ResourceData)this.get(key);
        if (rd == null) {
            return null;
        }
        if (rd.reduceReferenceCount() > 0) {
            return rd;
        }
        try {
            if (LanguageResource.class.isAssignableFrom(rd.getResourceClass())) {
                this.lrTypes.remove(rd.getClassName());
            } else if (ProcessingResource.class.isAssignableFrom(rd.getResourceClass())) {
                this.prTypes.remove(rd.getClassName());
            } else if (VisualResource.class.isAssignableFrom(rd.getResourceClass())) {
                this.vrTypes.remove(rd.getClassName());
            } else if (Controller.class.isAssignableFrom(rd.getResourceClass())) {
                this.controllerTypes.remove(rd.getClassName());
            } else if (PackagedController.class.isAssignableFrom(rd.getResourceClass())) {
                this.applicationTypes.remove(rd.getClassName());
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new GateRuntimeException("Could not load class specified in CREOLE data.", cnfe);
        }
        if (rd.isTool()) {
            this.toolTypes.remove(rd.getClassName());
        }
        return (ResourceData)super.remove(key);
    }

    @Override
    public void clear() {
        this.lrTypes.clear();
        this.prTypes.clear();
        this.vrTypes.clear();
        this.toolTypes.clear();
        this.applicationTypes.clear();
        this.plugins.clear();
        super.clear();
    }

    @Override
    public Set<String> getLrTypes() {
        return Collections.unmodifiableSet(this.lrTypes);
    }

    @Override
    public Set<String> getPrTypes() {
        return Collections.unmodifiableSet(this.prTypes);
    }

    @Override
    public Set<String> getVrTypes() {
        return Collections.unmodifiableSet(new HashSet<String>(this.vrTypes));
    }

    @Override
    public Set<String> getControllerTypes() {
        return Collections.unmodifiableSet(this.controllerTypes);
    }

    @Override
    public Set<String> getToolTypes() {
        return Collections.unmodifiableSet(this.toolTypes);
    }

    @Override
    public Set<String> getApplicationTypes() {
        return Collections.unmodifiableSet(this.applicationTypes);
    }

    @Override
    public List<LanguageResource> getLrInstances() {
        Set<String> lrTypeSet = this.getLrTypes();
        ArrayList<LanguageResource> instances = new ArrayList<LanguageResource>();
        for (String type : lrTypeSet) {
            instances.addAll(this.getLrInstances(type));
        }
        return Collections.unmodifiableList(instances);
    }

    @Override
    public List<ProcessingResource> getPrInstances() {
        Set<String> prTypeSet = this.getPrTypes();
        ArrayList<ProcessingResource> instances = new ArrayList<ProcessingResource>();
        for (String type : prTypeSet) {
            instances.addAll(this.getPrInstances(type));
        }
        return Collections.unmodifiableList(instances);
    }

    @Override
    public List<VisualResource> getVrInstances() {
        Set<String> vrTypeSet = this.getVrTypes();
        ArrayList<VisualResource> instances = new ArrayList<VisualResource>();
        for (String type : vrTypeSet) {
            instances.addAll(this.getVrInstances(type));
        }
        return Collections.unmodifiableList(instances);
    }

    @Override
    public List<LanguageResource> getLrInstances(String resourceTypeName) {
        ResourceData resData = (ResourceData)this.get(resourceTypeName);
        if (resData == null) {
            return Collections.emptyList();
        }
        return new TypedResourceList<LanguageResource>(resData.getInstantiations(), LanguageResource.class);
    }

    @Override
    public List<ProcessingResource> getPrInstances(String resourceTypeName) {
        ResourceData resData = (ResourceData)this.get(resourceTypeName);
        if (resData == null) {
            return Collections.emptyList();
        }
        return new TypedResourceList<ProcessingResource>(resData.getInstantiations(), ProcessingResource.class);
    }

    @Override
    public List<VisualResource> getVrInstances(String resourceTypeName) {
        ResourceData resData = (ResourceData)this.get(resourceTypeName);
        if (resData == null) {
            return Collections.emptyList();
        }
        return new TypedResourceList<VisualResource>(resData.getInstantiations(), VisualResource.class);
    }

    @Override
    public List<LanguageResource> getPublicLrInstances() {
        return Collections.unmodifiableList(this.getPublics(this.getLrInstances()));
    }

    @Override
    public List<ProcessingResource> getPublicPrInstances() {
        return Collections.unmodifiableList(this.getPublics(this.getPrInstances()));
    }

    @Override
    public List<VisualResource> getPublicVrInstances() {
        return Collections.unmodifiableList(this.getPublics(this.getVrInstances()));
    }

    @Override
    public List<String> getPublicLrTypes() {
        return Collections.unmodifiableList(this.getPublicTypes(this.getLrTypes()));
    }

    @Override
    public List<String> getPublicPrTypes() {
        return Collections.unmodifiableList(this.getPublicTypes(this.getPrTypes()));
    }

    @Override
    public List<String> getPublicVrTypes() {
        return Collections.unmodifiableList(this.getPublicTypes(this.vrTypes));
    }

    @Override
    public List<String> getPublicControllerTypes() {
        return Collections.unmodifiableList(this.getPublicTypes(this.getControllerTypes()));
    }

    @Override
    public List<Resource> getAllInstances(String type) throws GateException {
        return this.getAllInstances(type, false);
    }

    public List<Resource> getAllInstances(String type, boolean includeHidden) throws GateException {
        Class<Resource> targetClass;
        ArrayList<Resource> res = new ArrayList<Resource>();
        try {
            targetClass = Gate.getClassLoader().loadClass(type).asSubclass(Resource.class);
        }
        catch (ClassNotFoundException cnfe) {
            throw new GateException("Invalid type " + type);
        }
        for (Map.Entry entry : this.entrySet()) {
            String aType = (String)entry.getKey();
            try {
                Class<? extends Resource> aClass = ((ResourceData)entry.getValue()).getResourceClass();
                if (!targetClass.isAssignableFrom(aClass)) continue;
                for (Resource instance : ((ResourceData)this.get(aType)).getInstantiations()) {
                    if (!includeHidden && Gate.getHiddenAttribute(instance.getFeatures())) continue;
                    res.add(instance);
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new GateRuntimeException("A type registered in the creole register does not exist in the VM!");
            }
        }
        return res;
    }

    @Override
    public List<String> getLargeVRsForResource(String resourceClassName) {
        return this.getVRsForResource(resourceClassName, 1);
    }

    @Override
    public List<String> getSmallVRsForResource(String resourceClassName) {
        return this.getVRsForResource(resourceClassName, 2);
    }

    private List<String> getVRsForResource(String resourceClassName, int guiType) {
        if (resourceClassName == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        Class<?> resourceClass = null;
        GateClassLoader classLoader = Gate.getClassLoader();
        try {
            resourceClass = classLoader.loadClass(resourceClassName);
        }
        catch (ClassNotFoundException ex) {
            throw new GateRuntimeException("Couldn't get resource class from the resource name:" + ex);
        }
        LinkedList<String> responseList = new LinkedList<String>();
        String defaultVR = null;
        for (String vrClassName : this.vrTypes) {
            String resourceDisplayed;
            ResourceData vrResourceData = (ResourceData)this.get(vrClassName);
            if (vrResourceData == null) {
                throw new GateRuntimeException("Couldn't get resource data for VR called " + vrClassName);
            }
            if (vrResourceData.getGuiType() != guiType || (resourceDisplayed = vrResourceData.getResourceDisplayed()) == null) continue;
            Class<?> resourceDisplayedClass = null;
            try {
                resourceDisplayedClass = classLoader.loadClass(resourceDisplayed);
            }
            catch (ClassNotFoundException ex) {
                throw new GateRuntimeException("Couldn't get resource class from the resource name :" + resourceDisplayed + " " + ex);
            }
            if (!resourceDisplayedClass.isAssignableFrom(resourceClass)) continue;
            responseList.add(vrClassName);
            if (!vrResourceData.isMainView()) continue;
            defaultVR = vrClassName;
        }
        if (defaultVR != null) {
            responseList.remove(defaultVR);
            responseList.addFirst(defaultVR);
        }
        return Collections.unmodifiableList(responseList);
    }

    @Override
    public List<String> getAnnotationVRs() {
        LinkedList<String> responseList = new LinkedList<String>();
        String defaultVR = null;
        for (String vrClassName : this.vrTypes) {
            ResourceData vrResourceData = (ResourceData)this.get(vrClassName);
            if (vrResourceData == null) {
                throw new GateRuntimeException("Couldn't get resource data for VR called " + vrClassName);
            }
            Class<? extends Resource> vrResourceClass = null;
            try {
                vrResourceClass = vrResourceData.getResourceClass();
            }
            catch (ClassNotFoundException ex) {
                throw new GateRuntimeException("Couldn't create a class object for VR called " + vrClassName);
            }
            if (vrResourceData.getGuiType() != 0 || vrResourceData.getAnnotationTypeDisplayed() != null || vrResourceData.getResourceDisplayed() != null || !AnnotationVisualResource.class.isAssignableFrom(vrResourceClass)) continue;
            responseList.add(vrClassName);
            if (!vrResourceData.isMainView()) continue;
            defaultVR = vrClassName;
        }
        if (defaultVR != null) {
            responseList.remove(defaultVR);
            responseList.addFirst(defaultVR);
        }
        return Collections.unmodifiableList(responseList);
    }

    @Override
    public List<String> getAnnotationVRs(String annotationType) {
        if (annotationType == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        LinkedList<String> responseList = new LinkedList<String>();
        String defaultVR = null;
        for (String vrClassName : this.vrTypes) {
            String annotationTypeDisplayed;
            ResourceData vrResourceData = (ResourceData)this.get(vrClassName);
            if (vrResourceData == null) {
                throw new GateRuntimeException("Couldn't get resource data for VR called " + vrClassName);
            }
            Class<? extends Resource> vrResourceClass = null;
            try {
                vrResourceClass = vrResourceData.getResourceClass();
            }
            catch (ClassNotFoundException ex) {
                throw new GateRuntimeException("Couldn't create a class object for VR called " + vrClassName);
            }
            if (vrResourceData.getGuiType() != 0 || vrResourceData.getAnnotationTypeDisplayed() == null || !AnnotationVisualResource.class.isAssignableFrom(vrResourceClass) || !(annotationTypeDisplayed = vrResourceData.getAnnotationTypeDisplayed()).equals(annotationType)) continue;
            responseList.add(vrClassName);
            if (!vrResourceData.isMainView()) continue;
            defaultVR = vrClassName;
        }
        if (defaultVR != null) {
            responseList.remove(defaultVR);
            responseList.addFirst(defaultVR);
        }
        return Collections.unmodifiableList(responseList);
    }

    @Override
    public void setResourceName(Resource res, String newName) {
        String oldName = res.getName();
        res.setName(newName);
        this.fireResourceRenamed(res, oldName, newName);
    }

    @Override
    public List<String> getVREnabledAnnotationTypes() {
        LinkedList<String> responseList = new LinkedList<String>();
        for (String vrClassName : this.vrTypes) {
            ResourceData vrResourceData = (ResourceData)this.get(vrClassName);
            if (vrResourceData == null) {
                throw new GateRuntimeException("Couldn't get resource data for VR called " + vrClassName);
            }
            if (vrResourceData.getGuiType() != 0 || vrResourceData.getAnnotationTypeDisplayed() == null) continue;
            String annotationTypeDisplayed = vrResourceData.getAnnotationTypeDisplayed();
            responseList.add(annotationTypeDisplayed);
        }
        return Collections.unmodifiableList(responseList);
    }

    protected <T> List<T> getPublics(List<T> instances) {
        Iterator<T> iter = instances.iterator();
        ArrayList<T> publics = new ArrayList<T>();
        while (iter.hasNext()) {
            T res = iter.next();
            ResourceData rd = (ResourceData)this.get(res.getClass().getName());
            if (rd.isPrivate()) continue;
            publics.add(res);
        }
        return Collections.unmodifiableList(publics);
    }

    protected List<String> getPublicTypes(Collection<String> types) {
        Iterator<String> iter = types.iterator();
        ArrayList<String> publics = new ArrayList<String>();
        while (iter.hasNext()) {
            String oneType = iter.next();
            ResourceData rData = (ResourceData)this.get(oneType);
            if (rData == null || rData.isPrivate()) continue;
            publics.add(oneType);
        }
        return Collections.unmodifiableList(publics);
    }

    @Override
    public synchronized void removeCreoleListener(CreoleListener l) {
        if (this.creoleListeners != null && this.creoleListeners.contains(l)) {
            Vector v = (Vector)this.creoleListeners.clone();
            v.removeElement(l);
            this.creoleListeners = v;
        }
    }

    @Override
    public synchronized void addCreoleListener(CreoleListener l) {
        Vector v;
        Vector vector = v = this.creoleListeners == null ? new Vector(2) : (Vector)this.creoleListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.creoleListeners = v;
        }
    }

    protected void firePluginLoaded(Plugin plugin) {
        for (PluginListener listener : this.pluginListeners) {
            listener.pluginLoaded(plugin);
        }
    }

    protected void firePluginUnloaded(Plugin plugin) {
        for (PluginListener listener : this.pluginListeners) {
            listener.pluginUnloaded(plugin);
        }
    }

    @Override
    public void addPluginListener(PluginListener listener) {
        this.pluginListeners.add(listener);
    }

    @Override
    public void removePluginListener(PluginListener listener) {
        this.pluginListeners.remove(listener);
    }

    protected void fireResourceLoaded(CreoleEvent e) {
        if (this.creoleListeners != null) {
            Vector<CreoleListener> listeners = this.creoleListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).resourceLoaded(e);
            }
        }
    }

    protected void fireResourceUnloaded(CreoleEvent e) {
        if (this.creoleListeners != null) {
            Vector<CreoleListener> listeners = this.creoleListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).resourceUnloaded(e);
            }
        }
    }

    protected void fireResourceRenamed(Resource res, String oldName, String newName) {
        if (this.creoleListeners != null) {
            Vector<CreoleListener> listeners = this.creoleListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).resourceRenamed(res, oldName, newName);
            }
        }
    }

    protected void fireDatastoreOpened(CreoleEvent e) {
        if (this.creoleListeners != null) {
            Vector<CreoleListener> listeners = this.creoleListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).datastoreOpened(e);
            }
        }
    }

    protected void fireDatastoreCreated(CreoleEvent e) {
        if (this.creoleListeners != null) {
            Vector<CreoleListener> listeners = this.creoleListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).datastoreCreated(e);
            }
        }
    }

    protected void fireDatastoreClosed(CreoleEvent e) {
        if (this.creoleListeners != null) {
            Vector<CreoleListener> listeners = this.creoleListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).datastoreClosed(e);
            }
        }
    }

    @Override
    public void resourceLoaded(CreoleEvent e) {
        this.fireResourceLoaded(e);
    }

    @Override
    public void resourceUnloaded(CreoleEvent e) {
        this.fireResourceUnloaded(e);
    }

    @Override
    public void resourceRenamed(Resource resource, String oldName, String newName) {
        this.fireResourceRenamed(resource, oldName, newName);
    }

    @Override
    public void datastoreOpened(CreoleEvent e) {
        this.fireDatastoreOpened(e);
    }

    @Override
    public void datastoreCreated(CreoleEvent e) {
        this.fireDatastoreCreated(e);
    }

    @Override
    public void datastoreClosed(CreoleEvent e) {
        this.fireDatastoreClosed(e);
    }

    @Override
    public Set<Plugin> getPlugins() {
        return Collections.unmodifiableSet(this.plugins);
    }

    private static class TypedResourceList<T extends Resource>
    extends AbstractList<T> {
        private List<Resource> backingList;
        private Class<T> realType;

        TypedResourceList(List<Resource> backingList, Class<T> realType) {
            this.backingList = backingList;
            this.realType = realType;
        }

        @Override
        public T get(int i) {
            return (T)((Resource)this.realType.cast(this.backingList.get(i)));
        }

        @Override
        public int size() {
            return this.backingList.size();
        }
    }
}

