/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Factory;
import gate.LanguageAnalyser;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.AbstractController;
import gate.creole.AbstractResource;
import gate.creole.AnalyserRunningStrategy;
import gate.creole.ConditionalController;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.RunningStrategy;
import gate.creole.SerialController;
import gate.creole.metadata.CreoleResource;
import gate.event.ControllerEvent;
import gate.util.Benchmark;
import gate.util.Err;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

@CreoleResource(name="Conditional Pipeline", comment="A simple serial controller for conditionally run PRs.", helpURL="http://gate.ac.uk/userguide/sec:developer:cond")
public class ConditionalSerialController
extends SerialController
implements ConditionalController {
    private static final long serialVersionUID = -3791943170768459208L;
    protected List<RunningStrategy> strategiesList = new ArrayList<RunningStrategy>();

    @Override
    public List<RunningStrategy> getRunningStrategies() {
        return Collections.unmodifiableList(this.strategiesList);
    }

    @Override
    public void add(int index, ProcessingResource pr) {
        if (pr instanceof LanguageAnalyser) {
            this.strategiesList.add(index, new AnalyserRunningStrategy((LanguageAnalyser)pr, 1, null, null));
        } else {
            this.strategiesList.add(index, new RunningStrategy.UnconditionalRunningStrategy(pr, true));
        }
        super.add(index, pr);
    }

    @Override
    public void add(ProcessingResource pr) {
        if (pr instanceof LanguageAnalyser) {
            this.strategiesList.add(new AnalyserRunningStrategy((LanguageAnalyser)pr, 1, null, null));
        } else {
            this.strategiesList.add(new RunningStrategy.UnconditionalRunningStrategy(pr, true));
        }
        super.add(pr);
    }

    @Override
    public ProcessingResource remove(int index) {
        ProcessingResource aPr = super.remove(index);
        this.strategiesList.remove(index);
        this.fireResourceRemoved(new ControllerEvent(this, 1, aPr));
        return aPr;
    }

    @Override
    public boolean remove(ProcessingResource pr) {
        int index = this.prList.indexOf(pr);
        if (index != -1) {
            this.prList.remove(index);
            this.strategiesList.remove(index);
            this.fireResourceRemoved(new ControllerEvent(this, 1, pr));
            return true;
        }
        return false;
    }

    public void setRunningStrategy(int index, AnalyserRunningStrategy strategy) {
        this.strategiesList.set(index, strategy);
    }

    @Override
    public void setRunningStrategies(Collection<RunningStrategy> strategies) {
        this.strategiesList.clear();
        Iterator<RunningStrategy> stratIter = strategies.iterator();
        while (stratIter.hasNext()) {
            this.strategiesList.add(stratIter.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runComponent(int componentIndex) throws ExecutionException {
        ProcessingResource currentPR = (ProcessingResource)this.prList.get(componentIndex);
        HashMap<String, EventListener> listeners = new HashMap<String, EventListener>();
        listeners.put("gate.event.StatusListener", this.sListener);
        int componentProgress = 100 / this.prList.size();
        listeners.put("gate.event.ProgressListener", new AbstractController.IntervalProgressListener(componentIndex * componentProgress, (componentIndex + 1) * componentProgress));
        try {
            AbstractResource.setResourceListeners(currentPR, listeners);
        }
        catch (Exception e) {
            Err.prln("Could not set listeners for " + currentPR.getClass().getName() + "\n" + e.toString() + "\n...nothing to lose any sleep over.");
        }
        try {
            if (this.strategiesList.get(componentIndex).shouldRun()) {
                this.benchmarkFeatures.put("prName", currentPR.getName());
                long startTime = System.currentTimeMillis();
                Benchmark.executeWithBenchmarking(currentPR, Benchmark.createBenchmarkId("pr_" + currentPR.getName(), this.getBenchmarkId()), this, this.benchmarkFeatures);
                this.benchmarkFeatures.remove("prName");
                long timeTakenByThePR = System.currentTimeMillis() - startTime;
                Long time = (Long)this.prTimeMap.get(currentPR.getName());
                if (time == null) {
                    time = 0L;
                }
                time = time + timeTakenByThePR;
                this.prTimeMap.put(currentPR.getName(), time);
            }
        }
        finally {
            try {
                AbstractResource.removeResourceListeners(currentPR, listeners);
            }
            catch (Exception e) {
                Err.prln("Could not clear listeners for " + currentPR.getClass().getName() + "\n" + e.toString() + "\n...nothing to lose any sleep over.");
            }
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.strategiesList.clear();
    }

    @Override
    public Resource duplicate(Factory.DuplicationContext ctx) throws ResourceInstantiationException {
        ConditionalController c = (ConditionalController)super.duplicate(ctx);
        Collection<ProcessingResource> newPRs = c.getPRs();
        ArrayList<RunningStrategy> newStrategies = new ArrayList<RunningStrategy>(this.strategiesList.size());
        Iterator<RunningStrategy> oldRSIt = this.getRunningStrategies().iterator();
        Iterator<ProcessingResource> prIt = newPRs.iterator();
        while (oldRSIt.hasNext()) {
            RunningStrategy oldStrat = oldRSIt.next();
            ProcessingResource currentPR = prIt.next();
            if (oldStrat instanceof AnalyserRunningStrategy) {
                newStrategies.add(new AnalyserRunningStrategy((LanguageAnalyser)currentPR, ((AnalyserRunningStrategy)oldStrat).getRunMode(), ((AnalyserRunningStrategy)oldStrat).getFeatureName(), ((AnalyserRunningStrategy)oldStrat).getFeatureValue()));
                continue;
            }
            boolean run = true;
            if (oldStrat instanceof RunningStrategy.UnconditionalRunningStrategy) {
                run = oldStrat.shouldRun();
            }
            newStrategies.add(new RunningStrategy.UnconditionalRunningStrategy(currentPR, run));
        }
        c.setRunningStrategies(newStrategies);
        return c;
    }
}

